/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.crafting.CombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.CombinationRecipeManager;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.common.util.RecipeMatcher;
import org.apache.commons.lang3.ArrayUtils;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.util.PatternHelper;
import thelm.packagedexcrafting.recipe.IRecipeInfoCombination;
import thelm.packagedexcrafting.recipe.RecipeTypeCombination;

public class RecipeInfoCombination
implements IRecipeInfoCombination {
    CombinationRecipe recipe;
    ItemStack inputCore = ItemStack.field_190927_a;
    List<ItemStack> inputPedestal = new ArrayList<ItemStack>();
    List<ItemStack> input = new ArrayList<ItemStack>();
    ItemStack output;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public void readFromNBT(NBTTagCompound nbt) {
        this.inputPedestal.clear();
        this.input.clear();
        this.output = ItemStack.field_190927_a;
        this.inputCore = new ItemStack(nbt.func_74775_l("InputCore"));
        MiscUtil.loadAllItems((NBTTagList)nbt.func_150295_c("InputPedestal", 10), this.inputPedestal);
        this.patterns.clear();
        if (this.inputPedestal.isEmpty()) {
            return;
        }
        for (CombinationRecipe recipe : CombinationRecipeManager.getInstance().getRecipes()) {
            List matchers;
            ItemStack inputStack = recipe.getInput();
            if (inputStack.func_190926_b() || !inputStack.func_77969_a(this.inputCore) || recipe.getPedestalItems().size() != this.inputPedestal.size() || RecipeMatcher.findMatches(this.inputPedestal, (List)(matchers = Lists.transform((List)recipe.getPedestalItems(), RecipeInfoCombination::getIngredient))) == null) continue;
            this.recipe = recipe;
            break;
        }
        if (this.recipe != null) {
            ArrayList<ItemStack> toCondense = new ArrayList<ItemStack>(this.inputPedestal);
            toCondense.add(this.inputCore);
            this.input.addAll(MiscUtil.condenseStacks(toCondense));
            this.output = this.recipe.getOutput().func_77946_l();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PatternHelper((IRecipeInfo)this, i));
                ++i;
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound inputCoreTag = this.inputCore.func_77955_b(new NBTTagCompound());
        NBTTagList inputPedestalTag = MiscUtil.saveAllItems((NBTTagList)new NBTTagList(), this.inputPedestal);
        nbt.func_74782_a("InputCore", (NBTBase)inputCoreTag);
        nbt.func_74782_a("InputPedestal", (NBTBase)inputPedestalTag);
        return nbt;
    }

    public IRecipeType getRecipeType() {
        return RecipeTypeCombination.INSTANCE;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public ItemStack getCoreInput() {
        return this.inputCore.func_77946_l();
    }

    @Override
    public List<ItemStack> getPedestalInputs() {
        return Collections.unmodifiableList(this.inputPedestal);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public long getEnergyRequired() {
        return this.recipe.getCost();
    }

    @Override
    public int getEnergyUsage() {
        return this.recipe.getPerTick();
    }

    @Override
    public CombinationRecipe getRecipe() {
        return this.recipe;
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.recipe = null;
        this.inputCore = ItemStack.field_190927_a;
        this.inputPedestal.clear();
        this.input.clear();
        this.patterns.clear();
        int[] slotArray = RecipeTypeCombination.SLOTS.toIntArray();
        ArrayUtils.shift((int[])slotArray, (int)0, (int)25, (int)1);
        for (int i = 0; i < 49; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            if (!toSet.func_190926_b()) {
                toSet.func_190920_e(1);
                if (i == 0) {
                    this.inputCore = toSet.func_77946_l();
                    continue;
                }
                this.inputPedestal.add(toSet.func_77946_l());
                continue;
            }
            if (i != 0) continue;
            return;
        }
        for (CombinationRecipe recipe : CombinationRecipeManager.getInstance().getRecipes()) {
            List matchers;
            ItemStack inputStack = recipe.getInput();
            if (inputStack.func_190926_b() || !inputStack.func_77969_a(this.inputCore) || recipe.getPedestalItems().size() != this.inputPedestal.size() || RecipeMatcher.findMatches(this.inputPedestal, (List)(matchers = Lists.transform((List)recipe.getPedestalItems(), RecipeInfoCombination::getIngredient))) == null) continue;
            this.recipe = recipe;
            ArrayList<ItemStack> toCondense = new ArrayList<ItemStack>(this.inputPedestal);
            toCondense.add(this.inputCore);
            this.input.addAll(MiscUtil.condenseStacks(toCondense));
            this.output = recipe.getOutput().func_77946_l();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PatternHelper((IRecipeInfo)this, i));
                ++i;
            }
            return;
        }
    }

    protected static Ingredient getIngredient(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return stack.func_77942_o() ? new IngredientNBT(stack){} : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
        }
        if (obj instanceof List) {
            return Ingredient.func_193369_a((ItemStack[])((ItemStack[])((List)obj).stream().toArray(ItemStack[]::new)));
        }
        return CraftingHelper.getIngredient((Object)obj);
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = RecipeTypeCombination.SLOTS.toIntArray();
        ArrayUtils.remove((int[])slotArray, (int)24);
        map.put(40, (Object)this.inputCore);
        for (int i = 0; i < this.inputPedestal.size(); ++i) {
            map.put(slotArray[i], (Object)this.inputPedestal.get(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeInfoCombination) {
            RecipeInfoCombination other = (RecipeInfoCombination)obj;
            for (int i = 0; i < this.input.size(); ++i) {
                if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)this.input.get(i), (ItemStack)other.input.get(i))) continue;
                return false;
            }
            return this.recipe.equals(other.recipe);
        }
        return false;
    }

    public int hashCode() {
        Object[] toHash = new Object[2];
        Object[] inputArray = new Object[this.input.size()];
        for (int i = 0; i < this.input.size(); ++i) {
            ItemStack stack = this.input.get(i);
            inputArray[i] = new Object[]{stack.func_77973_b(), stack.func_77952_i(), stack.func_190916_E(), stack.func_77978_p()};
        }
        toHash[0] = this.recipe;
        toHash[1] = inputArray;
        return Arrays.deepHashCode(toHash);
    }
}

