/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.server.interact;

import com.creativemd.littletiles.common.action.interact.LittleInteraction;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class LittleInteractionHandlerServer {
    protected HashMap<EntityPlayer, LittleInteraction> interactions = new HashMap();

    public LittleInteractionHandlerServer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void start(EntityPlayer player, int index, boolean rightclick) {
        this.interactions.put(player, new LittleInteraction(index, rightclick));
    }

    public void end(EntityPlayer player, int index) {
        LittleInteraction interaction = this.interactions.get(player);
        if (interaction != null && interaction.index <= index) {
            this.interactions.remove(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void interact(PlayerInteractEvent event) {
        if (!event.getWorld().field_72995_K && this.interactions.containsKey(event.getEntityPlayer())) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.interactions.remove(event.player);
    }
}

