/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.vec;

import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SurroundingBox {
    protected World world;
    protected int count = 0;
    protected LittleGridContext context = LittleGridContext.getMin();
    protected long minX = Long.MAX_VALUE;
    protected long minY = Long.MAX_VALUE;
    protected long minZ = Long.MAX_VALUE;
    protected long maxX = Long.MIN_VALUE;
    protected long maxY = Long.MIN_VALUE;
    protected long maxZ = Long.MIN_VALUE;
    protected int minYPos = Integer.MAX_VALUE;
    protected int maxYPos = Integer.MIN_VALUE;
    protected boolean mapScannedLists = false;
    protected HashMap<BlockPos, Iterable<LittleTile>> map = new HashMap();

    public SurroundingBox(boolean mapScannedLists, World world) {
        this.mapScannedLists = mapScannedLists;
        this.world = world;
    }

    public void clear() {
        this.count = 0;
        this.context = LittleGridContext.getMin();
        this.minX = Long.MAX_VALUE;
        this.minY = Long.MAX_VALUE;
        this.minZ = Long.MAX_VALUE;
        this.maxX = Long.MIN_VALUE;
        this.maxY = Long.MIN_VALUE;
        this.maxZ = Long.MIN_VALUE;
        this.minYPos = Integer.MAX_VALUE;
        this.maxYPos = Integer.MIN_VALUE;
        this.map.clear();
    }

    public void convertTo(LittleGridContext to) {
        if (this.count == 0) {
            this.context = to;
            return;
        }
        if (this.context.size > to.size) {
            int modifier = this.context.size / to.size;
            this.minX /= (long)modifier;
            this.minY /= (long)modifier;
            this.minZ /= (long)modifier;
            this.maxX /= (long)modifier;
            this.maxY /= (long)modifier;
            this.maxZ /= (long)modifier;
        } else {
            int modifier = to.size / this.context.size;
            this.minX *= (long)modifier;
            this.minY *= (long)modifier;
            this.minZ *= (long)modifier;
            this.maxX *= (long)modifier;
            this.maxY *= (long)modifier;
            this.maxZ *= (long)modifier;
        }
        this.context = to;
    }

    protected boolean insertContext(LittleGridContext to) {
        if (this.context.size > to.size) {
            return false;
        }
        if (this.context.size < to.size) {
            this.convertTo(to);
        }
        return true;
    }

    public SurroundingBox add(IStructureTileList list) {
        this.add(list.getContext(), list.getPos(), list);
        return this;
    }

    public SurroundingBox add(LittleGridContext context, BlockPos pos, Iterable<LittleTile> tiles) {
        int modifier = 1;
        if (!this.insertContext(context)) {
            modifier = this.context.size / context.size;
        }
        for (LittleTile tile : tiles) {
            this.add(tile.getBox(), modifier, pos);
        }
        if (this.mapScannedLists) {
            this.map.put(pos, tiles);
        }
        return this;
    }

    protected void add(LittleBox box, int modifier, BlockPos pos) {
        this.minX = Math.min(this.minX, (long)(pos.func_177958_n() * this.context.size + box.minX * modifier));
        this.minY = Math.min(this.minY, (long)(pos.func_177956_o() * this.context.size + box.minY * modifier));
        this.minZ = Math.min(this.minZ, (long)(pos.func_177952_p() * this.context.size + box.minZ * modifier));
        this.maxX = Math.max(this.maxX, (long)(pos.func_177958_n() * this.context.size + box.maxX * modifier));
        this.maxY = Math.max(this.maxY, (long)(pos.func_177956_o() * this.context.size + box.maxY * modifier));
        this.maxZ = Math.max(this.maxZ, (long)(pos.func_177952_p() * this.context.size + box.maxZ * modifier));
        this.minYPos = Math.min(this.minYPos, pos.func_177956_o());
        this.maxYPos = Math.max(this.maxYPos, pos.func_177956_o());
        ++this.count;
    }

    public LittleAbsoluteBox getAbsoluteBox() {
        BlockPos pos = this.getMinPos();
        return new LittleAbsoluteBox(pos, new LittleBox((int)(this.minX - (long)this.context.toGrid(pos.func_177958_n())), (int)(this.minY - (long)this.context.toGrid(pos.func_177956_o())), (int)(this.minZ - (long)this.context.toGrid(pos.func_177952_p())), (int)(this.maxX - (long)this.context.toGrid(pos.func_177958_n())), (int)(this.maxY - (long)this.context.toGrid(pos.func_177956_o())), (int)(this.maxZ - (long)this.context.toGrid(pos.func_177952_p()))), this.context);
    }

    public AxisAlignedBB getAABB() {
        return new AxisAlignedBB(this.context.toVanillaGrid(this.minX), this.context.toVanillaGrid(this.minY), this.context.toVanillaGrid(this.minZ), this.context.toVanillaGrid(this.maxX), this.context.toVanillaGrid(this.maxY), this.context.toVanillaGrid(this.maxZ));
    }

    public double getPercentVolume() {
        return 0.125 * this.context.toVanillaGrid(this.minX + this.maxX) * this.context.toVanillaGrid(this.minY + this.maxY) * this.context.toVanillaGrid(this.minZ + this.maxZ);
    }

    public LittleAbsoluteVec getHighestCenterPoint() {
        int centerX = (int)Math.floor((double)(this.minX + this.maxX) / (double)this.context.size / 2.0);
        int centerY = (int)Math.floor((double)(this.minY + this.maxY) / (double)this.context.size / 2.0);
        int centerZ = (int)Math.floor((double)(this.minZ + this.maxZ) / (double)this.context.size / 2.0);
        int centerTileX = (int)(Math.floor(this.minX + this.maxX) / 2.0) - centerX * this.context.size;
        int centerTileY = (int)(Math.floor(this.minY + this.maxY) / 2.0) - centerY * this.context.size;
        int centerTileZ = (int)(Math.floor(this.minZ + this.maxZ) / 2.0) - centerZ * this.context.size;
        LittleAbsoluteVec pos = new LittleAbsoluteVec(new BlockPos(centerX, this.minYPos, centerZ), this.context, new LittleVec(centerTileX, 0, centerTileZ));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int y = this.minYPos; y <= this.maxYPos; ++y) {
            Iterable<LittleTile> tilesInCenter = this.map.get(blockPos.func_181079_c(centerX, y, centerZ));
            if (tilesInCenter == null) continue;
            TileEntityLittleTiles te = this.getTe((BlockPos)blockPos);
            te.convertTo(this.context);
            LittleBox box = new LittleBox(centerTileX, 0, centerTileZ, centerTileX + 1, this.context.maxPos, centerTileZ + 1);
            if (this.context.size <= centerTileX) {
                box.minX = this.context.size - 1;
                box.maxX = this.context.size;
            }
            if (this.context.size <= centerTileZ) {
                box.minZ = this.context.size - 1;
                box.maxZ = this.context.size;
            }
            for (LittleTile tile : tilesInCenter) {
                LittleBox littleBox = tile.getCollisionBox();
                if (littleBox == null || !LittleBox.intersectsWith(box, littleBox)) continue;
                pos.overwriteContext(te.getContext());
                pos.getVec().y = Math.max((y - this.minYPos) * this.context.size + littleBox.maxY, pos.getVec().y);
            }
            te.convertToSmallest();
        }
        pos.removeInternalBlockOffset();
        pos.convertToSmallest();
        return pos;
    }

    public Vec3d getHighestCenterVec() {
        int centerX = (int)Math.floor((double)(this.minX + this.maxX) / (double)this.context.size / 2.0);
        int centerY = (int)Math.floor((double)(this.minY + this.maxY) / (double)this.context.size / 2.0);
        int centerZ = (int)Math.floor((double)(this.minZ + this.maxZ) / (double)this.context.size / 2.0);
        int centerTileX = (int)(Math.floor(this.minX + this.maxX) / 2.0) - centerX * this.context.size;
        int centerTileY = (int)(Math.floor(this.minY + this.maxY) / 2.0) - centerY * this.context.size;
        int centerTileZ = (int)(Math.floor(this.minZ + this.maxZ) / 2.0) - centerZ * this.context.size;
        LittleAbsoluteVec pos = new LittleAbsoluteVec(new BlockPos(centerX, this.minYPos, centerZ), this.context, new LittleVec(centerTileX, 0, centerTileZ));
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int y = this.minYPos; y <= this.maxYPos; ++y) {
            Iterable<LittleTile> tilesInCenter = this.map.get(blockPos.func_181079_c(centerX, y, centerZ));
            if (tilesInCenter == null) continue;
            TileEntityLittleTiles te = this.getTe((BlockPos)blockPos);
            te.convertTo(this.context);
            LittleBox box = new LittleBox(centerTileX, 0, centerTileZ, centerTileX + 1, this.context.maxPos, centerTileZ + 1);
            if (this.context.size >= centerTileX) {
                box.minX = this.context.size - 1;
                box.maxX = this.context.size;
            }
            if (this.context.size >= centerTileZ) {
                box.minZ = this.context.size - 1;
                box.maxZ = this.context.size;
            }
            for (LittleTile tile : tilesInCenter) {
                LittleBox littleBox = tile.getCollisionBox();
                if (littleBox == null || !LittleBox.intersectsWith(box, littleBox)) continue;
                pos.overwriteContext(te.getContext());
                pos.getVec().y = Math.max((y - this.minYPos) * this.context.size + littleBox.maxY, pos.getVec().y);
            }
            te.convertToSmallest();
        }
        return new Vec3d(this.context.toVanillaGrid((double)(this.minX + this.maxX) / 2.0), pos.getPosY(), this.context.toVanillaGrid((double)(this.minZ + this.maxZ) / 2.0));
    }

    private TileEntityLittleTiles getTe(BlockPos pos) {
        TileEntity tileEntity = this.world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        throw new RuntimeException("TileEntity does not exist anymore");
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMinY() {
        return this.minY;
    }

    public long getMinZ() {
        return this.minZ;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getMaxZ() {
        return this.maxZ;
    }

    public long getMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0L;
    }

    public long getMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0L;
    }

    public LittleVec getMinPosOffset() {
        return new LittleVec((int)(this.minX - (long)(this.context.toBlockOffset(this.minX) * this.context.size)), (int)(this.minY - (long)(this.context.toBlockOffset(this.minY) * this.context.size)), (int)(this.minZ - (long)(this.context.toBlockOffset(this.minZ) * this.context.size)));
    }

    public LittleVec getMaxPosOffset() {
        return new LittleVec((int)(this.maxX - (long)(this.context.toBlockOffset(this.maxX) * this.context.size)), (int)(this.maxY - (long)(this.context.toBlockOffset(this.maxY) * this.context.size)), (int)(this.maxZ - (long)(this.context.toBlockOffset(this.maxZ) * this.context.size)));
    }

    public LittleVec getSize() {
        return new LittleVec((int)(this.maxX - this.minX), (int)(this.maxY - this.minY), (int)(this.maxZ - this.minZ));
    }

    public BlockPos getMinPos() {
        return new BlockPos(this.context.toBlockOffset(this.minX), this.context.toBlockOffset(this.minY), this.context.toBlockOffset(this.minZ));
    }

    public BlockPos getMaxPos() {
        return new BlockPos(this.context.toBlockOffset(this.maxX), this.context.toBlockOffset(this.maxY), this.context.toBlockOffset(this.maxZ));
    }

    public LittleGridContext getContext() {
        return this.context;
    }

    public int count() {
        return this.count;
    }
}

