/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.vec;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.vec.IVecInt;
import com.creativemd.creativecore.common.utils.math.vec.Vec3;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.security.InvalidParameterException;
import javax.vecmath.Vector3d;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class LittleVec
implements IVecInt {
    public static final LittleVec ZERO = new LittleVec(0, 0, 0);
    public int x;
    public int y;
    public int z;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LittleVec(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "x") instanceof NBTTagByte) {
            this.set(nbt.func_74771_c(name + "x"), nbt.func_74771_c(name + "y"), nbt.func_74771_c(name + "z"));
            this.writeToNBT(name, nbt);
            return;
        }
        if (nbt.func_74781_a(name + "x") instanceof NBTTagInt) {
            this.set(nbt.func_74762_e(name + "x"), nbt.func_74762_e(name + "y"), nbt.func_74762_e(name + "z"));
            return;
        }
        if (nbt.func_74781_a(name) instanceof NBTTagIntArray) {
            int[] array = nbt.func_74759_k(name);
            if (array.length != 3) throw new InvalidParameterException("No valid coords given " + nbt);
            this.set(array[0], array[1], array[2]);
            return;
        }
        if (!(nbt.func_74781_a(name) instanceof NBTTagString)) return;
        String[] coords = nbt.func_74779_i(name).split("\\.");
        try {
            this.set(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
            return;
        }
        catch (Exception e) {
            this.set(0, 0, 0);
        }
    }

    public LittleVec(LittleGridContext context, RayTraceResult result) {
        this(context, result.field_72307_f, result.field_178784_b);
    }

    public LittleVec(LittleGridContext context, Vec3d vec, EnumFacing facing) {
        this(context, vec);
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE && !context.isAtEdge(VectorUtils.get((EnumFacing.Axis)facing.func_176740_k(), (Vec3d)vec))) {
            this.set(facing.func_176740_k(), this.get(facing.func_176740_k()) + 1);
        }
    }

    public LittleVec(LittleGridContext context, Vec3 vec) {
        this.x = context.toGrid(vec.x);
        this.y = context.toGrid(vec.y);
        this.z = context.toGrid(vec.z);
    }

    public LittleVec(LittleGridContext context, Vec3d vec) {
        this.x = context.toGrid(vec.field_72450_a);
        this.y = context.toGrid(vec.field_72448_b);
        this.z = context.toGrid(vec.field_72449_c);
    }

    public LittleVec(LittleGridContext context, Vector3d vec) {
        this.x = context.toGrid(vec.x);
        this.y = context.toGrid(vec.y);
        this.z = context.toGrid(vec.z);
    }

    public LittleVec(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                this.set(1, 0, 0);
                break;
            }
            case WEST: {
                this.set(-1, 0, 0);
                break;
            }
            case UP: {
                this.set(0, 1, 0);
                break;
            }
            case DOWN: {
                this.set(0, -1, 0);
                break;
            }
            case SOUTH: {
                this.set(0, 0, 1);
                break;
            }
            case NORTH: {
                this.set(0, 0, -1);
                break;
            }
            default: {
                this.set(0, 0, 0);
            }
        }
    }

    public LittleVec(int x, int y, int z) {
        this.set(x, y, z);
    }

    public LittleVec(LittleGridContext context, Vec3i vec) {
        this(context.toGrid(vec.func_177958_n()), context.toGrid(vec.func_177956_o()), context.toGrid(vec.func_177952_p()));
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(LittleGridContext context, Vec3i vec) {
        this.set(context.toGrid(vec.func_177958_n()), context.toGrid(vec.func_177956_o()), context.toGrid(vec.func_177952_p()));
    }

    public int getSmallestContext(LittleGridContext context) {
        int size = LittleGridContext.minSize;
        size = Math.max(size, context.getMinGrid(this.x));
        size = Math.max(size, context.getMinGrid(this.y));
        size = Math.max(size, context.getMinGrid(this.z));
        return size;
    }

    public void convertTo(LittleGridContext from, LittleGridContext to) {
        if (from.size > to.size) {
            int ratio = from.size / to.size;
            this.x /= ratio;
            this.y /= ratio;
            this.z /= ratio;
        } else {
            int ratio = to.size / from.size;
            this.x *= ratio;
            this.y *= ratio;
            this.z *= ratio;
        }
    }

    public BlockPos getBlockPos(LittleGridContext context) {
        return new BlockPos((int)Math.floor(context.toVanillaGrid(this.x)), (int)Math.floor(context.toVanillaGrid(this.y)), (int)Math.floor(context.toVanillaGrid(this.z)));
    }

    public Vec3d getVec(LittleGridContext context) {
        return new Vec3d(context.toVanillaGrid(this.x), context.toVanillaGrid(this.y), context.toVanillaGrid(this.z));
    }

    public Vector3d getVector(LittleGridContext context) {
        return new Vector3d(context.toVanillaGrid(this.x), context.toVanillaGrid(this.y), context.toVanillaGrid(this.z));
    }

    public double getPosX(LittleGridContext context) {
        return context.toVanillaGrid(this.x);
    }

    public double getPosY(LittleGridContext context) {
        return context.toVanillaGrid(this.y);
    }

    public double getPosZ(LittleGridContext context) {
        return context.toVanillaGrid(this.z);
    }

    public void add(EnumFacing facing) {
        this.set(facing.func_176740_k(), this.get(facing.func_176740_k()) + facing.func_176743_c().func_179524_a());
    }

    public void add(LittleVec vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    public void add(BlockPos pos, LittleGridContext context) {
        this.x += context.toGrid(pos.func_177958_n());
        this.y += context.toGrid(pos.func_177956_o());
        this.z += context.toGrid(pos.func_177952_p());
    }

    public void sub(EnumFacing facing) {
        this.set(facing.func_176740_k(), this.get(facing.func_176740_k()) - facing.func_176743_c().func_179524_a());
    }

    public void sub(LittleVec vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    public void sub(BlockPos pos, LittleGridContext context) {
        this.x -= context.toGrid(pos.func_177958_n());
        this.y -= context.toGrid(pos.func_177956_o());
        this.z -= context.toGrid(pos.func_177952_p());
    }

    public void flip(EnumFacing.Axis axis) {
        this.set(axis, -this.get(axis));
    }

    public void rotateVec(Rotation rotation) {
        int tempX = this.x;
        int tempY = this.y;
        int tempZ = this.z;
        this.x = rotation.getMatrix().getX(tempX, tempY, tempZ);
        this.y = rotation.getMatrix().getY(tempX, tempY, tempZ);
        this.z = rotation.getMatrix().getZ(tempX, tempY, tempZ);
    }

    public double distanceTo(LittleVec vec) {
        return Math.sqrt(Math.pow(vec.x - this.x, 2.0) + Math.pow(vec.y - this.y, 2.0) + Math.pow(vec.z - this.z, 2.0));
    }

    public boolean equals(Object object) {
        if (object instanceof LittleVec) {
            return this.x == ((LittleVec)object).x && this.y == ((LittleVec)object).y && this.z == ((LittleVec)object).z;
        }
        return super.equals(object);
    }

    public LittleVec copy() {
        return new LittleVec(this.x, this.y, this.z);
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name, new int[]{this.x, this.y, this.z});
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public void invert() {
        this.set(-this.x, -this.y, -this.z);
    }

    public void scale(int factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int value) {
        this.x = value;
    }

    public void setY(int value) {
        this.y = value;
    }

    public void setZ(int value) {
        this.z = value;
    }

    public int get(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        return 0;
    }

    public void set(EnumFacing.Axis axis, int value) {
        switch (axis) {
            case X: {
                this.x = value;
                break;
            }
            case Y: {
                this.y = value;
                break;
            }
            case Z: {
                this.z = value;
            }
        }
    }

    public int getVolume() {
        return this.x * this.y * this.z;
    }

    public double getPercentVolume(LittleGridContext context) {
        return (double)this.getVolume() / (double)context.maxTilesPerBlock;
    }

    public LittleVec calculateInvertedCenter() {
        return new LittleVec((int)Math.ceil((double)this.x / 2.0), (int)Math.ceil((double)this.y / 2.0), (int)Math.ceil((double)this.z / 2.0));
    }

    public LittleVec calculateCenter() {
        return new LittleVec((int)Math.floor((double)this.x / 2.0), (int)Math.floor((double)this.y / 2.0), (int)Math.floor((double)this.z / 2.0));
    }

    public LittleVec max(LittleVec size) {
        this.x = Math.max(this.x, size.x);
        this.y = Math.max(this.y, size.y);
        this.z = Math.max(this.z, size.z);
        return this;
    }

    public EnumFacing.Axis getLongestAxis() {
        if (Math.abs(this.x) > Math.abs(this.y)) {
            if (Math.abs(this.x) > Math.abs(this.z)) {
                return EnumFacing.Axis.X;
            }
            return EnumFacing.Axis.Z;
        }
        if (Math.abs(this.z) > Math.abs(this.y)) {
            return EnumFacing.Axis.Z;
        }
        return EnumFacing.Axis.Y;
    }
}

