/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.animation.event;

import com.creativemd.creativecore.client.sound.EntitySound;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.animation.event.AnimationEvent;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlaySoundEvent
extends AnimationEvent {
    public SoundEvent sound;
    public float volume;
    public float pitch;
    public boolean opening;

    public PlaySoundEvent(int tick) {
        super(tick);
    }

    @Override
    public int getEventDuration(LittleStructure structure) {
        return 0;
    }

    @Override
    protected void write(NBTTagCompound nbt) {
        if (this.sound instanceof SoundEventMissing) {
            nbt.func_74778_a("sound", ((SoundEventMissing)this.sound).location.toString());
        } else {
            nbt.func_74778_a("sound", this.sound.getRegistryName().toString());
        }
        nbt.func_74776_a("volume", this.volume);
        nbt.func_74776_a("pitch", this.pitch);
        nbt.func_74757_a("opening", this.opening);
    }

    @Override
    protected void read(NBTTagCompound nbt) {
        this.sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("sound")));
        if (this.sound == null) {
            this.sound = new SoundEventMissing(new ResourceLocation(nbt.func_74779_i("sound")));
        }
        this.volume = nbt.func_74760_g("volume");
        this.pitch = nbt.func_74760_g("pitch");
        this.opening = nbt.func_74767_n("opening");
    }

    @Override
    protected boolean run(EntityAnimationController controller) {
        if (controller.parent.field_70170_p.field_72995_K && controller.getAimedState().name.equals("opened") == this.opening) {
            this.playSound(controller);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void playSound(EntityAnimationController controller) {
        if (!(this.sound instanceof SoundEventMissing)) {
            GuiControl.playSound((ISound)new EntitySound(this.sound, (Entity)controller.parent, this.volume, this.pitch, SoundCategory.NEUTRAL));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void runGui(AnimationGuiHandler handler) {
        if (this.opening && !(this.sound instanceof SoundEventMissing)) {
            GuiControl.playSound((SoundEvent)this.sound, (float)this.volume, (float)this.pitch);
        }
    }

    @Override
    public void invert(LittleDoor door, int duration) {
    }

    public static class SoundEventMissing
    extends SoundEvent {
        public final ResourceLocation location;

        public SoundEventMissing(ResourceLocation location) {
            super(location);
            this.location = location;
        }
    }
}

