/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.util.ingredient.ColorIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColorIngredient
extends Item
implements ILittleIngredientInventory {
    public static int states = 6;
    public ColorIngredientType type;

    public ItemColorIngredient(ColorIngredientType type) {
        this.type = type;
        this.field_77787_bX = true;
        this.func_77637_a(LittleTiles.littleTab);
        this.func_77625_d(1);
    }

    public static ItemStack generateItemStack(ColorIngredientType type, int value) {
        ItemStack stack;
        switch (type) {
            case black: {
                stack = new ItemStack(LittleTiles.blackColorIngredient);
                break;
            }
            case cyan: {
                stack = new ItemStack(LittleTiles.cyanColorIngredient);
                break;
            }
            case magenta: {
                stack = new ItemStack(LittleTiles.magentaColorIngredient);
                break;
            }
            case yellow: {
                stack = new ItemStack(LittleTiles.yellowColorIngredient);
                break;
            }
            default: {
                stack = ItemStack.field_190927_a;
            }
        }
        if (!stack.func_190926_b()) {
            ColorIngredient color = new ColorIngredient();
            type.setIngredient(color, value);
            ((ItemColorIngredient)stack.func_77973_b()).setInventory(stack, new LittleIngredients(color), null);
        }
        return stack;
    }

    public ColorIngredient loadIngredient(ItemStack stack) {
        if (stack.func_77942_o()) {
            ColorIngredient ingredient = new ColorIngredient();
            this.type.setIngredient(ingredient, stack.func_77978_p().func_74762_e("value"));
            switch (this.type) {
                case black: {
                    ingredient.setLimit(ColorIngredient.bottleSize, 0, 0, 0);
                    break;
                }
                case cyan: {
                    ingredient.setLimit(0, ColorIngredient.bottleSize, 0, 0);
                    break;
                }
                case magenta: {
                    ingredient.setLimit(0, 0, ColorIngredient.bottleSize, 0);
                    break;
                }
                case yellow: {
                    ingredient.setLimit(0, 0, 0, ColorIngredient.bottleSize);
                    break;
                }
            }
            return ingredient;
        }
        return null;
    }

    public void saveIngredient(ItemStack stack, ColorIngredient color) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("value", this.type.getIngredient(color));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ColorIngredient entry = this.loadIngredient(stack);
        if (entry != null) {
            tooltip.add(this.type.print(entry));
        }
    }

    @Override
    public LittleIngredients getInventory(ItemStack stack) {
        ColorIngredient color = this.loadIngredient(stack);
        if (color != null) {
            return new LittleIngredients(new LittleIngredient[]{color}){

                @Override
                protected boolean canAddNewIngredients() {
                    return false;
                }

                @Override
                protected boolean removeEmptyIngredients() {
                    return false;
                }
            };
        }
        return null;
    }

    @Override
    public void setInventory(ItemStack stack, LittleIngredients ingredients, LittleInventory inventory) {
        ColorIngredient color = ingredients.get(ColorIngredient.class);
        if (color != null && this.type.getIngredient(color) > 0) {
            this.saveIngredient(stack, color);
            double stateSize = (double)ColorIngredient.bottleSize / (double)states;
            int state = Math.min(5, (int)((double)this.type.getIngredient(color) / stateSize));
            stack.func_77964_b(state);
            return;
        }
        stack.func_77982_d(null);
        stack.func_190920_e(0);
    }

    @Override
    public boolean shouldBeMerged() {
        return true;
    }

    public static enum ColorIngredientType {
        black{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.black;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.black = value;
            }

            @Override
            public String print(ColorIngredient ingredient) {
                return ingredient.getBlackDescription();
            }
        }
        ,
        cyan{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.cyan;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.cyan = value;
            }

            @Override
            public String print(ColorIngredient ingredient) {
                return ingredient.getCyanDescription();
            }
        }
        ,
        magenta{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.magenta;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.magenta = value;
            }

            @Override
            public String print(ColorIngredient ingredient) {
                return ingredient.getMagentaDescription();
            }
        }
        ,
        yellow{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.yellow;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.yellow = value;
            }

            @Override
            public String print(ColorIngredient ingredient) {
                return ingredient.getYellowDescription();
            }
        };


        public abstract int getIngredient(ColorIngredient var1);

        public abstract void setIngredient(ColorIngredient var1, int var2);

        public abstract String print(ColorIngredient var1);

        public static ColorIngredientType getType(String type) {
            switch (type.toLowerCase()) {
                case "black": {
                    return black;
                }
                case "cyan": {
                    return cyan;
                }
                case "magenta": {
                    return magenta;
                }
                case "yellow": {
                    return yellow;
                }
            }
            return null;
        }
    }
}

