/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.overlay;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.client.render.cache.RenderingThread;
import com.google.common.base.Strings;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LittleTilesProfilerOverlay {
    private static boolean showDebugInfo = false;
    public static int vanillaChunksUpdates = 0;
    public static int ltChunksUpdates = 0;
    public static int uploaded = 0;
    private static int updateTime = 20;
    private static int updateTicker = 0;
    private static List<Long> durations;
    private static long averageDuration;
    private static DecimalFormat df;
    private static Minecraft mc;

    public static boolean isActive() {
        return showDebugInfo;
    }

    private static String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return df.format(value);
        }
        return value.toString();
    }

    private static String format(PairList<String, Object> details) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Pair pair : details) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(ChatFormatting.YELLOW + (String)pair.key + ChatFormatting.RESET + ":" + LittleTilesProfilerOverlay.format(pair.value));
        }
        return builder.toString();
    }

    public static void start() {
        durations = new ArrayList<Long>();
        showDebugInfo = true;
    }

    public static void stop() {
        durations = null;
        showDebugInfo = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishBuildingCache(long duration) {
        List<Long> list = durations;
        synchronized (list) {
            durations.add(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++updateTicker > updateTime) {
            vanillaChunksUpdates = 0;
            ltChunksUpdates = 0;
            uploaded = 0;
            updateTicker = 0;
            if (durations != null) {
                List<Long> list = durations;
                synchronized (list) {
                    averageDuration = 0L;
                    if (!durations.isEmpty()) {
                        for (int i = 0; i < durations.size(); ++i) {
                            averageDuration += durations.get(i).longValue();
                        }
                        averageDuration /= (long)durations.size();
                        durations.clear();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRender(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && LittleTilesProfilerOverlay.mc.field_71415_G && !LittleTilesProfilerOverlay.mc.field_71474_y.field_74319_N) {
            ArrayList<String> warnings = new ArrayList<String>();
            if (OptifineHelper.isActive() && OptifineHelper.isRenderRegions()) {
                warnings.add(ChatFormatting.RED + "(LittleTiles) Optifine detected - Disable Render Regions");
            }
            if (OptifineHelper.isActive() && OptifineHelper.isAnisotropicFiltering()) {
                warnings.add(ChatFormatting.RED + "(LittleTiles) Optifine detected - Disable Anisotropic Filtering");
            }
            if (OptifineHelper.isActive() && OptifineHelper.isAntialiasing()) {
                warnings.add(ChatFormatting.RED + "(LittleTiles) Optifine detected - Disable Antialiasing");
            }
            if (!LittleTiles.CONFIG.rendering.hideVBOWarning && !LittleTilesProfilerOverlay.mc.field_71474_y.field_178881_t) {
                warnings.add(ChatFormatting.YELLOW + "(LittleTiles) Please enable VBO and restart the world!");
            }
            if (!LittleTiles.CONFIG.rendering.hideMipmapWarning && OptifineHelper.isActive() && LittleTilesProfilerOverlay.mc.field_71474_y.field_151442_I == 0) {
                warnings.add(ChatFormatting.RED + "(LittleTiles) Optifine detected - Enable mipmap levels (needs to be > 0)");
            }
            if (!warnings.isEmpty()) {
                GlStateManager.func_179094_E();
                for (int i = 0; i < warnings.size(); ++i) {
                    String warning = (String)warnings.get(i);
                    int k = LittleTilesProfilerOverlay.mc.field_71466_p.func_78256_a(warning);
                    int i1 = 2 + LittleTilesProfilerOverlay.mc.field_71466_p.field_78288_b * i;
                    Gui.func_73734_a((int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + LittleTilesProfilerOverlay.mc.field_71466_p.field_78288_b - 1), (int)-1873784752);
                    LittleTilesProfilerOverlay.mc.field_71466_p.func_78276_b(warning, 2, i1, 0xE0E0E0);
                }
                GlStateManager.func_179121_F();
            }
            if (showDebugInfo) {
                GlStateManager.func_179094_E();
                ArrayList<String> list = new ArrayList<String>();
                PairList details = new PairList();
                details.add((Object)"ThreadCount", (Object)RenderingThread.threads.size());
                details.add((Object)"Chunks", (Object)RenderingThread.chunks.size());
                details.add((Object)"Triggered", (Object)(uploaded + "(" + vanillaChunksUpdates + ")/" + ltChunksUpdates));
                int queued = 0;
                for (RenderingThread thread : RenderingThread.threads) {
                    if (thread == null) continue;
                    queued += thread.updateCoords.size();
                }
                details.add((Object)"Queue", (Object)queued);
                if (averageDuration > 1000L) {
                    details.add((Object)"Average", (Object)(averageDuration / 1000L + "ms"));
                } else {
                    details.add((Object)"Average", (Object)(averageDuration + "ns"));
                }
                for (RenderingThread thread : RenderingThread.threads) {
                    if (thread == null) continue;
                    details.add((Object)("" + thread.getThreadIndex()), (Object)thread.updateCoords.size());
                }
                list.add(LittleTilesProfilerOverlay.format((PairList<String, Object>)details));
                details.clear();
                details.add((Object)"Item Cache", (Object)ItemModelCache.countCaches());
                list.add(LittleTilesProfilerOverlay.format((PairList<String, Object>)details));
                details.clear();
                for (int i = 0; i < list.size(); ++i) {
                    String s = (String)list.get(i);
                    if (Strings.isNullOrEmpty((String)s)) continue;
                    int j = LittleTilesProfilerOverlay.mc.field_71466_p.field_78288_b;
                    int k = LittleTilesProfilerOverlay.mc.field_71466_p.func_78256_a(s);
                    int l = 2;
                    int i1 = 2 + j * i;
                    Gui.func_73734_a((int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + j - 1), (int)-1873784752);
                    LittleTilesProfilerOverlay.mc.field_71466_p.func_78276_b(s, 2, i1, 0xE0E0E0);
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    static {
        df = new DecimalFormat("0.##");
        mc = Minecraft.func_71410_x();
    }
}

