/*
 * Decompiled with CFR 0.152.
 */
package gregicality.multiblocks.api.unification.properties;

import gregicality.multiblocks.api.unification.properties.AlloyBlastProperty;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.IMaterialProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;

public class GCYMAutogeneratedPropertyAddition {
    public static void init() {
        for (Material material : GregTechAPI.MATERIAL_REGISTRY) {
            GCYMAutogeneratedPropertyAddition.addAlloyBlastProperty(material);
        }
    }

    public static void addAlloyBlastProperty(Material material) {
        if (material.getMaterialComponents().size() <= 1) {
            return;
        }
        if (material.hasFlag(MaterialFlags.DISABLE_DECOMPOSITION)) {
            return;
        }
        BlastProperty blastProperty = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        if (blastProperty == null) {
            return;
        }
        if (!OrePrefix.ingotHot.doGenerateItem(material) && !material.hasProperty(PropertyKey.FLUID)) {
            return;
        }
        if (material.getMaterialComponents().stream().anyMatch(materialStack -> !materialStack.material.hasProperty(PropertyKey.DUST))) {
            return;
        }
        material.setProperty(GCYMPropertyKey.ALLOY_BLAST, (IMaterialProperty)new AlloyBlastProperty(material.getBlastTemperature()));
    }
}

