/*
 * Decompiled with CFR 0.152.
 */
package net.jaspr.fasterladderclimbing.module;

import net.jaspr.base.module.Feature;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FasterLadderClimbing
extends Feature {
    private boolean allowQuickAscension;
    private boolean allowQuickDescent;
    private int speedModifier;

    @Override
    public void setupConfig() {
        this.allowQuickAscension = this.loadPropBool("Allow going UP faster", "If [false], then player can only climb up the ladder at normal speed.", true);
        this.allowQuickDescent = this.loadPropBool("Allow going DOWN faster", "If [false], then player can only go down the ladder at normal speed.", true);
        this.speedModifier = this.loadPropInt("Speed modifier", "0 is Vanilla speed, 10 is lightning speed", 4, 0, 11);
    }

    @SubscribeEvent
    public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.func_70617_f_() && !player.func_70093_af()) {
            EntityClimber climber = new EntityClimber(player);
            if (this.allowQuickDescent && climber.isFacingDownward() && !climber.isMovingForward() && !climber.isMovingBackward()) {
                climber.moveDownFarther();
            } else if (this.allowQuickAscension && climber.isFacingUpward() && climber.isMovingForward()) {
                climber.moveUpFarther();
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[0];
    }

    private class EntityClimber {
        private EntityPlayer player;

        public EntityClimber(EntityPlayer player) {
            this.player = player;
        }

        private boolean isFacingDownward() {
            return this.player.field_70125_A > 0.0f;
        }

        private boolean isFacingUpward() {
            return this.player.field_70125_A < 0.0f;
        }

        private boolean isMovingForward() {
            return this.player.field_191988_bg > 0.0f;
        }

        private boolean isMovingBackward() {
            return this.player.field_191988_bg < 0.0f;
        }

        private float getElevationChangeUpdate() {
            return (float)Math.abs((double)this.player.field_70125_A / 90.0) * ((float)FasterLadderClimbing.this.speedModifier / 10.0f);
        }

        public void moveUpFarther() {
            boolean px = false;
            float dx = this.getElevationChangeUpdate();
            this.player.func_70091_d(MoverType.SELF, (double)px, (double)dx, (double)px);
        }

        public void moveDownFarther() {
            boolean px = false;
            float dx = this.getElevationChangeUpdate();
            this.player.func_70091_d(MoverType.SELF, (double)px, (double)(dx * -1.0f), (double)px);
        }
    }
}

