/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.events.universe.UniverseClearCacheEvent;
import com.feed_the_beast.ftblib.lib.EnumMessageLocation;
import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftblib.lib.util.text_components.TextComponentParser;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesCommon;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.command.CmdShutdown;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import com.feed_the_beast.ftbutilities.net.MessageUpdatePlayTime;
import com.feed_the_beast.ftbutilities.net.MessageUpdateTabName;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesServerEventHandler {
    private static final ResourceLocation AFK_ID = new ResourceLocation("ftbutilities", "afk");
    private static final Pattern STRIKETHROUGH_PATTERN = Pattern.compile("\\~\\~(.*?)\\~\\~");
    private static final String STRIKETHROUGH_REPLACE = "&m$1&m";
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*(.*?)\\*\\*|__(.*?)__");
    private static final String BOLD_REPLACE = "&l$1$2&l";
    private static final Pattern ITALIC_PATTERN = Pattern.compile("\\*(.*?)\\*|_(.*?)_");
    private static final String ITALIC_REPLACE = "&o$1$2&o";

    @SubscribeEvent
    public static void onCacheCleared(UniverseClearCacheEvent event) {
        if (Ranks.INSTANCE != null) {
            Ranks.INSTANCE.clearCache();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerChatEvent(ServerChatEvent event) {
        if (!FTBUtilitiesConfig.ranks.override_chat || !Ranks.isActive()) {
            return;
        }
        EntityPlayerMP player = event.getPlayer();
        if (!PermissionAPI.hasPermission((EntityPlayer)player, (String)"ftbutilities.chat.speak") || NBTUtils.getPersistedData((EntityPlayer)player, (boolean)false).func_74767_n("muted")) {
            player.func_146105_b(StringUtils.color((ITextComponent)FTBUtilities.lang((ICommandSender)player, "commands.mute.muted", new Object[0]), (TextFormatting)TextFormatting.RED), true);
            event.setCanceled(true);
            return;
        }
        TextComponentString main = new TextComponentString("");
        FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)player));
        main.func_150257_a(data.getNameForChat(player));
        String message = event.getMessage().trim();
        boolean b = false;
        if (!message.contains("https://") && !message.contains("http://") && PermissionAPI.hasPermission((EntityPlayer)player, (String)"ftbutilities.chat.formatting")) {
            for (Map.Entry<String, String> entry : FTBUtilitiesCommon.KAOMOJIS.entrySet()) {
                message = message.replace(entry.getValue(), "<emoji:" + entry.getKey() + ">");
            }
            b = !message.equals(message = STRIKETHROUGH_PATTERN.matcher(message).replaceAll(STRIKETHROUGH_REPLACE)) | b;
            String string = message;
            message = BOLD_PATTERN.matcher(message).replaceAll(BOLD_REPLACE);
            b = !string.equals(message) | b;
            String string2 = message;
            message = ITALIC_PATTERN.matcher(message).replaceAll(ITALIC_REPLACE);
            b = !string2.equals(message) | b;
            for (Map.Entry<String, String> entry : FTBUtilitiesCommon.KAOMOJIS.entrySet()) {
                message = message.replace("<emoji:" + entry.getKey() + ">", entry.getValue());
            }
        }
        ITextComponent text = b ? TextComponentParser.parse((String)message, null) : ForgeHooks.newChatWithLinks((String)message);
        TextFormatting colortf = (TextFormatting)((ConfigEnum)RankConfigAPI.get((EntityPlayerMP)player, (String)"ftbutilities.chat.text.color")).getValue();
        if (colortf != TextFormatting.WHITE) {
            text.func_150256_b().func_150238_a(colortf);
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "ftbutilities.chat.text.bold", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150227_a(Boolean.valueOf(true));
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "ftbutilities.chat.text.italic", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150217_b(Boolean.valueOf(true));
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "ftbutilities.chat.text.underlined", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150228_d(Boolean.valueOf(true));
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "ftbutilities.chat.text.strikethrough", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150225_c(Boolean.valueOf(true));
        }
        if (Ranks.INSTANCE.getPermissionResult(player, "ftbutilities.chat.text.obfuscated", false) == Event.Result.ALLOW) {
            text.func_150256_b().func_150237_e(Boolean.valueOf(true));
        }
        main.func_150257_a(text);
        event.setComponent((ITextComponent)main);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (!Universe.loaded()) {
            return;
        }
        Universe universe = Universe.get();
        long now = System.currentTimeMillis();
        if (event.phase == TickEvent.Phase.START) {
            if (ClaimedChunks.isActive()) {
                ClaimedChunks.instance.update(universe, now);
            }
        } else {
            EntityPlayerMP playerToKickForAfk = null;
            boolean afkEnabled = FTBUtilitiesConfig.afk.isEnabled(universe.server);
            for (EntityPlayerMP player : universe.server.func_184103_al().func_181057_v()) {
                long maxTime;
                boolean isAFK;
                if (ServerUtils.isFake((EntityPlayerMP)player)) continue;
                boolean fly = player.field_71075_bZ.field_75101_c;
                if (!player.field_71075_bZ.field_75098_d && NBTUtils.getPersistedData((EntityPlayer)player, (boolean)false).func_74767_n("fly")) {
                    player.field_71075_bZ.field_75101_c = true;
                }
                if (fly != player.field_71075_bZ.field_75101_c) {
                    player.func_71016_p();
                }
                if (!afkEnabled) continue;
                FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)player));
                boolean prevIsAfk = data.afkTime >= FTBUtilitiesConfig.afk.getNotificationTimer();
                data.afkTime = System.currentTimeMillis() - player.func_154331_x();
                boolean bl = isAFK = data.afkTime >= FTBUtilitiesConfig.afk.getNotificationTimer();
                if (prevIsAfk != isAFK) {
                    for (EntityPlayerMP player1 : universe.server.func_184103_al().func_181057_v()) {
                        EnumMessageLocation location = FTBUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)player1)).getAFKMessageLocation();
                        if (location == EnumMessageLocation.OFF) continue;
                        ITextComponent component = FTBUtilities.lang((ICommandSender)player1, isAFK ? "permission.ftbutilities.afk.timer.is_afk" : "permission.ftbutilities.afk.timer.isnt_afk", player.func_145748_c_());
                        component.func_150256_b().func_150238_a(TextFormatting.GRAY);
                        if (location == EnumMessageLocation.CHAT) {
                            player1.func_145747_a(component);
                            continue;
                        }
                        Notification.of((ResourceLocation)AFK_ID, (ITextComponent[])new ITextComponent[]{component}).send(universe.server, (EntityPlayer)player1);
                    }
                    FTBUtilities.LOGGER.info(player.func_70005_c_() + (isAFK ? " is now AFK" : " is no longer AFK"));
                    if (FTBUtilitiesConfig.chat.replace_tab_names) {
                        new MessageUpdateTabName(player).sendToAll();
                    }
                }
                if (playerToKickForAfk != null || (maxTime = RankConfigAPI.get((MinecraftServer)player.field_71133_b, (GameProfile)player.func_146103_bH(), (String)"ftbutilities.afk.timer").getTimer().millis()) <= 0L || data.afkTime < maxTime) continue;
                playerToKickForAfk = player;
            }
            if (playerToKickForAfk != null && playerToKickForAfk.field_71135_a != null) {
                playerToKickForAfk.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.idling", new Object[0]));
            }
            if (FTBUtilitiesUniverseData.shutdownTime > 0L && FTBUtilitiesUniverseData.shutdownTime - now <= 0L) {
                CmdShutdown.shutdown(universe.server);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.START && event.world.field_73011_w.getDimension() == FTBUtilitiesConfig.world.spawn_dimension) {
            if (FTBUtilitiesConfig.world.forced_spawn_dimension_time != -1) {
                event.world.func_72877_b((long)FTBUtilitiesConfig.world.forced_spawn_dimension_time);
            }
            if (FTBUtilitiesConfig.world.forced_spawn_dimension_weather != -1) {
                event.world.func_72912_H().func_76084_b(FTBUtilitiesConfig.world.forced_spawn_dimension_weather >= 1);
                event.world.func_72912_H().func_76069_a(FTBUtilitiesConfig.world.forced_spawn_dimension_weather >= 2);
            }
            if (FTBUtilitiesConfig.world.show_playtime && event.world.func_82737_E() % 20L == 7L) {
                for (EntityPlayerMP player : event.world.func_73046_m().func_184103_al().func_181057_v()) {
                    new MessageUpdatePlayTime(player.func_147099_x().func_77444_a(StatList.field_188097_g)).sendTo(player);
                }
            }
        }
    }
}

