/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.redstone;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.redstone.signals.BundledSignal;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.filter.redstone.IFilterIncrementingValue;
import crazypants.enderio.base.filter.redstone.IOutputSignalFilter;
import crazypants.enderio.base.lang.Lang;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CountingOutputSignalFilter
implements IOutputSignalFilter,
IFilterIncrementingValue {
    private int maxCount = 1;
    private int count = 0;
    private boolean deactivated = true;

    @Override
    @Nonnull
    public CombinedSignal apply(@Nonnull DyeColor color, @Nonnull BundledSignal bundledSignal) {
        CombinedSignal signal = bundledSignal.getSignal(color);
        if (signal.getStrength() > CombinedSignal.NONE.getStrength() && this.deactivated) {
            ++this.count;
            this.deactivated = false;
        }
        if (signal.getStrength() == CombinedSignal.NONE.getStrength()) {
            this.deactivated = true;
        }
        if (this.count > this.maxCount) {
            this.count = 1;
        } else if (this.count == this.maxCount) {
            return CombinedSignal.MAX;
        }
        return CombinedSignal.NONE;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound t = nbtRoot.func_74775_l("currentCount");
        this.count = t.func_74762_e("count");
        NBTTagCompound d = nbtRoot.func_74775_l("deactivated");
        this.deactivated = d.func_74767_n("deactivated");
        NBTTagCompound m = nbtRoot.func_74775_l("maxCount");
        this.maxCount = m.func_74762_e("max");
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74768_a("count", this.count);
        nbtRoot.func_74782_a("currentCount", (NBTBase)c);
        NBTTagCompound d = new NBTTagCompound();
        d.func_74757_a("deactivated", this.deactivated);
        nbtRoot.func_74782_a("deactivated", (NBTBase)d);
        NBTTagCompound m = new NBTTagCompound();
        m.func_74768_a("max", this.maxCount);
        nbtRoot.func_74782_a("maxCount", (NBTBase)m);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int getIncrementingValue() {
        return this.maxCount;
    }

    @Override
    public void setIncrementingValue(int value) {
        this.maxCount = value;
    }

    @Override
    @Nonnull
    public String getFilterHeading() {
        return Lang.GUI_REDSTONE_FILTER_COUNTING.get();
    }

    @Override
    @Nonnull
    public String getIncrementingValueName() {
        return Lang.GUI_REDSTONE_FILTER_COUNT.get();
    }
}

