/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.util;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.trials.affix.BlazeInvadersAffix;
import mustapelto.deepmoblearning.common.trials.affix.EmpoweredGlitchAffix;
import mustapelto.deepmoblearning.common.trials.affix.KnockbackImmuneAffix;
import mustapelto.deepmoblearning.common.trials.affix.LootHoarderAffix;
import mustapelto.deepmoblearning.common.trials.affix.RegenPartyAffix;
import mustapelto.deepmoblearning.common.trials.affix.SpeedAffix;
import mustapelto.deepmoblearning.common.trials.affix.ThunderDomeAffix;
import mustapelto.deepmoblearning.common.trials.affix.TrialAffix;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AffixHelper {
    private static final Map<String, TrialAffix> AFFIXES = new HashMap<String, TrialAffix>();

    public static void registerAffixes() {
        AffixHelper.registerAffix("blaze_invaders", new BlazeInvadersAffix());
        AffixHelper.registerAffix("empowered_glitches", new EmpoweredGlitchAffix());
        AffixHelper.registerAffix("knockback_immunity", new KnockbackImmuneAffix());
        AffixHelper.registerAffix("loot_hoarders", new LootHoarderAffix());
        AffixHelper.registerAffix("regen_party", new RegenPartyAffix());
        AffixHelper.registerAffix("speed", new SpeedAffix());
        AffixHelper.registerAffix("thunderdome", new ThunderDomeAffix());
    }

    public static void registerAffix(String key, TrialAffix affix) {
        AFFIXES.put(key, affix);
    }

    public static <T extends TrialAffix> T createAffix(String key, BlockPos pos, World world) {
        TrialAffix affixTemplate = AFFIXES.get(key);
        if (affixTemplate == null) {
            return (T)new SpeedAffix();
        }
        return (T)affixTemplate.copy(pos, world);
    }

    @Nullable
    public static String getRandomAffixKey(ImmutableList<String> excluding) {
        String[] keyList = AFFIXES.keySet().toArray(new String[0]);
        String key = keyList[new Random().nextInt(keyList.length)];
        boolean keyIsExcluded = excluding.contains((Object)key);
        int length = keyList.length;
        if (excluding.size() >= length) {
            return null;
        }
        while (keyIsExcluded) {
            key = keyList[new Random().nextInt(keyList.length)];
            if (excluding.contains((Object)key)) continue;
            keyIsExcluded = false;
        }
        return key;
    }
}

