/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.items;

import java.util.List;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.client.util.KeyboardHelper;
import mustapelto.deepmoblearning.common.items.ItemBase;
import mustapelto.deepmoblearning.common.metadata.MetadataLivingMatter;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageLivingMatterConsume;
import mustapelto.deepmoblearning.common.util.DMLRHelper;
import mustapelto.deepmoblearning.common.util.StringHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLivingMatter
extends ItemBase {
    private final MetadataLivingMatter metadata;

    public ItemLivingMatter(MetadataLivingMatter metadata) {
        super(metadata.getRegistryID(), 64, DMLRHelper.isModLoaded(metadata.getModID()));
        this.metadata = metadata;
    }

    public MetadataLivingMatter getLivingMatterData() {
        return this.metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String useString = StringHelper.getFormattedString(TextFormatting.ITALIC, KeyboardHelper.getUseKeyName(), TextFormatting.GRAY);
        String sneakString = StringHelper.getFormattedString(TextFormatting.ITALIC, KeyboardHelper.getSneakKeyName(), TextFormatting.GRAY);
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.living_matter.consume_for_xp", (Object[])new Object[]{useString}));
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.living_matter.consume_stack", (Object[])new Object[]{sneakString}));
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.living_matter.xp", (Object[])new Object[]{this.metadata.getXpValue()}));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            if (KeyboardHelper.isHoldingSneakKey()) {
                DMLPacketHandler.network.sendToServer((IMessage)new MessageLivingMatterConsume(true));
            } else {
                DMLPacketHandler.network.sendToServer((IMessage)new MessageLivingMatterConsume(false));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public String func_77653_i(ItemStack stack) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return super.func_77653_i(stack);
        }
        return I18n.func_135052_a((String)"deepmoblearning.living_matter.display_name", (Object[])new Object[]{this.metadata.getDisplayNameFormatted()});
    }
}

