/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.items;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.client.util.KeyboardHelper;
import mustapelto.deepmoblearning.common.DMLConfig;
import mustapelto.deepmoblearning.common.items.ItemBase;
import mustapelto.deepmoblearning.common.items.ItemLivingMatter;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModelTier;
import mustapelto.deepmoblearning.common.util.DMLRHelper;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.StringHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDataModel
extends ItemBase {
    private final MetadataDataModel metadata;

    public ItemDataModel(MetadataDataModel metadata) {
        super(metadata.getDataModelRegistryID(), 1, DMLRHelper.isModLoaded(metadata.getModID()));
        this.metadata = metadata;
    }

    public MetadataDataModel getDataModelMetadata() {
        return this.metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Optional<MetadataDataModel> metadata = DataModelHelper.getDataModelMetadata(stack);
        if (!metadata.isPresent()) {
            return;
        }
        if (!metadata.get().isEnabled()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"deepmoblearning.data_model.disabled", (Object[])new Object[0]) + TextFormatting.RESET);
            return;
        }
        String extraToolTip = metadata.get().getExtraTooltip();
        if (!extraToolTip.equals("")) {
            tooltip.add(extraToolTip);
        }
        if (!KeyboardHelper.isHoldingSneakKey()) {
            String sneakString = StringHelper.getFormattedString(TextFormatting.ITALIC, KeyboardHelper.getSneakKeyName(), TextFormatting.GRAY);
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"deepmoblearning.general.more_info", (Object[])new Object[]{sneakString}) + TextFormatting.RESET);
        } else {
            if (!DMLConfig.MISC_SETTINGS.SHOW_TIER_IN_NAME) {
                String displayName = DataModelHelper.getTierDisplayNameFormatted(stack);
                tooltip.add(TextFormatting.RESET + I18n.func_135052_a((String)"deepmoblearning.data_model.tier", (Object[])new Object[]{displayName}) + TextFormatting.RESET);
            }
            if (!DataModelHelper.isMaxTier(stack)) {
                int currentData = DataModelHelper.getCurrentTierDataCount(stack);
                int requiredData = DataModelHelper.getTierRequiredData(stack);
                int currentKillMultiplier = DataModelHelper.getTierKillMultiplier(stack);
                tooltip.add(TextFormatting.RESET + I18n.func_135052_a((String)"deepmoblearning.data_model.data_collected", (Object[])new Object[]{TextFormatting.GRAY + String.valueOf(currentData), String.valueOf(requiredData) + TextFormatting.RESET}));
                tooltip.add(TextFormatting.RESET + I18n.func_135052_a((String)"deepmoblearning.data_model.kill_multiplier", (Object[])new Object[]{TextFormatting.GRAY + String.valueOf(currentKillMultiplier) + TextFormatting.RESET}));
            }
            int rfCost = metadata.get().getSimulationRFCost();
            tooltip.add(TextFormatting.RESET + I18n.func_135052_a((String)"deepmoblearning.data_model.rf_cost", (Object[])new Object[]{TextFormatting.GRAY + String.valueOf(rfCost)}) + TextFormatting.RESET);
            ItemStack livingMatter = metadata.get().getLivingMatter();
            ItemLivingMatter livingMatterItem = (ItemLivingMatter)livingMatter.func_77973_b();
            tooltip.add(TextFormatting.RESET + I18n.func_135052_a((String)"deepmoblearning.data_model.type", (Object[])new Object[]{livingMatterItem.getLivingMatterData().getDisplayNameFormatted()}));
            boolean canSimulate = DataModelHelper.canSimulate(stack);
            if (!canSimulate) {
                tooltip.add(TextFormatting.RESET + "" + TextFormatting.RED + I18n.func_135052_a((String)"deepmoblearning.data_model.cannot_simulate", (Object[])new Object[0]) + TextFormatting.RESET);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        Optional<MetadataDataModelTier> tierData;
        Optional<MetadataDataModel> metadata = DataModelHelper.getDataModelMetadata(stack);
        if (!metadata.isPresent()) {
            return "";
        }
        String name = DMLRelearned.proxy.getLocalizedString("deepmoblearning.data_model.display_name", metadata.get().getDisplayName());
        String tier = "";
        if (DMLConfig.MISC_SETTINGS.SHOW_TIER_IN_NAME && (tierData = DataModelHelper.getTierData(stack)).isPresent()) {
            String tierName = tierData.get().getDisplayName();
            TextFormatting tierColor = tierData.get().getDisplayColor();
            tier = StringHelper.getFormattedString(String.format(" (%s)", tierName), tierColor);
        }
        return StringHelper.getFormattedString(name + tier, TextFormatting.AQUA);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.metadata.isEnabled()) {
            super.func_150895_a(tab, items);
        }
    }
}

