/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.items;

import java.util.List;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.client.util.KeyboardHelper;
import mustapelto.deepmoblearning.common.items.ItemBase;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageLevelUpModel;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.StringHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCreativeModelLearner
extends ItemBase {
    public ItemCreativeModelLearner() {
        super("creative_model_learner", 1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.field_70170_p.field_72995_K) {
            DataModelHelper.CreativeLevelUpAction action = KeyboardHelper.isHoldingSneakKey() ? DataModelHelper.CreativeLevelUpAction.INCREASE_TIER : (KeyboardHelper.isHoldingSprintKey() ? DataModelHelper.CreativeLevelUpAction.DECREASE_TIER : DataModelHelper.CreativeLevelUpAction.INCREASE_KILLS);
            DMLPacketHandler.network.sendToServer((IMessage)new MessageLevelUpModel(action));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!KeyboardHelper.isHoldingSneakKey()) {
            String sneakString = TextFormatting.RESET + "" + TextFormatting.ITALIC + KeyboardHelper.getSneakKeyName() + TextFormatting.RESET + "" + TextFormatting.GRAY;
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"deepmoblearning.general.more_info", (Object[])new Object[]{sneakString}) + TextFormatting.RESET);
        } else {
            String sneakName = KeyboardHelper.getSneakKeyName();
            String sprintName = KeyboardHelper.getSprintKeyName();
            String useName = KeyboardHelper.getUseKeyName();
            String increaseTier = StringHelper.getFormattedString(TextFormatting.ITALIC, sneakName + " + " + useName, TextFormatting.GRAY);
            String decreaseTier = StringHelper.getFormattedString(TextFormatting.ITALIC, sprintName + " + " + useName, TextFormatting.GRAY);
            String increaseKills = StringHelper.getFormattedString(TextFormatting.ITALIC, useName, TextFormatting.GRAY);
            tooltip.add(I18n.func_135052_a((String)"deepmoblearning.creative_model_learner.increase_tier", (Object[])new Object[]{increaseTier}));
            tooltip.add(I18n.func_135052_a((String)"deepmoblearning.creative_model_learner.decrease_tier", (Object[])new Object[]{decreaseTier}));
            tooltip.add(I18n.func_135052_a((String)"deepmoblearning.creative_model_learner.increase_kills", (Object[])new Object[]{increaseKills}));
        }
    }
}

