/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.events;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.UUID;
import mustapelto.deepmoblearning.common.capability.CapabilityPlayerTrialProvider;
import mustapelto.deepmoblearning.common.capability.ICapabilityPlayerTrial;
import mustapelto.deepmoblearning.common.items.ItemDeepLearner;
import mustapelto.deepmoblearning.common.items.ItemGlitchArmor;
import mustapelto.deepmoblearning.common.items.ItemGlitchSword;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.tiles.TileEntityTrialKeystone;
import mustapelto.deepmoblearning.common.util.AffixHelper;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import mustapelto.deepmoblearning.common.util.TrialKeyHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EntityDeathEventHandler {
    private static final Integer entityUUIDBlacklistCap = 1000;
    private static final NonNullList<UUID> killedEntityUUIDBlacklist = NonNullList.func_191196_a();

    @SubscribeEvent
    public static void dropEvent(LivingDropsEvent event) {
        String affixKey;
        EntityLivingBase e = event.getEntityLiving();
        NBTTagCompound data = e.getEntityData();
        World world = e.func_130014_f_();
        if (data.func_74764_b("deepmoblearning:tilepos")) {
            event.setCanceled(true);
        } else if (data.func_74764_b("deepmoblearning:mob_type") && (affixKey = data.func_74779_i("deepmoblearning:mob_type")).equals("loot_hoarders")) {
            event.getDrops().clear();
            event.getDrops().add(new EntityItem(world, e.field_70165_t, e.field_70163_u, e.field_70161_v, e.func_184614_ca()));
        }
    }

    @SubscribeEvent
    public static void entityDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityDeathEventHandler.handlePlayerDeath((EntityPlayer)event.getEntityLiving());
        } else {
            EntityDeathEventHandler.handleMobDeath(event.getSource().func_76346_g(), event.getEntityLiving());
        }
    }

    private static void handlePlayerDeath(EntityPlayer player) {
        TileEntityTrialKeystone keystone;
        ICapabilityPlayerTrial cap = (ICapabilityPlayerTrial)player.getCapability(CapabilityPlayerTrialProvider.PLAYER_TRIAL_CAP, null);
        BlockPos tilePos = BlockPos.func_177969_a((long)cap.getTilePos());
        TileEntity tile = player.func_130014_f_().func_175625_s(tilePos);
        if (tile instanceof TileEntityTrialKeystone && (keystone = (TileEntityTrialKeystone)tile).isTrialActive()) {
            keystone.onPlayerDied((EntityPlayerMP)player);
        }
    }

    private static void handleMobDeath(Entity source, EntityLivingBase target) {
        if (killedEntityUUIDBlacklist.size() >= entityUUIDBlacklistCap) {
            EntityDeathEventHandler.cullEntityUUIDBlacklist();
        }
        if (EntityDeathEventHandler.isEntityUUIDBlacklisted(target)) {
            return;
        }
        if (target.getEntityData().func_74764_b("deepmoblearning:tilepos")) {
            EntityDeathEventHandler.handleTrialMobDeath(target);
        }
        if (source instanceof EntityPlayer) {
            EntityDeathEventHandler.handlePlayerKill((EntityPlayerMP)source, target);
        }
        killedEntityUUIDBlacklist.add((Object)target.func_110124_au());
    }

    private static void handleTrialMobDeath(EntityLivingBase target) {
        TileEntityTrialKeystone keystone;
        long pos = target.getEntityData().func_74763_f("deepmoblearning:tilepos");
        BlockPos tilePos = BlockPos.func_177969_a((long)pos);
        TileEntity tile = target.func_130014_f_().func_175625_s(tilePos);
        if (tile instanceof TileEntityTrialKeystone && (keystone = (TileEntityTrialKeystone)tile).isTrialActive()) {
            keystone.onMobDied();
        }
    }

    private static void handlePlayerKill(EntityPlayerMP player, EntityLivingBase target) {
        ItemStack sword;
        ICapabilityPlayerTrial cap;
        NonNullList inventory = NonNullList.func_191196_a();
        inventory.addAll((Collection)player.field_71071_by.field_70462_a);
        inventory.addAll((Collection)player.field_71071_by.field_184439_c);
        ImmutableList deepLearners = (ImmutableList)inventory.stream().filter(ItemStackHelper::isDeepLearner).collect(ImmutableList.toImmutableList());
        ImmutableList trialKeys = (ImmutableList)inventory.stream().filter(key -> ItemStackHelper.isTrialKey(key) && !TrialKeyHelper.isAttuned(key)).collect(ImmutableList.toImmutableList());
        ImmutableList<ItemStack> updatedModels = EntityDeathEventHandler.updateModels((ImmutableList<ItemStack>)deepLearners, player, target);
        if (updatedModels.isEmpty()) {
            return;
        }
        ItemStack highestTierModel = DataModelHelper.getHighestTierDataModelFromList(updatedModels);
        if (ItemGlitchArmor.isSetEquipped((EntityPlayer)player) && !(cap = (ICapabilityPlayerTrial)player.getCapability(CapabilityPlayerTrialProvider.PLAYER_TRIAL_CAP, null)).isTrialActive()) {
            ItemGlitchArmor.dropPristineMatter(target.field_70170_p, target.func_180425_c(), highestTierModel);
        }
        if (ItemStackHelper.isGlitchSword(player.func_184614_ca()) && !(cap = (ICapabilityPlayerTrial)player.getCapability(CapabilityPlayerTrialProvider.PLAYER_TRIAL_CAP, null)).isTrialActive() && ItemGlitchSword.canIncreaseDamage(sword = player.func_184614_ca())) {
            ItemGlitchSword.increaseDamage(sword, player);
        }
        trialKeys.forEach(key -> EntityDeathEventHandler.attuneTrialKey(key, highestTierModel, player));
    }

    private static ImmutableList<ItemStack> updateModels(ImmutableList<ItemStack> deepLearners, EntityPlayerMP player, EntityLivingBase target) {
        ImmutableList.Builder updatedModelsBuilder = ImmutableList.builder();
        deepLearners.forEach(deepLearner -> {
            NonNullList<ItemStack> containedItems = ItemDeepLearner.getContainedItems(deepLearner);
            containedItems.forEach(stack -> DataModelHelper.getDataModelMetadata(stack).ifPresent(metadata -> {
                if (metadata.isAssociatedMob(target)) {
                    DataModelHelper.addKill(stack, player);
                    updatedModelsBuilder.add(stack);
                }
            }));
            ItemDeepLearner.setContainedItems(deepLearner, containedItems);
        });
        return updatedModelsBuilder.build();
    }

    private static void cullEntityUUIDBlacklist() {
        UUID lastUUID = (UUID)killedEntityUUIDBlacklist.get(killedEntityUUIDBlacklist.size() - 1);
        killedEntityUUIDBlacklist.clear();
        killedEntityUUIDBlacklist.add((Object)lastUUID);
    }

    private static boolean isEntityUUIDBlacklisted(EntityLivingBase entityLiving) {
        return killedEntityUUIDBlacklist.stream().anyMatch(uuid -> uuid.compareTo(entityLiving.func_110124_au()) == 0);
    }

    private static void attuneTrialKey(ItemStack trialKey, ItemStack dataModel, EntityPlayerMP player) {
        if (TrialKeyHelper.isAttuned(trialKey) || dataModel.func_190926_b() || !ItemStackHelper.isDataModel(dataModel)) {
            return;
        }
        DataModelHelper.getDataModelMetadata(dataModel).ifPresent(metadata -> {
            MetadataDataModel.TrialData trialData = metadata.getTrialData();
            if (trialData.hasEntity()) {
                TrialKeyHelper.attune(trialKey, dataModel, player);
                EntityDeathEventHandler.addAffixes(trialKey, dataModel);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("deepmoblearning.trial_key.cannot_attune_message", new Object[]{trialKey.func_82833_r(), metadata.getDisplayName()}));
            }
        });
    }

    private static void addAffixes(ItemStack trialKey, ItemStack dataModel) {
        int numberOfAffixes = TrialKeyHelper.getNumberOfAffixes(trialKey);
        ImmutableList.Builder affixes = new ImmutableList.Builder();
        for (int i = 0; i < numberOfAffixes; ++i) {
            affixes.add((Object)AffixHelper.getRandomAffixKey((ImmutableList<String>)affixes.build()));
        }
        TrialKeyHelper.setAffixList(trialKey, (ImmutableList<String>)affixes.build());
    }
}

