/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.gui;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.client.gui.GuiContainerBase;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonBase;
import mustapelto.deepmoblearning.client.gui.buttons.ButtonDeepLearnerSelect;
import mustapelto.deepmoblearning.common.inventory.ContainerDeepLearner;
import mustapelto.deepmoblearning.common.items.ItemDeepLearner;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.util.DataModelHelper;
import mustapelto.deepmoblearning.common.util.PlayerHelper;
import mustapelto.deepmoblearning.common.util.Point;
import mustapelto.deepmoblearning.common.util.Rect;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GuiDeepLearner
extends GuiContainerBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("deepmoblearning", "textures/gui/deep_learner.png");
    private static final int WIDTH = 338;
    private static final int HEIGHT = 235;
    private static final Rect MAIN_GUI = new Rect(41, 0, 256, 140);
    private static final Rect MOB_DISPLAY = new Rect(-41, 0, 75, 101);
    private static final Point MOB_DISPLAY_ENTITY = new Point(0, 80);
    private static final Point TEXT_START = new Point(49, 8);
    private static final Rect HEART_ICON = new Rect(228, 18, 9, 9);
    private static final Point HEALTH_POINTS_HEADER = new Point(228, 8);
    private static final Point HEALTH_POINTS_TEXT = new Point(239, 20);
    private static final Point PREV_MODEL_BUTTON = new Point(-27, 105);
    private static final Point NEXT_MODEL_BUTTON = new Point(-1, 105);
    private final ItemStack deepLearner;
    private ImmutableList<ItemStack> dataModels;
    private int currentModelIndex = 0;
    private ItemStack currentModelStack;
    @Nullable
    private MetadataDataModel currentModelMetadata;
    @Nullable
    private MetadataDataModel.DeepLearnerDisplayData currentDisplayData;
    private ImmutableList<ImmutablePair<String, Integer>> defaultStringList;
    private ButtonDeepLearnerSelect prevModelButton;
    private ButtonDeepLearnerSelect nextModelButton;
    private float currentEntityRotation = 0.0f;
    private double currentEntityHeight = 0.0;

    public GuiDeepLearner(EntityPlayer player, World world) {
        super(player, world, new ContainerDeepLearner(player), 338, 235);
        this.deepLearner = PlayerHelper.getHeldDeepLearner(player);
        if (this.deepLearner.func_190926_b()) {
            throw new IllegalStateException("Tried to open Deep Learner GUI without Deep Learner equipped");
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initDefaultStringList();
        this.updateDisplayData();
    }

    private void initDefaultStringList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.no_model.line_1", (Object[])new Object[0]), (Object)6478079));
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.no_model.line_2", (Object[])new Object[0]), (Object)0xFFFFFF));
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.no_model.line_3", (Object[])new Object[0]), (Object)0xFFFFFF));
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.no_model.line_4", (Object[])new Object[0]), (Object)0xFFFFFF));
        builder.add((Object)ImmutablePair.of((Object)"", (Object)0));
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.no_model.line_5", (Object[])new Object[0]), (Object)0xFFFFFF));
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.no_model.line_6", (Object[])new Object[0]), (Object)0xFFFFFF));
        this.defaultStringList = builder.build();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.updateDisplayData();
    }

    private void updateDisplayData() {
        NonNullList<ItemStack> deepLearnerStackList = ItemDeepLearner.getContainedItems(this.deepLearner);
        this.dataModels = DataModelHelper.getDataModelStacksFromList(deepLearnerStackList);
        if (this.dataModels.isEmpty()) {
            this.currentModelIndex = -1;
            this.currentModelStack = ItemStack.field_190927_a;
            this.currentModelMetadata = null;
            this.currentDisplayData = null;
            this.setModelSelectButtonsEnabled(false);
            return;
        }
        if (this.currentModelIndex < 0 || this.currentModelIndex >= this.dataModels.size()) {
            this.currentModelIndex = 0;
        }
        this.currentModelStack = (ItemStack)this.dataModels.get(this.currentModelIndex);
        this.currentModelMetadata = DataModelHelper.getDataModelMetadata(this.currentModelStack).orElse(null);
        this.currentDisplayData = this.currentModelMetadata != null ? this.currentModelMetadata.getDeepLearnerDisplayData() : null;
        this.setModelSelectButtonsEnabled(this.dataModels.size() > 1);
    }

    @Override
    protected void initButtons() {
        this.prevModelButton = new ButtonDeepLearnerSelect(0, this.field_147003_i + GuiDeepLearner.PREV_MODEL_BUTTON.X, this.field_147009_r + GuiDeepLearner.PREV_MODEL_BUTTON.Y, ButtonDeepLearnerSelect.Direction.PREV);
        this.nextModelButton = new ButtonDeepLearnerSelect(0, this.field_147003_i + GuiDeepLearner.NEXT_MODEL_BUTTON.X, this.field_147009_r + GuiDeepLearner.NEXT_MODEL_BUTTON.Y, ButtonDeepLearnerSelect.Direction.NEXT);
    }

    @Override
    protected void rebuildButtonList() {
        super.rebuildButtonList();
        this.field_146292_n.add(this.prevModelButton);
        this.field_146292_n.add(this.nextModelButton);
    }

    @Override
    protected void handleButtonPress(ButtonBase button, int mouseButton) {
        if (mouseButton == 0 && button instanceof ButtonDeepLearnerSelect) {
            ButtonDeepLearnerSelect modelSelectButton = (ButtonDeepLearnerSelect)button;
            if (modelSelectButton.getDirection() == ButtonDeepLearnerSelect.Direction.PREV) {
                --this.currentModelIndex;
                if (this.currentModelIndex < 0) {
                    this.currentModelIndex = this.dataModels.size() - 1;
                }
            } else {
                ++this.currentModelIndex;
                if (this.currentModelIndex >= this.dataModels.size()) {
                    this.currentModelIndex = 0;
                }
            }
        }
    }

    private void setModelSelectButtonsEnabled(boolean enabled) {
        this.prevModelButton.field_146124_l = enabled;
        this.nextModelButton.field_146124_l = enabled;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.textureManager.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i + GuiDeepLearner.MAIN_GUI.LEFT, this.field_147009_r + GuiDeepLearner.MAIN_GUI.TOP, TextureCoords.MAIN_GUI.X, TextureCoords.MAIN_GUI.Y, GuiDeepLearner.MAIN_GUI.WIDTH, GuiDeepLearner.MAIN_GUI.HEIGHT);
        this.drawPlayerInventory(this.field_147003_i + DMLConstants.Gui.DeepLearner.PLAYER_INVENTORY.X, this.field_147009_r + DMLConstants.Gui.DeepLearner.PLAYER_INVENTORY.Y);
        this.textureManager.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i + GuiDeepLearner.MOB_DISPLAY.LEFT, this.field_147009_r + GuiDeepLearner.MOB_DISPLAY.TOP, TextureCoords.MOB_DISPLAY.X, TextureCoords.MOB_DISPLAY.Y, GuiDeepLearner.MOB_DISPLAY.WIDTH, GuiDeepLearner.MOB_DISPLAY.HEIGHT);
        if (this.currentModelStack.func_190926_b()) {
            this.renderDisplayStrings(this.defaultStringList);
            return;
        }
        if (this.currentDisplayData == null) {
            return;
        }
        this.renderMetaData();
        this.currentEntityHeight = Math.sin(this.lastRedrawTime / 16.0f) / 8.0;
        this.currentEntityRotation += this.deltaTime * 3.0f;
        GlStateManager.func_179123_a();
        this.currentDisplayData.getEntity(this.world).ifPresent(entity -> this.renderEntity((Entity)entity, this.currentDisplayData.getEntityScale(), this.field_147003_i + GuiDeepLearner.MOB_DISPLAY_ENTITY.X + this.currentDisplayData.getEntityOffsetX(), this.field_147009_r + GuiDeepLearner.MOB_DISPLAY_ENTITY.Y + this.currentDisplayData.getEntityOffsetY()));
        this.currentDisplayData.getExtraEntity(this.world).ifPresent(entity -> this.renderEntity((Entity)entity, this.currentDisplayData.getEntityScale(), this.field_147003_i + GuiDeepLearner.MOB_DISPLAY_ENTITY.X + this.currentDisplayData.getExtraEntityOffsetX(), this.field_147009_r + GuiDeepLearner.MOB_DISPLAY_ENTITY.Y + this.currentDisplayData.getExtraEntityOffsetY()));
        GlStateManager.func_179099_b();
    }

    private void renderMetaData() {
        if (this.currentModelMetadata == null || this.currentDisplayData == null) {
            return;
        }
        String dataModelTier = DataModelHelper.getTierDisplayNameFormatted(this.currentModelStack);
        String nextTier = DataModelHelper.getNextTierDisplayNameFormatted(this.currentModelStack);
        String mobName = this.currentModelMetadata.getDisplayName();
        String mobPluralName = this.currentModelMetadata.getDisplayNamePlural();
        ImmutableList<String> mobTrivia = this.currentDisplayData.getMobTrivia();
        int totalKills = DataModelHelper.getTotalKillCount(this.currentModelStack);
        int killsToNextTier = DataModelHelper.getKillsToNextTier(this.currentModelStack);
        String tierString = DataModelHelper.isMaxTier(this.currentModelStack) ? I18n.func_135052_a((String)"deepmoblearning.deep_learner.maximum", (Object[])new Object[0]) : I18n.func_135052_a((String)"deepmoblearning.deep_learner.required", (Object[])new Object[]{killsToNextTier, nextTier});
        int numHearts = this.currentDisplayData.getHearts();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.heading_name", (Object[])new Object[0]), (Object)6478079));
        builder.add((Object)ImmutablePair.of((Object)mobName, (Object)0xFFFFFF));
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.heading_information", (Object[])new Object[0]), (Object)6478079));
        for (String triviaLine : mobTrivia) {
            builder.add((Object)ImmutablePair.of((Object)triviaLine, (Object)0xFFFFFF));
        }
        for (int i = 0; i < 7 - (3 + mobTrivia.size()); ++i) {
            builder.add((Object)ImmutablePair.of((Object)"", (Object)0));
        }
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.model_tier", (Object[])new Object[]{dataModelTier}), (Object)0xFFFFFF));
        builder.add((Object)ImmutablePair.of((Object)I18n.func_135052_a((String)"deepmoblearning.deep_learner.defeated", (Object[])new Object[]{mobPluralName, totalKills}), (Object)0xFFFFFF));
        builder.add((Object)ImmutablePair.of((Object)tierString, (Object)0xFFFFFF));
        this.renderDisplayStrings((ImmutableList<ImmutablePair<String, Integer>>)builder.build());
        this.textureManager.func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i + GuiDeepLearner.HEART_ICON.LEFT, this.field_147009_r + GuiDeepLearner.HEART_ICON.TOP, TextureCoords.HEART_ICON.X, TextureCoords.HEART_ICON.Y, GuiDeepLearner.HEART_ICON.WIDTH, GuiDeepLearner.HEART_ICON.HEIGHT);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"deepmoblearning.deep_learner.health_points", (Object[])new Object[0]), this.field_147003_i + GuiDeepLearner.HEALTH_POINTS_HEADER.X, this.field_147009_r + GuiDeepLearner.HEALTH_POINTS_HEADER.Y, 6478079);
        this.func_73731_b(this.field_146289_q, numHearts == 0 ? TextFormatting.OBFUSCATED + "10" + TextFormatting.RESET : Integer.toString(numHearts), this.field_147003_i + GuiDeepLearner.HEALTH_POINTS_TEXT.X, this.field_147009_r + GuiDeepLearner.HEALTH_POINTS_TEXT.Y, 0xFFFFFF);
    }

    private void renderDisplayStrings(ImmutableList<ImmutablePair<String, Integer>> stringList) {
        for (int i = 0; i < stringList.size(); ++i) {
            String string = (String)((ImmutablePair)stringList.get((int)i)).left;
            if (string.isEmpty()) continue;
            this.func_73731_b(this.field_146289_q, string, this.field_147003_i + GuiDeepLearner.TEXT_START.X, this.field_147009_r + GuiDeepLearner.TEXT_START.Y + i * 12, (Integer)((ImmutablePair)stringList.get((int)i)).right);
        }
    }

    private void renderEntity(Entity entity, int scale, int x, int y) {
        EntityRenderer entityRenderer = this.field_146297_k.field_71460_t;
        entityRenderer.func_175072_h();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.2f, (double)this.currentEntityHeight, (double)15.0);
        GlStateManager.func_179114_b((float)this.currentEntityRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.field_146297_k.func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 1.0f, 0.0f, true);
        GlStateManager.func_179121_F();
        entityRenderer.func_180436_i();
    }

    private static final class TextureCoords {
        private static final Point MAIN_GUI = new Point(0, 0);
        private static final Point MOB_DISPLAY = new Point(0, 140);
        private static final Point HEART_ICON = new Point(75, 140);

        private TextureCoords() {
        }
    }
}

