/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client;

import java.util.Objects;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.client.models.ModelDataModel;
import mustapelto.deepmoblearning.client.models.ModelLivingMatter;
import mustapelto.deepmoblearning.client.models.ModelPristineMatter;
import mustapelto.deepmoblearning.common.DMLRegistry;
import mustapelto.deepmoblearning.common.items.ItemDataModel;
import mustapelto.deepmoblearning.common.items.ItemLivingMatter;
import mustapelto.deepmoblearning.common.items.ItemPristineMatter;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModelRegistry {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        DMLRelearned.logger.info("Registering Models...");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelDataModel.LoaderDataModel.INSTANCE);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelPristineMatter.LoaderPristineMatter.INSTANCE);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelLivingMatter.LoaderLivingMatter.INSTANCE);
        DMLRegistry.registeredItems.forEach(ModelRegistry::registerModel);
        DMLRegistry.registeredBlocks.forEach(block -> ModelRegistry.registerModel(Item.func_150898_a((Block)block), Objects.requireNonNull(block.getRegistryName())));
    }

    private static void registerModel(Item item) {
        ResourceLocation modelLocation;
        if (item instanceof ItemDataModel || item instanceof ItemPristineMatter || item instanceof ItemLivingMatter) {
            ResourceLocation registryName = item.getRegistryName();
            if (registryName == null) {
                return;
            }
            String registryItem = registryName.func_110623_a();
            modelLocation = new ResourceLocation("deepmoblearning", registryItem);
        } else {
            ResourceLocation registryLocation = item.getRegistryName();
            if (registryLocation == null) {
                return;
            }
            modelLocation = registryLocation;
        }
        ModelRegistry.registerModel(item, modelLocation);
    }

    private static void registerModel(Item item, ResourceLocation location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
    }
}

