/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.forge.loader;

import customskinloader.forge.TransformerManager;
import customskinloader.forge.transformer.FakeInterfacesTransformer;
import customskinloader.forge.transformer.PlayerTabTransformer;
import customskinloader.forge.transformer.SkinManagerTransformer;
import customskinloader.forge.transformer.SpectatorMenuTransformer;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class LaunchWrapper
implements IClassTransformer {
    private static final TransformerManager.IClassTransformer[] CLASS_TRANSFORMERS = new TransformerManager.IClassTransformer[]{new FakeInterfacesTransformer.MinecraftTransformer(), new FakeInterfacesTransformer.ThreadDownloadImageDataTransformer(), new FakeInterfacesTransformer.ClientIResourceTransformer(), new FakeInterfacesTransformer.ClientIResourceManagerTransformer(), new FakeInterfacesTransformer.IResourceTransformer(), new FakeInterfacesTransformer.IResourceManagerTransformer()};
    private static final TransformerManager.IMethodTransformer[] TRANFORMERS = new TransformerManager.IMethodTransformer[]{new SkinManagerTransformer.InitTransformer(), new SkinManagerTransformer.LoadSkinTransformer(), new SkinManagerTransformer.LoadProfileTexturesTransformer(), new SkinManagerTransformer.LoadSkinFromCacheTransformer(), new SkinManagerTransformer.Run0Transformer(), new SkinManagerTransformer.Run1Transformer(), new PlayerTabTransformer.ScoreObjectiveTransformer(), new SpectatorMenuTransformer.PlayerMenuObjectTransformer()};
    private TransformerManager transformerManager = new TransformerManager(CLASS_TRANSFORMERS, TRANFORMERS);

    public byte[] transform(String obfClassName, String className, byte[] bytes) {
        if (!this.transformerManager.classMap.containsKey(className) && !this.transformerManager.map.containsKey(className)) {
            return bytes;
        }
        ClassNode cn = new ClassNode();
        if (bytes != null && bytes.length > 0) {
            ClassReader cr = new ClassReader(bytes);
            cr.accept((ClassVisitor)cn, 0);
        } else {
            cn.name = className.replace(".", "/");
            cn.version = 52;
            cn.superName = "java/lang/Object";
        }
        cn = this.transformerManager.transform(cn, className);
        ArrayList<MethodNode> methods = new ArrayList<MethodNode>();
        for (MethodNode mn : cn.methods) {
            String mappedMethodName = TransformerManager.isDevelopmentEnvironment ? mn.name : TransformerManager.mapMethodName(cn.name, mn.name, mn.desc);
            String mappedMethodDesc = TransformerManager.isDevelopmentEnvironment ? mn.desc : TransformerManager.mapMethodDesc(mn.desc);
            methods.add(this.transformerManager.transform(cn, mn, className, mappedMethodName, mappedMethodDesc));
        }
        cn.methods.clear();
        cn.methods.addAll(methods);
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

