/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.utils.BQThreadedIO;
import betterquesting.client.QuestNotification;
import betterquesting.client.gui2.GuiHome;
import betterquesting.core.BetterQuesting;
import betterquesting.legacy.ILegacyLoader;
import betterquesting.legacy.LegacyLoaderRegistry;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.party.PartyInvitations;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SaveLoadHandler {
    public static SaveLoadHandler INSTANCE = new SaveLoadHandler();
    private boolean hasUpdate = false;
    private boolean isDirty = false;
    private File fileDatabase = null;
    private File fileProgress = null;
    private File dirProgress = null;
    private File fileParties = null;
    private File fileLives = null;
    private File fileNames = null;
    private ILegacyLoader legacyLoader = null;
    private final Set<UUID> dirtyPlayers = new ConcurrentSet();

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public void resetUpdate() {
        this.hasUpdate = false;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public void addDirtyPlayers(UUID ... players) {
        this.dirtyPlayers.addAll(Arrays.asList(players));
    }

    public void addDirtyPlayers(Collection<UUID> players) {
        this.dirtyPlayers.addAll(players);
    }

    public void loadDatabases(MinecraftServer server) {
        File rootDir;
        this.hasUpdate = false;
        if (BetterQuesting.proxy.isClient()) {
            GuiHome.bookmark = null;
            QuestNotification.resetNotices();
        }
        if (BetterQuesting.proxy.isClient()) {
            BQ_Settings.curWorldDir = server.func_71209_f("saves/" + server.func_71270_I() + "/betterquesting");
            rootDir = server.func_71209_f("saves/" + server.func_71270_I());
        } else {
            BQ_Settings.curWorldDir = server.func_71209_f(server.func_71270_I() + "/betterquesting");
            rootDir = server.func_71209_f(server.func_71270_I());
        }
        this.fileDatabase = new File(BQ_Settings.curWorldDir, "QuestDatabase.json");
        this.fileProgress = new File(BQ_Settings.curWorldDir, "QuestProgress.json");
        this.dirProgress = new File(BQ_Settings.curWorldDir, "QuestProgress");
        this.fileParties = new File(BQ_Settings.curWorldDir, "QuestingParties.json");
        this.fileLives = new File(BQ_Settings.curWorldDir, "LifeDatabase.json");
        this.fileNames = new File(BQ_Settings.curWorldDir, "NameCache.json");
        this.checkLegacyFiles(rootDir);
        this.loadConfig();
        this.loadProgress();
        this.loadParties();
        this.loadNames();
        this.loadLives();
        this.legacyLoader = null;
        BetterQuesting.logger.info("Loaded " + QuestDatabase.INSTANCE.size() + " quests");
        BetterQuesting.logger.info("Loaded " + QuestLineDatabase.INSTANCE.size() + " quest lines");
        BetterQuesting.logger.info("Loaded " + PartyManager.INSTANCE.size() + " parties");
        BetterQuesting.logger.info("Loaded " + NameCache.INSTANCE.size() + " names");
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Load(DatabaseEvent.DBType.ALL));
    }

    public void saveDatabases() {
        ArrayList<Future<Void>> allFutures = new ArrayList<Future<Void>>();
        if (this.isDirty || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            allFutures.add(this.saveConfig());
        }
        allFutures.addAll(this.saveProgress());
        allFutures.add(this.saveParties());
        allFutures.add(this.saveNames());
        allFutures.add(this.saveLives());
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Save(DatabaseEvent.DBType.ALL));
        for (Future future : allFutures) {
            try {
                future.get();
                this.isDirty = false;
            }
            catch (InterruptedException e) {
                BetterQuesting.logger.warn("Saving interrupted!", (Throwable)e);
            }
            catch (ExecutionException e) {
                BetterQuesting.logger.warn("Saving failed!", e.getCause());
            }
        }
    }

    public void unloadDatabases() {
        BQThreadedIO.INSTANCE.enqueue(() -> {
            BQ_Settings.curWorldDir = null;
            this.hasUpdate = false;
            this.isDirty = false;
            QuestSettings.INSTANCE.reset();
            QuestDatabase.INSTANCE.reset();
            QuestLineDatabase.INSTANCE.reset();
            LifeDatabase.INSTANCE.reset();
            NameCache.INSTANCE.reset();
            PartyInvitations.INSTANCE.reset();
            PartyManager.INSTANCE.reset();
            if (BetterQuesting.proxy.isClient()) {
                GuiHome.bookmark = null;
                QuestNotification.resetNotices();
            }
        });
    }

    private void loadConfig() {
        QuestSettings.INSTANCE.reset();
        QuestDatabase.INSTANCE.reset();
        QuestLineDatabase.INSTANCE.reset();
        int packVer = 0;
        String packName = "";
        File fileDefaultDatabase = new File(BQ_Settings.defaultDir, "DefaultQuests.json");
        if (!this.fileDatabase.exists()) {
            this.isDirty = true;
            this.fileDatabase = fileDefaultDatabase;
        } else {
            JsonObject defTmp = JsonHelper.ReadFromFile(fileDefaultDatabase);
            QuestSettings tmpSettings = new QuestSettings();
            tmpSettings.readFromNBT(NBTConverter.JSONtoNBT_Object(defTmp, new NBTTagCompound(), true).func_74775_l("questSettings"));
            packVer = tmpSettings.getProperty(NativeProps.PACK_VER);
            packName = tmpSettings.getProperty(NativeProps.PACK_NAME);
        }
        JsonObject json = JsonHelper.ReadFromFile(this.fileDatabase);
        NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        String formatVer = nbt.func_150297_b("format", 8) ? nbt.func_74779_i("format") : "0.0.0";
        String buildVer = nbt.func_74779_i("build");
        String currVer = Loader.instance().activeModContainer().getVersion();
        if (!currVer.equalsIgnoreCase(buildVer)) {
            String fsVer = JsonHelper.makeFileNameSafe(buildVer);
            if (fsVer.length() <= 0) {
                fsVer = "pre-251";
            }
            BetterQuesting.logger.warn("BetterQuesting has been updated to from \"{}\" to \"{}\"! Creating backups...", (Object)fsVer, (Object)currVer);
            JsonHelper.CopyPaste(this.fileDatabase, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestDatabase_backup_" + fsVer + ".json"));
            JsonHelper.CopyPaste(this.fileProgress, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestProgress_backup_" + fsVer + ".json"));
            JsonHelper.CopyPaste(this.fileParties, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "QuestingParties_backup_" + fsVer + ".json"));
            JsonHelper.CopyPaste(this.fileNames, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "NameCache_backup_" + fsVer + ".json"));
            JsonHelper.CopyPaste(this.fileLives, new File(BQ_Settings.curWorldDir + "/backup/" + fsVer, "LifeDatabase_backup_" + fsVer + ".json"));
        }
        this.legacyLoader = LegacyLoaderRegistry.getLoader(formatVer);
        if (this.legacyLoader == null) {
            QuestSettings.INSTANCE.readFromNBT(nbt.func_74775_l("questSettings"));
            QuestDatabase.INSTANCE.readFromNBT(nbt.func_150295_c("questDatabase", 10), false);
            QuestLineDatabase.INSTANCE.readFromNBT(nbt.func_150295_c("questLines", 10), false);
        } else {
            this.legacyLoader.readFromJson((JsonElement)json);
        }
        this.hasUpdate = packName.equals(QuestSettings.INSTANCE.getProperty(NativeProps.PACK_NAME)) && packVer > QuestSettings.INSTANCE.getProperty(NativeProps.PACK_VER);
    }

    private void loadProgress() {
        if (this.fileProgress.exists()) {
            JsonObject json = JsonHelper.ReadFromFile(this.fileProgress);
            if (this.legacyLoader == null) {
                NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
                QuestDatabase.INSTANCE.readProgressFromNBT(nbt.func_150295_c("questProgress", 10), false);
            } else {
                this.legacyLoader.readProgressFromJson((JsonElement)json);
            }
        }
        for (File file : this.getPlayerProgressFiles()) {
            JsonObject json = JsonHelper.ReadFromFile(file);
            NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
            QuestDatabase.INSTANCE.readProgressFromNBT(nbt.func_150295_c("questProgress", 10), true);
        }
    }

    private void loadParties() {
        JsonObject json = JsonHelper.ReadFromFile(this.fileParties);
        NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        PartyManager.INSTANCE.readFromNBT(nbt.func_150295_c("parties", 10), false);
    }

    private void loadNames() {
        NameCache.INSTANCE.reset();
        JsonObject json = JsonHelper.ReadFromFile(this.fileNames);
        NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        NameCache.INSTANCE.readFromNBT(nbt.func_150295_c("nameCache", 10), false);
    }

    private void loadLives() {
        LifeDatabase.INSTANCE.reset();
        JsonObject json = JsonHelper.ReadFromFile(this.fileLives);
        NBTTagCompound nbt = NBTConverter.JSONtoNBT_Object(json, new NBTTagCompound(), true);
        LifeDatabase.INSTANCE.readFromNBT(nbt.func_74775_l("lifeDatabase"), false);
    }

    private void checkLegacyFiles(File rootDir) {
        if (new File(rootDir, "QuestDatabase.json").exists() && !this.fileDatabase.exists()) {
            File legacyDatabase = new File(rootDir, "QuestDatabase.json");
            File legacyProgress = new File(rootDir, "QuestProgress.json");
            File legacyParties = new File(rootDir, "QuestingParties.json");
            File legacyLives = new File(rootDir, "LifeDatabase.json");
            File legacyNames = new File(rootDir, "NameCache.json");
            JsonHelper.CopyPaste(legacyDatabase, this.fileDatabase);
            JsonHelper.CopyPaste(legacyProgress, this.fileProgress);
            JsonHelper.CopyPaste(legacyParties, this.fileParties);
            JsonHelper.CopyPaste(legacyLives, this.fileLives);
            JsonHelper.CopyPaste(legacyNames, this.fileNames);
            legacyDatabase.delete();
            legacyProgress.delete();
            legacyParties.delete();
            legacyLives.delete();
            legacyNames.delete();
        }
    }

    private Future<Void> saveConfig() {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("questSettings", (NBTBase)QuestSettings.INSTANCE.writeToNBT(new NBTTagCompound()));
        json.func_74782_a("questDatabase", (NBTBase)QuestDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
        json.func_74782_a("questLines", (NBTBase)QuestLineDatabase.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
        json.func_74778_a("format", "2.0.0");
        json.func_74778_a("build", Loader.instance().activeModContainer().getVersion());
        return JsonHelper.WriteToFile(this.fileDatabase, NBTConverter.NBTtoJSON_Compound(json, new JsonObject(), true));
    }

    private List<Future<Void>> saveProgress() {
        List<Future<Void>> futures = this.dirtyPlayers.stream().map(this::savePlayerProgress).collect(Collectors.toList());
        this.dirtyPlayers.clear();
        return futures;
    }

    private Future<Void> saveParties() {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("parties", (NBTBase)PartyManager.INSTANCE.writeToNBT(new NBTTagList(), (List<Integer>)null));
        return JsonHelper.WriteToFile(this.fileParties, NBTConverter.NBTtoJSON_Compound(json, new JsonObject(), true));
    }

    private Future<Void> saveNames() {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("nameCache", (NBTBase)NameCache.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)null));
        return JsonHelper.WriteToFile(this.fileNames, NBTConverter.NBTtoJSON_Compound(json, new JsonObject(), true));
    }

    private Future<Void> saveLives() {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("lifeDatabase", (NBTBase)LifeDatabase.INSTANCE.writeToNBT(new NBTTagCompound(), (List<UUID>)null));
        return JsonHelper.WriteToFile(this.fileLives, NBTConverter.NBTtoJSON_Compound(json, new JsonObject(), true));
    }

    public Future<Void> savePlayerProgress(UUID player) {
        NBTTagCompound json = new NBTTagCompound();
        json.func_74782_a("questProgress", (NBTBase)QuestDatabase.INSTANCE.writeProgressToNBT(new NBTTagList(), Collections.singletonList(player)));
        return JsonHelper.WriteToFile(new File(this.dirProgress, player.toString() + ".json"), NBTConverter.NBTtoJSON_Compound(json, new JsonObject(), true));
    }

    private List<File> getPlayerProgressFiles() {
        File[] files = this.dirProgress.listFiles();
        if (files == null) {
            return new ArrayList<File>();
        }
        return Arrays.stream(files).filter(f -> f.getName().endsWith(".json")).collect(Collectors.toList());
    }
}

