/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.supporter;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.supporter.RgbTexture;
import betterquesting.api2.supporter.SupporterDB;
import betterquesting.api2.supporter.SupporterEntry;
import betterquesting.client.themes.ResourceTheme;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SupporterAPI {
    private static Gson GSON = new GsonBuilder().create();
    private static final String charSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuv0123456789";
    private static final Random rand = new Random();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static JsonObject readManifest(File loc) {
        try (DataInputStream dis = new DataInputStream(new GZIPInputStream(new FileInputStream(loc)));){
            JsonObject jsonObject = (JsonObject)GSON.fromJson(new String(Base64.getDecoder().decode(dis.readUTF())), JsonObject.class);
            return jsonObject;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResourceTheme readCompressedFile(File loc) {
        try (DataInputStream dis = new DataInputStream(new GZIPInputStream(new FileInputStream(loc)));){
            JsonObject manifest = (JsonObject)GSON.fromJson(new String(Base64.getDecoder().decode(dis.readUTF()), StandardCharsets.UTF_8), JsonObject.class);
            int format = JsonHelper.GetNumber(manifest, "format", 0).intValue();
            ResourceLocation parID = manifest.has("parentID") ? new ResourceLocation(JsonHelper.GetString(manifest, "parentID", "minecraft:null")) : null;
            ResourceLocation thmID = new ResourceLocation(JsonHelper.GetString(manifest, "themeID", "betterquesting:untitled"));
            String thmName = JsonHelper.GetString(manifest, "themeName", "Untitled Theme");
            ResourceTheme theme = new ResourceTheme(parID, thmID, thmName);
            byte[] fileKey = SupporterAPI.readFileKey(dis, format);
            JsonObject themeJson = (JsonObject)GSON.fromJson(SupporterAPI.decode(dis.readUTF(), fileKey), JsonObject.class);
            int numTex = dis.readInt();
            for (int n = 0; n < numTex; ++n) {
                ResourceLocation resID = new ResourceLocation(SupporterAPI.decode(dis.readUTF(), fileKey));
                int w = dis.readInt();
                int h = dis.readInt();
                int[] rgb = new int[w * h];
                for (int i = 0; i < rgb.length; ++i) {
                    int flip = fileKey[i * 4 % fileKey.length];
                    flip |= fileKey[(i * 4 + 1) % fileKey.length] << 8;
                    flip |= fileKey[(i * 4 + 2) % fileKey.length] << 16;
                    rgb[i] = dis.readInt() ^ (flip |= fileKey[(i * 4 + 3) % fileKey.length] << 24);
                }
                RgbTexture texture = new RgbTexture(w, h, rgb);
                Minecraft.func_71410_x().func_152343_a(() -> Minecraft.func_71410_x().func_110434_K().func_110579_a(resID, (ITextureObject)texture));
            }
            theme.loadFromJson(themeJson);
            ResourceTheme resourceTheme = theme;
            return resourceTheme;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void buildCompressedFile(File fileOut, JsonObject jsonDetails, JsonObject jsonTheme, Collection<Tuple<ResourceLocation, File>> textures, String token, String service, int tier) {
        if (fileOut.exists()) {
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try (DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(fileOut)));){
            int format = JsonHelper.GetNumber(jsonDetails, "format", 0).intValue();
            dos.writeUTF(Base64.getEncoder().encodeToString(GSON.toJson((JsonElement)jsonDetails).getBytes(StandardCharsets.UTF_8)));
            byte[] key = format == 0 ? SupporterAPI.makeFormat_0(dos, rand.nextLong()) : SupporterAPI.makeFormat_1(dos, token, 3 + rand.nextInt(6), service, tier);
            dos.writeUTF(SupporterAPI.encode(GSON.toJson((JsonElement)jsonTheme), key));
            dos.writeInt(textures.size());
            for (Tuple<ResourceLocation, File> t : textures) {
                dos.writeUTF(SupporterAPI.encode(((ResourceLocation)t.func_76341_a()).toString(), key));
                BufferedImage bufImg = ImageIO.read((File)t.func_76340_b());
                int[] rgb = bufImg.getRGB(0, 0, bufImg.getWidth(), bufImg.getHeight(), null, 0, bufImg.getWidth());
                dos.writeInt(bufImg.getWidth());
                dos.writeInt(bufImg.getHeight());
                for (int i = 0; i < rgb.length; ++i) {
                    int flip = key[i * 4 % key.length];
                    flip |= key[(i * 4 + 1) % key.length] << 8;
                    flip |= key[(i * 4 + 2) % key.length] << 16;
                    dos.writeInt(rgb[i] ^ (flip |= key[(i * 4 + 3) % key.length] << 24));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String encode(String s, byte[] key) {
        return Base64.getEncoder().encodeToString(SupporterAPI.flipBytes(s.getBytes(StandardCharsets.UTF_8), key));
    }

    private static String decode(String s, byte[] key) {
        return new String(SupporterAPI.flipBytes(Base64.getDecoder().decode(s), key), StandardCharsets.UTF_8);
    }

    private static byte[] flipBytes(@Nonnull byte[] input, @Nonnull byte[] key) {
        byte[] output = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = (byte)(input[i] ^ key[i % key.length]);
        }
        return output;
    }

    private static byte[] makeFormat_0(@Nonnull DataOutputStream dos, long seed) throws IOException {
        byte[] b = new byte[16];
        new Random(seed).nextBytes(b);
        dos.writeLong(seed);
        return b;
    }

    private static byte[] makeFormat_1(@Nonnull DataOutputStream dos, @Nonnull String token, int salts, String service, int threshold) throws IOException {
        ArrayList<Tuple<Boolean, String>> list = new ArrayList<Tuple<Boolean, String>>();
        list.add(new Tuple((Object)true, (Object)token));
        for (int i = 0; i < salts; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = rand.nextInt(9) + 16; j >= 0; --j) {
                sb.append(charSet.charAt(rand.nextInt(charSet.length())));
            }
            list.add((Tuple<Boolean, String>)new Tuple((Object)false, (Object)sb.toString()));
        }
        Collections.shuffle(list, rand);
        return SupporterAPI.makeFormat_1(dos, list, service, threshold);
    }

    private static byte[] makeFormat_1(@Nonnull DataOutputStream dos, @Nonnull Collection<Tuple<Boolean, String>> tokens, String service, int threshold) throws IOException {
        dos.writeInt(tokens.size());
        int s = 0;
        HashSet<byte[]> l = new HashSet<byte[]>();
        for (Tuple<Boolean, String> t : tokens) {
            byte[] b;
            byte[] byArray = b = (Boolean)t.func_76341_a() != false ? ((String)t.func_76340_b()).getBytes(StandardCharsets.UTF_8) : new byte[16];
            if (!((Boolean)t.func_76341_a()).booleanValue()) {
                new Random(((String)t.func_76340_b()).hashCode()).nextBytes(b);
            }
            l.add(b);
            if (s < b.length) {
                s = b.length;
            }
            dos.writeUTF(Base64.getEncoder().encodeToString(((String)t.func_76340_b()).getBytes(StandardCharsets.UTF_8)));
        }
        dos.writeUTF(Base64.getEncoder().encodeToString(service.getBytes(StandardCharsets.UTF_8)));
        dos.writeInt(threshold);
        byte[] k = new byte[s];
        for (int i = 0; i < s; ++i) {
            for (byte[] e : l) {
                int n = i;
                k[n] = (byte)(k[n] ^ e[i % e.length]);
            }
        }
        return k;
    }

    @SideOnly(value=Side.CLIENT)
    private static byte[] readFileKey(@Nonnull DataInputStream dis, int format) {
        switch (format) {
            case -1: {
                return new byte[]{127};
            }
            case 0: {
                return SupporterAPI.readFormat_0(dis);
            }
            case 1: {
                return SupporterAPI.readFormat_1(dis);
            }
        }
        return new byte[]{127};
    }

    private static byte[] readFormat_0(@Nonnull DataInputStream dis) {
        try {
            byte[] b = new byte[16];
            long seed = dis.readLong();
            new Random(seed).nextBytes(b);
            return b;
        }
        catch (Exception ignored) {
            return new byte[]{127};
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static byte[] readFormat_1(@Nonnull DataInputStream dis) {
        try {
            String[] tokens = new String[dis.readInt()];
            for (int n = 0; n < tokens.length; ++n) {
                tokens[n] = new String(Base64.getDecoder().decode(dis.readUTF()));
            }
            String service = new String(Base64.getDecoder().decode(dis.readUTF()));
            int threshold = dis.readInt();
            UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            SupporterEntry entry = SupporterDB.INSTANCE.getValue(playerID);
            int m = 0;
            HashSet<byte[]> encoded = new HashSet<byte[]>();
            for (String k : tokens) {
                byte[] b;
                boolean c = entry != null && entry.getServices(k).entrySet().stream().anyMatch(v -> ((String)v.getKey()).equals(service) && (Integer)v.getValue() >= threshold);
                byte[] byArray = b = c ? k.getBytes(StandardCharsets.UTF_8) : new byte[16];
                if (c) {
                    new Random(k.hashCode()).nextBytes(b);
                }
                encoded.add(b);
                if (b.length <= m) continue;
                m = b.length;
            }
            byte[] merged = new byte[m];
            for (int i = 0; i < m; ++i) {
                for (byte[] e : encoded) {
                    int n = i;
                    merged[n] = (byte)(merged[n] ^ e[i % e.length]);
                }
            }
            return merged;
        }
        catch (Exception ignored) {
            return new byte[]{127};
        }
    }
}

