/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.machine;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.recipe.RecipesMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;

public class TileCentrifuge
extends TileMultiblockMachine {
    public static final Object[][][] structure = new Object[][][]{{{new BlockMeta(LibVulpesBlocks.blockStructureBlock), Character.valueOf('c'), new BlockMeta(LibVulpesBlocks.blockStructureBlock)}, {new BlockMeta(LibVulpesBlocks.blockStructureBlock), Character.valueOf('L'), new BlockMeta(LibVulpesBlocks.blockStructureBlock)}, {new BlockMeta(LibVulpesBlocks.blockStructureBlock), new BlockMeta(LibVulpesBlocks.blockStructureBlock), new BlockMeta(LibVulpesBlocks.blockStructureBlock)}}, {{LibVulpesBlocks.motors, new BlockMeta(LibVulpesBlocks.blockStructureBlock), LibVulpesBlocks.motors}, {Character.valueOf('l'), Character.valueOf('O'), Character.valueOf('l')}, {new BlockMeta(LibVulpesBlocks.blockStructureBlock), Character.valueOf('P'), new BlockMeta(LibVulpesBlocks.blockStructureBlock)}}};

    public Object[][][] getStructure() {
        return structure;
    }

    public boolean shouldHideBlock(World world, BlockPos pos2, IBlockState tile) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public void registerRecipes() {
        LinkedList<RecipesMachine.ChanceItemStack> nuggetList = new LinkedList<RecipesMachine.ChanceItemStack>();
        for (String entry : ARConfiguration.getCurrentConfig().lavaCentrifugeOutputs) {
            try {
                String[] split = entry.split(":");
                String chance = split[split.length - 1];
                String item = split[0];
                if (split.length != 2) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                float floatChance = Float.parseFloat(chance);
                NonNullList list2 = OreDictionary.getOres((String)item);
                if (list2.isEmpty()) continue;
                nuggetList.add(new RecipesMachine.ChanceItemStack((ItemStack)list2.get(0), floatChance));
            }
            catch (NumberFormatException e) {
                AdvancedRocketry.logger.warn("Unable to parse the weight for '" + entry + "' in lavaCentrifugeOutputs.  Remember, it should end with colon followed by a number with no spaces");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                AdvancedRocketry.logger.warn("Unable to parse the entry for '" + entry + "' in lavaCentrifugeOutputs.  Remember, there should be only an 'ore_dictionary_entry:chance' in the entry.  Items are not yet supported");
            }
        }
        LinkedList inputItems = new LinkedList();
        LinkedList outputFluid = new LinkedList();
        LinkedList<FluidStack> inputFluid = new LinkedList<FluidStack>();
        inputFluid.add(new FluidStack(AdvancedRocketryFluids.fluidEnrichedLava, 1000));
        RecipesMachine.Recipe rec = new RecipesMachine.Recipe(nuggetList, inputItems, outputFluid, inputFluid, 200, 10, new HashMap());
        rec.setMaxOutputSize(4);
        RecipesMachine.getInstance().getRecipes(TileCentrifuge.class).add(rec);
    }

    public SoundEvent getSound() {
        return AudioRegistry.electrolyser;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        modules.add(new ModuleProgress(100, 4, 0, TextureResources.crystallizerProgressBar, (IProgressBar)this));
        return modules;
    }

    public String getMachineName() {
        return "tile.centrifuge.name";
    }
}

