/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.network;

import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ProspectingNotification
implements IMessage {
    private static final List<UndergroundFluidPosition> emptyUndergroundFluids = new ArrayList<UndergroundFluidPosition>(0);
    private List<OreVeinPosition> oreVeins;
    private List<UndergroundFluidPosition> undergroundFluids;

    public ProspectingNotification() {
    }

    public ProspectingNotification(OreVeinPosition oreVeinPosition) {
        this.oreVeins = Collections.singletonList(oreVeinPosition);
        this.undergroundFluids = emptyUndergroundFluids;
    }

    public ProspectingNotification(List<OreVeinPosition> oreVeins, List<UndergroundFluidPosition> undergroundFluids) {
        this.oreVeins = oreVeins;
        this.undergroundFluids = undergroundFluids;
    }

    public void fromBytes(ByteBuf buf) {
        int numberOfOreVeins = buf.readInt();
        this.oreVeins = new ArrayList<OreVeinPosition>(numberOfOreVeins);
        for (int i = 0; i < numberOfOreVeins; ++i) {
            int dimensionId = buf.readInt();
            int chunkX = buf.readInt();
            int chunkZ = buf.readInt();
            String oreVeinName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.oreVeins.add(new OreVeinPosition(dimensionId, chunkX, chunkZ, VeinTypeCaching.getVeinType(oreVeinName)));
        }
        int numberOfUndergroundFluids = buf.readInt();
        this.undergroundFluids = new ArrayList<UndergroundFluidPosition>(numberOfUndergroundFluids);
        for (int i = 0; i < numberOfUndergroundFluids; ++i) {
            int dimensionId = buf.readInt();
            int chunkX = buf.readInt();
            int chunkZ = buf.readInt();
            Fluid fluid = FluidRegistry.getFluid((int)buf.readInt());
            int[][] chunks = new int[8][8];
            for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                    chunks[offsetChunkX][offsetChunkZ] = buf.readInt();
                }
            }
            this.undergroundFluids.add(new UndergroundFluidPosition(dimensionId, chunkX, chunkZ, fluid, chunks));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.oreVeins.size());
        for (OreVeinPosition oreVein : this.oreVeins) {
            buf.writeInt(oreVein.dimensionId);
            buf.writeInt(oreVein.chunkX);
            buf.writeInt(oreVein.chunkZ);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)oreVein.veinType.name);
        }
        buf.writeInt(this.undergroundFluids.size());
        for (UndergroundFluidPosition undergroundFluid : this.undergroundFluids) {
            buf.writeInt(undergroundFluid.dimensionId);
            buf.writeInt(undergroundFluid.chunkX);
            buf.writeInt(undergroundFluid.chunkZ);
            buf.writeInt(undergroundFluid.fluid.getID());
            for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                    buf.writeInt(undergroundFluid.chunks[offsetChunkX][offsetChunkZ]);
                }
            }
        }
    }

    public static class Handler
    implements IMessageHandler<ProspectingNotification, IMessage> {
        public IMessage onMessage(ProspectingNotification message, MessageContext ctx) {
            ClientCache.instance.putOreVeins(message.oreVeins);
            ClientCache.instance.putUndergroundFluids(message.undergroundFluids);
            return null;
        }
    }
}

