/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.buttons;

import com.sinthoras.visualprospecting.integration.model.MapState;
import com.sinthoras.visualprospecting.integration.model.SupportedMods;
import com.sinthoras.visualprospecting.integration.model.buttons.LayerButton;
import java.util.EnumMap;
import java.util.Map;

public class ButtonManager {
    private final String buttonTextKey;
    private final String iconName;
    private Map<SupportedMods, LayerButton> buttons = new EnumMap<SupportedMods, LayerButton>(SupportedMods.class);
    private boolean isActive = false;

    public ButtonManager(String buttonTextKey, String iconName) {
        this.buttonTextKey = buttonTextKey;
        this.iconName = iconName;
    }

    public void registerButton(SupportedMods map, LayerButton layerButton) {
        this.buttons.put(map, layerButton);
    }

    public void updateState(boolean active) {
        this.buttons.values().forEach(button -> button.updateState(active));
    }

    public boolean containsButton(LayerButton button) {
        return this.buttons.containsValue(button);
    }

    public String getButtonTextKey() {
        return this.buttonTextKey;
    }

    public String getIconName() {
        return this.iconName;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void activate() {
        MapState.instance.buttons.forEach(ButtonManager::deactivate);
        this.isActive = true;
        this.updateState(true);
    }

    public void deactivate() {
        this.isActive = false;
        this.updateState(false);
    }

    public void toggle() {
        if (this.isActive) {
            this.deactivate();
        } else {
            this.activate();
        }
    }
}

