/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.cachebuilder.AnalysisProgressTracker;
import com.sinthoras.visualprospecting.database.cachebuilder.ChunkAnalysis;
import com.sinthoras.visualprospecting.database.cachebuilder.DetailedChunkAnalysis;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.MinecraftRegion;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.MinecraftWorld;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTCompound;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;

public class DimensionAnalysis {
    public final int dimensionId;

    public DimensionAnalysis(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    public void processMinecraftWorld(MinecraftWorld world) throws IOException {
        ConcurrentHashMap veinBlockY = new ConcurrentHashMap();
        List<File> regionFiles = world.getAllRegionFiles(this.dimensionId);
        long dimensionSizeMB = regionFiles.stream().mapToLong(File::length).sum() >> 20;
        if (dimensionSizeMB <= (long)Config.maxDimensionSizeMBForFastScanning) {
            AnalysisProgressTracker.announceFastDimension(this.dimensionId);
            AnalysisProgressTracker.setNumberOfRegionFiles(regionFiles.size());
            ConcurrentHashMap chunksForSecondIdentificationPass = new ConcurrentHashMap();
            regionFiles.parallelStream().forEach(regionFile -> this.executeForEachGeneratedOreChunk((File)regionFile, (root, chunkX, chunkZ) -> {
                ChunkAnalysis chunk = new ChunkAnalysis();
                chunk.processMinecraftChunk(root);
                if (chunk.matchesSingleVein()) {
                    ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, chunkX, chunkZ, chunk.getMatchedVein());
                    veinBlockY.put(Utils.chunkCoordsToKey(chunkX, chunkZ), chunk.getVeinBlockY());
                } else {
                    DetailedChunkAnalysis detailedChunk = new DetailedChunkAnalysis(this.dimensionId, chunkX, chunkZ);
                    detailedChunk.processMinecraftChunk(root);
                    chunksForSecondIdentificationPass.put(Utils.chunkCoordsToKey(chunkX, chunkZ), detailedChunk);
                }
            }));
            chunksForSecondIdentificationPass.values().parallelStream().forEach(chunk -> {
                chunk.cleanUpWithNeighbors(veinBlockY);
                ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, chunk.chunkX, chunk.chunkZ, chunk.getMatchedVein());
            });
        } else {
            AnalysisProgressTracker.announceSlowDimension(this.dimensionId);
            AnalysisProgressTracker.setNumberOfRegionFiles(regionFiles.size() * 2);
            regionFiles.parallelStream().forEach(regionFile -> this.executeForEachGeneratedOreChunk((File)regionFile, (root, chunkX, chunkZ) -> {
                ChunkAnalysis chunk = new ChunkAnalysis();
                chunk.processMinecraftChunk(root);
                if (chunk.matchesSingleVein()) {
                    ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, chunkX, chunkZ, chunk.getMatchedVein());
                    veinBlockY.put(Utils.chunkCoordsToKey(chunkX, chunkZ), chunk.getVeinBlockY());
                }
            }));
            regionFiles.parallelStream().forEach(regionFile -> this.executeForEachGeneratedOreChunk((File)regionFile, (root, chunkX, chunkZ) -> {
                if (ServerCache.instance.getOreVein((int)this.dimensionId, (int)chunkX, (int)chunkZ).veinType == VeinType.NO_VEIN) {
                    DetailedChunkAnalysis detailedChunk = new DetailedChunkAnalysis(this.dimensionId, chunkX, chunkZ);
                    detailedChunk.processMinecraftChunk(root);
                    detailedChunk.cleanUpWithNeighbors(veinBlockY);
                    ServerCache.instance.notifyOreVeinGeneration(this.dimensionId, detailedChunk.chunkX, detailedChunk.chunkZ, detailedChunk.getMatchedVein());
                }
            }));
        }
    }

    private void executeForEachGeneratedOreChunk(File regionFile, IChunkHandler chunkHandler) {
        try {
            if (!Pattern.matches("^r\\.-?\\d+\\.-?\\d+\\.mca$", regionFile.getName())) {
                VP.warn("Invalid region file found! " + regionFile.getCanonicalPath() + " continuing");
                return;
            }
            String[] parts = regionFile.getName().split("\\.");
            int regionChunkX = Integer.parseInt(parts[1]) << 5;
            int regionChunkZ = Integer.parseInt(parts[2]) << 5;
            MinecraftRegion region = new MinecraftRegion(regionFile);
            for (int localChunkX = 0; localChunkX < 32; ++localChunkX) {
                for (int localChunkZ = 0; localChunkZ < 32; ++localChunkZ) {
                    NBTCompound root;
                    int chunkX = regionChunkX + localChunkX;
                    int chunkZ = regionChunkZ + localChunkZ;
                    if (chunkX != Utils.mapToCenterOreChunkCoord(chunkX) || chunkZ != Utils.mapToCenterOreChunkCoord(chunkZ) || (root = region.getChunk(localChunkX, localChunkZ).getRootTag()) == null) continue;
                    chunkHandler.processChunk(root, chunkX, chunkZ);
                }
            }
            region.close();
            AnalysisProgressTracker.regionFileProcessed();
        }
        catch (IOException | DataFormatException e) {
            AnalysisProgressTracker.notifyCorruptFile(regionFile);
        }
    }

    private static interface IChunkHandler {
        public void processChunk(NBTCompound var1, int var2, int var3);
    }
}

