/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.mixins.early.minecraft.MinecraftServerAccessor;
import java.io.File;
import java.text.DecimalFormat;
import net.minecraft.server.MinecraftServer;

public class AnalysisProgressTracker {
    private static int numberOfDimensions = 0;
    private static int dimensionsProcessed = 0;
    private static int numberOfRegionFiles = 0;
    private static int regionFilesProcessed = 0;
    private static long lastLogUpdate = 0L;
    private static long timestampMS = 0L;

    public static synchronized void setNumberOfDimensions(int numberOfDimensions) {
        timestampMS = System.currentTimeMillis();
        AnalysisProgressTracker.numberOfDimensions = numberOfDimensions;
        dimensionsProcessed = 0;
        AnalysisProgressTracker.updateLog();
    }

    public static synchronized void dimensionProcessed() {
        ++dimensionsProcessed;
        AnalysisProgressTracker.updateLog();
    }

    public static synchronized void announceFastDimension(int dimensionId) {
        String message = "Processing dimension with id " + dimensionId + " with fast scanning.";
        VP.info(message);
        if (Utils.isLogicalClient()) {
            ((MinecraftServerAccessor)MinecraftServer.func_71276_C()).setUserMessage(message);
        }
    }

    public static synchronized void announceSlowDimension(int dimensionId) {
        String message = "Processing dimension with id " + dimensionId + " with slow (safe) scanning.";
        VP.info(message);
        if (Utils.isLogicalClient()) {
            ((MinecraftServerAccessor)MinecraftServer.func_71276_C()).setUserMessage(message);
        }
    }

    public static synchronized void setNumberOfRegionFiles(int numberOfRegionFiles) {
        AnalysisProgressTracker.numberOfRegionFiles = numberOfRegionFiles;
        regionFilesProcessed = 0;
        AnalysisProgressTracker.updateLog();
    }

    public static synchronized void regionFileProcessed() {
        ++regionFilesProcessed;
        AnalysisProgressTracker.updateLog();
    }

    private static synchronized void updateLog() {
        long timestamp = System.currentTimeMillis();
        if (timestamp - (long)Config.cacheGenerationLogUpdateMinTime * 1000L > lastLogUpdate) {
            lastLogUpdate = timestamp;
            String message = "Caching GT ore generation meta data - Dimension (" + (dimensionsProcessed + 1) + "/" + numberOfDimensions + ")  " + (numberOfRegionFiles == 0 ? 0 : regionFilesProcessed * 100 / numberOfRegionFiles) + "%";
            VP.info(message);
            if (Utils.isLogicalClient()) {
                ((MinecraftServerAccessor)MinecraftServer.func_71276_C()).setUserMessage(message + "%");
            }
        }
    }

    public static synchronized void processingFinished() {
        long elapsedTimeMS = System.currentTimeMillis() - timestampMS;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
        String message = "Parsing complete! Thank you for your patience.  - Duration: " + format.format(elapsedTimeMS / 1000L) + "sec";
        VP.info(message);
        if (Utils.isLogicalClient()) {
            ((MinecraftServerAccessor)MinecraftServer.func_71276_C()).setUserMessage(message);
        }
    }

    public static synchronized void notifyCorruptFile(File regionFile) {
        String message = "Encountered corrupt/malformed/modified save file: " + regionFile;
        VP.info(message);
        if (Utils.isLogicalClient()) {
            ((MinecraftServerAccessor)MinecraftServer.func_71276_C()).setUserMessage(message);
        }
    }
}

