/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.parts;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.client.textures.BlockTextureManager;
import thaumicenergistics.common.ThEGuiHandler;
import thaumicenergistics.common.grid.AEPartGridBlock;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.utils.EffectiveSide;
import thaumicenergistics.common.utils.ThELog;
import thaumicenergistics.common.utils.ThEUtils;

public abstract class ThEPartBase
implements IPart,
IGridHost,
IActionHost,
IPowerChannelState {
    private static final String NBT_KEY_OWNER = "Owner";
    protected static final int INVENTORY_OVERLAY_COLOR = AEColor.Black.blackVariant;
    protected static final int ACTIVE_FACE_BRIGHTNESS = 0xD000D0;
    protected static final int ACTIVE_TERMINAL_LIGHT_LEVEL = 9;
    private final SecurityPermissions[] interactionPermissions;
    private IPartHost host;
    private TileEntity hostTile;
    private ForgeDirection cableSide;
    private boolean isActive;
    private boolean isPowered;
    private IGridNode node;
    private final AEPartGridBlock gridBlock;
    private int ownerID = -1;
    public final ItemStack associatedItem;

    public ThEPartBase(AEPartsEnum associatedPart, SecurityPermissions ... interactionPermissions) {
        this.associatedItem = associatedPart.getStack();
        this.interactionPermissions = interactionPermissions != null && interactionPermissions.length > 0 ? interactionPermissions : null;
        this.gridBlock = EffectiveSide.isServerSide() ? new AEPartGridBlock(this) : null;
    }

    private void updateStatus() {
        boolean currentlyActive;
        if (EffectiveSide.isClientSide()) {
            return;
        }
        if (this.node != null && (currentlyActive = this.node.isActive()) != this.isActive) {
            this.isActive = currentlyActive;
            this.host.markForUpdate();
        }
        this.onNeighborChanged();
    }

    protected boolean doesPlayerHavePermission(EntityPlayer player, SecurityPermissions permission) {
        if (EffectiveSide.isClientSide()) {
            return false;
        }
        ISecurityGrid sGrid = this.gridBlock.getSecurityGrid();
        if (sGrid == null) {
            return false;
        }
        return sGrid.hasPermission(player, permission);
    }

    protected boolean doesPlayerHavePermission(int playerID, SecurityPermissions permission) {
        if (EffectiveSide.isClientSide()) {
            return false;
        }
        ISecurityGrid sGrid = this.gridBlock.getSecurityGrid();
        if (sGrid == null) {
            return false;
        }
        return sGrid.hasPermission(playerID, permission);
    }

    protected TileEntity getFacingTile() {
        if (this.hostTile == null) {
            return null;
        }
        World world = this.hostTile.func_145831_w();
        if (world == null) {
            return null;
        }
        int x = this.hostTile.field_145851_c;
        int y = this.hostTile.field_145848_d;
        int z = this.hostTile.field_145849_e;
        return world.func_147438_o(x + this.cableSide.offsetX, y + this.cableSide.offsetY, z + this.cableSide.offsetZ);
    }

    public void addToWorld() {
        if (EffectiveSide.isClientSide()) {
            return;
        }
        this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
        this.node.setPlayerID(this.ownerID);
        if (this.hostTile != null && this.host != null && this.hostTile.func_145831_w() != null) {
            try {
                this.node.updateState();
            }
            catch (Exception e) {
                ThELog.error(e, "Part (%s) was unable to update it's node. The part may not function correctly", this.associatedItem.func_82833_r());
            }
        }
        this.updateStatus();
    }

    public abstract int cableConnectionRenderTo();

    public boolean canBePlacedOn(BusSupport type) {
        return type == BusSupport.CABLE;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public IGridNode getActionableNode() {
        return this.node;
    }

    public abstract void getBoxes(IPartCollisionHelper var1);

    @SideOnly(value=Side.CLIENT)
    public abstract IIcon getBreakingTexture();

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return null;
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    public final IGridNode getExternalFacingNode() {
        return null;
    }

    public AEPartGridBlock getGridBlock() {
        return this.gridBlock;
    }

    public IGridNode getGridNode() {
        return this.node;
    }

    public IGridNode getGridNode(ForgeDirection direction) {
        return this.node;
    }

    public final IPartHost getHost() {
        return this.host;
    }

    public final TileEntity getHostTile() {
        return this.hostTile;
    }

    public abstract double getIdlePowerUsage();

    public ItemStack getItemStack(PartItemStack type) {
        ItemStack itemStack = this.associatedItem.func_77946_l();
        if (type == PartItemStack.Wrench) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.writeToNBT(itemNBT, PartItemStack.Wrench);
            if (!itemNBT.func_82582_d()) {
                itemStack.func_77982_d(itemNBT);
            }
        }
        return itemStack;
    }

    public abstract int getLightLevel();

    public final DimensionalCoord getLocation() {
        return new DimensionalCoord(this.hostTile.func_145831_w(), this.hostTile.field_145851_c, this.hostTile.field_145848_d, this.hostTile.field_145849_e);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return null;
    }

    public ForgeDirection getSide() {
        return this.cableSide;
    }

    public String getUnlocalizedName() {
        return this.associatedItem.func_77977_a() + ".name";
    }

    public boolean isActive() {
        if (EffectiveSide.isServerSide()) {
            this.isActive = this.node != null ? this.node.isActive() : false;
        }
        return this.isActive;
    }

    public boolean isLadder(EntityLivingBase entity) {
        return false;
    }

    public final boolean isPartUseableByPlayer(EntityPlayer player) {
        if (EffectiveSide.isClientSide()) {
            return false;
        }
        if (this.hostTile == null || this.host == null) {
            return false;
        }
        if (!ThEUtils.canPlayerInteractWith(player, this.hostTile)) {
            return false;
        }
        if (this.host.getPart(this.cableSide) != this) {
            return false;
        }
        if (this.interactionPermissions != null) {
            ISecurityGrid sGrid = this.gridBlock.getSecurityGrid();
            if (sGrid == null) {
                return false;
            }
            for (SecurityPermissions perm : this.interactionPermissions) {
                if (sGrid.hasPermission(player, perm)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPowered() {
        try {
            if (EffectiveSide.isServerSide() && this.gridBlock != null) {
                IEnergyGrid eGrid = this.gridBlock.getEnergyGrid();
                this.isPowered = eGrid != null ? eGrid.isNetworkPowered() : false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isPowered;
    }

    public int isProvidingStrongPower() {
        return 0;
    }

    public int isProvidingWeakPower() {
        return 0;
    }

    public boolean isReceivingRedstonePower() {
        if (this.host != null) {
            return this.host.hasRedstone(this.cableSide);
        }
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public final void markForSave() {
        if (this.host != null) {
            this.host.markForSave();
        }
    }

    public final void markForUpdate() {
        if (this.host != null) {
            this.host.markForUpdate();
        }
    }

    public boolean onActivate(EntityPlayer player, Vec3 position) {
        if (player.func_70093_af()) {
            return false;
        }
        if (EffectiveSide.isServerSide()) {
            ThEGuiHandler.launchGui(this, player, this.hostTile.func_145831_w(), this.hostTile.field_145851_c, this.hostTile.field_145848_d, this.hostTile.field_145849_e);
        }
        return true;
    }

    public void onEntityCollision(Entity entity) {
    }

    public void onNeighborChanged() {
    }

    public final void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        this.ownerID = AEApi.instance().registries().players().getID(player.func_146103_bH());
    }

    public boolean onShiftActivate(EntityPlayer player, Vec3 position) {
        return false;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b(NBT_KEY_OWNER)) {
            this.ownerID = data.func_74762_e(NBT_KEY_OWNER);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean readFromStream(ByteBuf stream) throws IOException {
        boolean oldActive = this.isActive;
        boolean oldPowered = this.isPowered;
        this.isActive = stream.readBoolean();
        this.isPowered = stream.readBoolean();
        return oldActive != this.isActive || oldPowered != this.isPowered;
    }

    public void removeFromWorld() {
        if (this.node != null) {
            this.node.destroy();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper helper, RenderBlocks renderer) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderInventory(IPartRenderHelper var1, RenderBlocks var2);

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryBusLights(IPartRenderHelper helper, RenderBlocks renderer) {
        helper.setInvColor(0xFFFFFF);
        IIcon busColorTexture = BlockTextureManager.BUS_COLOR.getTextures()[0];
        IIcon sideTexture = BlockTextureManager.BUS_COLOR.getTextures()[2];
        helper.setTexture(busColorTexture, busColorTexture, sideTexture, sideTexture, busColorTexture, busColorTexture);
        helper.renderInventoryBox(renderer);
        Tessellator.field_78398_a.func_78380_c(0xD000D0);
        helper.setInvColor(AEColor.Transparent.blackVariant);
        IIcon lightTexture = BlockTextureManager.BUS_COLOR.getTextures()[1];
        helper.renderInventoryFace(lightTexture, ForgeDirection.UP, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.DOWN, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.NORTH, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.EAST, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.SOUTH, renderer);
        helper.renderInventoryFace(lightTexture, ForgeDirection.WEST, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(int var1, int var2, int var3, IPartRenderHelper var4, RenderBlocks var5);

    @SideOnly(value=Side.CLIENT)
    public void renderStaticBusLights(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        IIcon busColorTexture = BlockTextureManager.BUS_COLOR.getTextures()[0];
        IIcon sideTexture = BlockTextureManager.BUS_COLOR.getTextures()[2];
        helper.setTexture(busColorTexture, busColorTexture, sideTexture, sideTexture, busColorTexture, busColorTexture);
        helper.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
            Tessellator.field_78398_a.func_78378_d(this.host.getColor().blackVariant);
        } else {
            Tessellator.field_78398_a.func_78378_d(0);
        }
        IIcon lightTexture = BlockTextureManager.BUS_COLOR.getTextures()[1];
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.UP, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.DOWN, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.NORTH, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.EAST, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.SOUTH, renderer);
        helper.renderFace(x, y, z, lightTexture, ForgeDirection.WEST, renderer);
    }

    public boolean requireDynamicRender() {
        return false;
    }

    public void securityBreak() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItemStack(PartItemStack.Break));
        this.getDrops(drops, false);
        Platform.spawnDrops((World)this.hostTile.func_145831_w(), (int)this.hostTile.field_145851_c, (int)this.hostTile.field_145848_d, (int)this.hostTile.field_145849_e, drops);
        this.host.removePart(this.cableSide, false);
    }

    public final void setPartHostInfo(ForgeDirection side, IPartHost host, TileEntity tile) {
        this.cableSide = side;
        this.host = host;
        this.hostTile = tile;
    }

    @MENetworkEventSubscribe
    public final void setPower(MENetworkPowerStatusChange event) {
        this.updateStatus();
    }

    public void setupPartFromItem(ItemStack itemPart) {
        if (itemPart.func_77942_o()) {
            this.readFromNBT(itemPart.func_77978_p());
        }
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged event) {
        this.updateStatus();
    }

    public final void writeToNBT(NBTTagCompound data) {
        this.writeToNBT(data, PartItemStack.World);
    }

    public void writeToNBT(NBTTagCompound data, PartItemStack saveType) {
        if (saveType == PartItemStack.World) {
            data.func_74768_a(NBT_KEY_OWNER, this.ownerID);
        }
    }

    public void writeToStream(ByteBuf stream) throws IOException {
        stream.writeBoolean(this.isActive());
        stream.writeBoolean(this.isPowered());
    }
}

