/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.features;

import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchPage;
import thaumicenergistics.api.IThEConfig;
import thaumicenergistics.api.IThEItems;
import thaumicenergistics.api.IThEParts;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.common.features.CommonDependantItems;
import thaumicenergistics.common.features.ThEThaumcraftResearchFeature;
import thaumicenergistics.common.parts.AEPartsEnum;
import thaumicenergistics.common.registries.FeatureRegistry;
import thaumicenergistics.common.registries.RecipeRegistry;
import thaumicenergistics.common.registries.ResearchRegistry;

public class FeatureEssentiaMonitoring
extends ThEThaumcraftResearchFeature {
    private boolean isWirelessEnabled = false;
    private boolean isConversionEnabled = false;

    public FeatureEssentiaMonitoring() {
        super(ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.getKey());
    }

    @Override
    protected boolean checkConfigs(IThEConfig theConfig) {
        this.isConversionEnabled = AEConfig.instance.isFeatureEnabled(AEFeature.PartConversionMonitor);
        this.isWirelessEnabled = AEConfig.instance.isFeatureEnabled(AEFeature.WirelessAccessTerminal) && theConfig.craftWirelessEssentiaTerminal();
        return true;
    }

    @Override
    protected Object[] getItemReqs(CommonDependantItems cdi) {
        this.isWirelessEnabled &= cdi.DenseCell != null && cdi.WirelessReceiver != null;
        return new Object[]{cdi.LogicProcessor, cdi.CalculationProcessor};
    }

    @Override
    protected ThEThaumcraftResearchFeature getParentFeature() {
        return FeatureRegistry.instance().featureConversionCores;
    }

    @Override
    protected void registerCrafting(CommonDependantItems cdi) {
        IThEItems theItems = ThEApi.instance().items();
        IThEParts theParts = ThEApi.instance().parts();
        ItemStack DiffusionCore = theItems.DiffusionCore.getStack();
        ItemStack CoalescenceCore = theItems.CoalescenceCore.getStack();
        ItemStack EssentiaTerminal = theParts.Essentia_Terminal.getStack();
        ItemStack EssentiaLevelEmitter = theParts.Essentia_LevelEmitter.getStack();
        ItemStack EssentiaStorageMonitor = theParts.Essentia_StorageMonitor.getStack();
        AspectList etAspectList = new AspectList();
        etAspectList.add(Aspect.WATER, 5);
        etAspectList.add(Aspect.ORDER, 2);
        etAspectList.add(Aspect.FIRE, 1);
        RecipeRegistry.PART_ESSENTIA_TERMINAL = ThaumcraftApi.addShapelessArcaneCraftingRecipe((String)this.researchKey, (ItemStack)EssentiaTerminal, (AspectList)etAspectList, (Object[])new Object[]{cdi.IlluminatedPanel, DiffusionCore, CoalescenceCore, cdi.LogicProcessor, cdi.VisFilter});
        if (this.isWirelessEnabled) {
            ItemStack WirelessEssentiaTerminal = theItems.WirelessEssentiaTerminal.getStack();
            RecipeRegistry.ITEM_WIRELESS_ESSENTIA_TERMINAL = new ShapelessOreRecipe(WirelessEssentiaTerminal, new Object[]{cdi.WirelessReceiver, EssentiaTerminal, cdi.DenseCell});
            GameRegistry.addRecipe((IRecipe)RecipeRegistry.ITEM_WIRELESS_ESSENTIA_TERMINAL);
        }
        AspectList emitterAspectList = new AspectList();
        emitterAspectList.add(Aspect.FIRE, 4);
        EssentiaLevelEmitter.field_77994_a = 4;
        RecipeRegistry.PART_ESSENTIA_LEVEL_EMITTER = ThaumcraftApi.addShapelessArcaneCraftingRecipe((String)this.researchKey, (ItemStack)EssentiaLevelEmitter, (AspectList)emitterAspectList, (Object[])new Object[]{cdi.CalculationProcessor, cdi.RedstoneTorch, cdi.SalisMundus});
        RecipeRegistry.PART_ESSENTIA_STORAGE_MONITOR = new ShapelessOreRecipe(EssentiaStorageMonitor, new Object[]{EssentiaLevelEmitter, cdi.IlluminatedPanel});
        GameRegistry.addRecipe((IRecipe)RecipeRegistry.PART_ESSENTIA_STORAGE_MONITOR);
        if (this.isConversionEnabled) {
            ItemStack EssentiaConversionMonitor = theParts.Essentia_ConversionMonitor.getStack();
            RecipeRegistry.PART_ESSENTIA_CONVERSION_MONITOR = new ShapelessOreRecipe(EssentiaConversionMonitor, new Object[]{CoalescenceCore, EssentiaStorageMonitor, DiffusionCore});
            GameRegistry.addRecipe((IRecipe)RecipeRegistry.PART_ESSENTIA_CONVERSION_MONITOR);
        }
    }

    @Override
    protected void registerPseudoParents() {
    }

    @Override
    protected void registerResearch() {
        AspectList etAspectList = new AspectList();
        etAspectList.add(Aspect.EXCHANGE, 5);
        etAspectList.add(Aspect.SENSES, 5);
        etAspectList.add(Aspect.ENERGY, 3);
        etAspectList.add(Aspect.WATER, 3);
        ItemStack etIcon = AEPartsEnum.EssentiaTerminal.getStack();
        ArrayList<ResearchPage> pageList = new ArrayList<ResearchPage>();
        pageList.add(new ResearchPage(ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.getPageName(1)));
        pageList.add(new ResearchPage(ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.getPageName(2)));
        pageList.add(new ResearchPage(RecipeRegistry.PART_ESSENTIA_TERMINAL));
        if (this.isWirelessEnabled) {
            pageList.add(new ResearchPage(RecipeRegistry.ITEM_WIRELESS_ESSENTIA_TERMINAL));
        }
        pageList.add(new ResearchPage(ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.getPageName(3)));
        pageList.add(new ResearchPage(RecipeRegistry.PART_ESSENTIA_LEVEL_EMITTER));
        pageList.add(new ResearchPage(ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.getPageName(4)));
        pageList.add(new ResearchPage(RecipeRegistry.PART_ESSENTIA_STORAGE_MONITOR));
        if (this.isConversionEnabled) {
            pageList.add(new ResearchPage(RecipeRegistry.PART_ESSENTIA_CONVERSION_MONITOR));
        }
        ResearchPage[] etPages = pageList.toArray(new ResearchPage[pageList.size()]);
        ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.createResearchItem(etAspectList, 1, etIcon, etPages);
        ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.researchItem.setParents(new String[]{this.getFirstValidParentKey(false)});
        ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.researchItem.setConcealed();
        ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.researchItem.setSecondary();
        ResearchRegistry.ResearchTypes.ESSENTIA_TERMINAL.researchItem.registerResearchItem();
    }
}

