/*
 * Decompiled with CFR 0.152.
 */
package locusway.overloadedarmorbar.overlay;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import locusway.overloadedarmorbar.ConfigurationHandler;
import locusway.overloadedarmorbar.overlay.ArmorBar;
import locusway.overloadedarmorbar.overlay.ArmorIcon;
import locusway.overloadedarmorbar.overlay.ArmorIconColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.opengl.GL11;

public class OverlayEventHandler {
    public static final OverlayEventHandler INSTANCE = new OverlayEventHandler();
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private int previousArmorValue = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_SECOND_HALF_ICON_SIZE = 4;
    private final Minecraft mc = Minecraft.func_71410_x();
    private ArmorIcon[] armorIcons;

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().field_71456_v.func_73729_b(x, y, textureX, textureY, width, height);
    }

    private OverlayEventHandler() {
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderGameOverlayEventPre(RenderGameOverlayEvent event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ARMOR) {
            return;
        }
        ScaledResolution scale = event.resolution;
        int scaledWidth = scale.func_78326_a();
        int scaledHeight = scale.func_78328_b();
        event.setCanceled(true);
        INSTANCE.renderArmorBar(scaledWidth, scaledHeight);
    }

    private int calculateArmorValue() {
        return ForgeHooks.getTotalArmorValue((EntityPlayer)this.mc.field_71439_g);
    }

    public void renderArmorBar(int screenWidth, int screenHeight) {
        EntityClientPlayerMP player = this.mc.field_71439_g;
        int currentArmorValue = this.calculateArmorValue();
        int xStart = screenWidth / 2 - 91;
        int yStart = screenHeight - 39;
        IAttributeInstance playerHealthAttribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float playerHealth = (float)playerHealthAttribute.func_111126_e();
        if (!ConfigurationHandler.offset && playerHealth > 20.0f) {
            playerHealth = 20.0f;
        }
        float absorptionAmount = MathHelper.func_76123_f((float)player.func_110139_bj());
        if (!ConfigurationHandler.offset && absorptionAmount > 20.0f) {
            absorptionAmount = 20.0f;
        }
        int numberOfHealthBars = (int)Math.ceil(playerHealth / 20.0f) + (int)Math.ceil(absorptionAmount / 20.0f);
        int i2 = Math.max(10 - (numberOfHealthBars - 2), 3);
        int yPosition = yStart - (numberOfHealthBars - 1) * i2 - 10;
        if (currentArmorValue != this.previousArmorValue) {
            this.armorIcons = ArmorBar.calculateArmorIcons(currentArmorValue);
            this.previousArmorValue = currentArmorValue;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        int armorIconCounter = 0;
        for (ArmorIcon icon : this.armorIcons) {
            int xPosition = xStart + armorIconCounter * 8;
            switch (icon.armorIconType) {
                case NONE: {
                    ArmorIconColor color = icon.primaryArmorIconColor;
                    GL11.glColor4f((float)color.Red, (float)color.Green, (float)color.Blue, (float)color.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 34, 9, 9, 9);
                        break;
                    }
                    if (!ConfigurationHandler.showEmptyArmorIcons || !ConfigurationHandler.alwaysShowArmorBar && currentArmorValue <= 0) break;
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 16, 9, 9, 9);
                    break;
                }
                case HALF: {
                    ArmorIconColor firstHalfColor = icon.primaryArmorIconColor;
                    ArmorIconColor secondHalfColor = icon.secondaryArmorIconColor;
                    GL11.glColor4f((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)firstHalfColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 25, 9, 5, 9);
                    GL11.glColor4f((float)secondHalfColor.Red, (float)secondHalfColor.Green, (float)secondHalfColor.Blue, (float)secondHalfColor.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(xPosition + 5, yPosition, 39, 9, 4, 9);
                        break;
                    }
                    OverlayEventHandler.drawTexturedModalRect(xPosition + 5, yPosition, 30, 9, 4, 9);
                    break;
                }
                case FULL: {
                    ArmorIconColor fullColor = icon.primaryArmorIconColor;
                    GL11.glColor4f((float)fullColor.Red, (float)fullColor.Green, (float)fullColor.Blue, (float)fullColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 34, 9, 9, 9);
                    break;
                }
            }
            ++armorIconCounter;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void forceUpdate() {
        OverlayEventHandler.INSTANCE.previousArmorValue = -1;
    }
}

