/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.tileentity.TileEntityMachineBase;

public class TileEntityEntityDetector
extends TileEntityMachineBase
implements Environment {
    public int range = OpenSecurity.rfidRange;
    public boolean offset = false;
    protected ComponentConnector node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(TileEntityEntityDetector.getComponentName()).withConnector(32.0).create();

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    private static String getComponentName() {
        return "os_entdetector";
    }

    public void onConnect(Node arg0) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message arg0) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    private HashMap<String, Object> info(Entity entity, boolean offset) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        double rangeToEntity = entity.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        String name = entity instanceof EntityPlayerMP ? ((EntityPlayer)entity).getDisplayName() : entity.func_70005_c_();
        value.put("name", name);
        value.put("range", rangeToEntity);
        if (!offset) {
            this.node.sendToReachable("computer.signal", new Object[]{"entityDetect", name, rangeToEntity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v});
            value.put("x", entity.field_70165_t);
            value.put("y", entity.field_70163_u);
            value.put("z", entity.field_70161_v);
        } else {
            this.node.sendToReachable("computer.signal", new Object[]{"entityDetect", name, rangeToEntity, entity.field_70165_t - (double)this.field_145851_c, entity.field_70163_u - (double)this.field_145848_d, entity.field_70161_v - (double)this.field_145849_e});
            value.put("x", entity.field_70165_t - (double)this.field_145851_c);
            value.put("y", entity.field_70163_u - (double)this.field_145848_d);
            value.put("z", entity.field_70161_v - (double)this.field_145849_e);
        }
        return value;
    }

    public Map<Integer, HashMap<String, Object>> scan(boolean players, boolean offset) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, block, 20);
        HashMap<Integer, HashMap<String, Object>> output = new HashMap<Integer, HashMap<String, Object>>();
        int index = 1;
        List e = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.range), (double)(this.field_145848_d - this.range), (double)(this.field_145849_e - this.range), (double)(this.field_145851_c + this.range), (double)(this.field_145848_d + this.range), (double)(this.field_145849_e + this.range)));
        if (!e.isEmpty()) {
            for (int i = 0; i <= e.size() - 1; ++i) {
                Entity entity = (Entity)e.get(i);
                if (players && entity instanceof EntityPlayerMP) {
                    output.put(index++, this.info(entity, offset));
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 3);
                    continue;
                }
                if (players) continue;
                output.put(index++, this.info(entity, offset));
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, 3);
            }
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, 3);
        }
        return output;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.node != null && this.node.network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
    }

    @Callback
    public Object[] getLoc(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(doc="function(optional:int:range):table; pushes a signal \"entityDetect\" for each player in range, optional set range.", direct=true)
    public Object[] scanPlayers(Context context, Arguments args) {
        this.range = args.optInteger(0, this.range);
        this.offset = args.optBoolean(1, this.offset);
        if (this.range > OpenSecurity.rfidRange) {
            this.range = OpenSecurity.rfidRange;
        }
        this.range /= 2;
        if (this.node.changeBuffer((double)(-5 * this.range)) == 0.0) {
            return new Object[]{this.scan(true, this.offset)};
        }
        return new Object[]{false, "Not enough power in OC Network."};
    }

    @Callback(doc="function(optional:int:range):table; pushes a signal \"entityDetect\" for each entity in range (excluding players), optional set range.", direct=true)
    public Object[] scanEntities(Context context, Arguments args) {
        this.range = args.optInteger(0, this.range);
        this.offset = args.optBoolean(1, this.offset);
        if (this.range > OpenSecurity.rfidRange) {
            this.range = OpenSecurity.rfidRange;
        }
        this.range /= 2;
        if (this.node.changeBuffer((double)(-5 * this.range)) == 0.0) {
            return new Object[]{this.scan(false, this.offset)};
        }
        return new Object[]{false, "Not enough power in OC Network."};
    }
}

