/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.tileentity;

import java.nio.charset.Charset;
import java.util.UUID;
import li.cil.oc.Settings;
import li.cil.oc.api.Items;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.common.item.EEPROM;
import li.cil.oc.server.network.Network;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import pcl.opensecurity.ContentRegistry;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.items.ItemMagCard;
import pcl.opensecurity.items.ItemRFIDCard;
import pcl.opensecurity.tileentity.TileEntityMachineBase;
import scala.actors.threadpool.Arrays;

public class TileEntityCardWriter
extends TileEntityMachineBase
implements Environment,
IInventory,
ISidedInventory {
    public ComponentConnector node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    protected boolean addedToNetwork = false;
    public boolean hasCards = false;
    private Object oc_fs;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] slots_sides = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private ItemStack[] CardWriterItemStacks = new ItemStack[12];

    public TileEntityCardWriter() {
        if (this.node() != null) {
            this.initOCFilesystem();
        }
    }

    protected ManagedEnvironment oc_fs() {
        return (ManagedEnvironment)this.oc_fs;
    }

    private void initOCFilesystem() {
        this.oc_fs = li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(OpenSecurity.class, (String)"opensecurity", (String)"/lua/cardwriter/"), (String)"cardwriter");
        ((Component)this.oc_fs().node()).setVisibility(Visibility.Network);
    }

    public void onConnect(Node node) {
        if (node == this.node()) {
            node.connect(this.oc_fs().node());
        }
    }

    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            node.disconnect(this.oc_fs().node());
        } else if (node == this.node) {
            this.oc_fs().node().remove();
        }
    }

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slots_bottom : (par1 == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int func_70302_i_() {
        return this.CardWriterItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.CardWriterItemStacks[i];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        if (this.func_70301_a(i) != null) {
            ItemStack var2 = this.func_70301_a(i);
            this.func_70299_a(i, null);
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.CardWriterItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "os_cardwriter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i == 0 && (itemstack.func_77973_b() instanceof ItemRFIDCard || itemstack.func_77973_b() instanceof ItemMagCard || itemstack.func_77973_b() instanceof EEPROM)) {
            return itemstack.field_77990_d == null || !itemstack.field_77990_d.func_74764_b("locked") && !itemstack.field_77990_d.func_74764_b("oc:readonly");
        }
        return false;
    }

    public String getComponentName() {
        return "os_cardwriter";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.addedToNetwork) {
            this.addToNetwork();
        }
        if (!this.hasCards && this.func_70301_a(0) != null) {
            this.hasCards = true;
            if (this.node != null) {
                this.node.sendToReachable("computer.signal", new Object[]{"cardInsert", "cardInsert"});
            }
        }
        if (this.hasCards && this.func_70301_a(0) == null) {
            this.hasCards = false;
            if (this.node != null) {
                this.node.sendToReachable("computer.signal", new Object[]{"cardRemove", "cardRemove"});
            }
        }
    }

    protected void addToNetwork() {
        if (!this.addedToNetwork) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
        if (this.oc_fs != null && this.oc_fs().node() != null) {
            this.oc_fs().node().load(nbt.func_74775_l("oc:fs"));
        }
        NBTTagList var2 = nbt.func_150295_c("Items", (int)nbt.func_74732_a());
        this.CardWriterItemStacks = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.CardWriterItemStacks.length) continue;
            this.CardWriterItemStacks[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        if (this.oc_fs != null && this.oc_fs().node() != null) {
            NBTTagCompound fsNbt = new NBTTagCompound();
            this.oc_fs().node().save(fsNbt);
            nbt.func_74782_a("oc:fs", (NBTBase)fsNbt);
        }
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.CardWriterItemStacks.length; ++var3) {
            if (this.CardWriterItemStacks[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.CardWriterItemStacks[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Callback
    public Object[] flash(Context context, Arguments args) {
        byte[] code = args.checkString(0).getBytes(Charset.forName("UTF-8"));
        String title = args.checkString(1);
        Boolean locked = args.checkBoolean(2);
        ItemStack eepromItem = Items.get((String)"eeprom").createItemStack(1);
        if (code != null) {
            if (this.func_70301_a(0) != null) {
                for (int x = 3; x <= 12; ++x) {
                    if (this.func_70301_a(x) != null) continue;
                    if (this.func_70301_a(0).func_77973_b() instanceof EEPROM) {
                        this.CardWriterItemStacks[x] = eepromItem;
                        NBTTagCompound oc_data = new NBTTagCompound();
                        NBTTagCompound our_data = new NBTTagCompound();
                        if (!OpenSecurity.cfg.biggerEEPROM && code.length > Settings.get().eepromSize()) {
                            code = Arrays.copyOfRange((byte[])code, (int)0, (int)Settings.get().eepromSize());
                        } else if (OpenSecurity.cfg.biggerEEPROM && code.length > 8096) {
                            code = Arrays.copyOfRange((byte[])code, (int)0, (int)Settings.get().eepromSize());
                        }
                        if (!OpenSecurity.cfg.biggerEEPROM && title.length() > Settings.get().eepromDataSize()) {
                            title = title.substring(0, Settings.get().eepromDataSize());
                        } else if (OpenSecurity.cfg.biggerEEPROM && title.length() > 512) {
                            title = title.substring(0, Settings.get().eepromDataSize());
                        }
                        our_data.func_74773_a("oc:eeprom", code);
                        our_data.func_74778_a("oc:label", title);
                        our_data.func_74757_a("oc:readonly", locked.booleanValue());
                        oc_data.func_74782_a("oc:data", (NBTBase)our_data);
                        this.CardWriterItemStacks[x].func_77982_d(oc_data);
                        this.func_70298_a(0, 1);
                        return new Object[]{true};
                    }
                    return new Object[]{false, "Item is not EEPROM"};
                }
                return new Object[]{false, "No Empty Slots"};
            }
            return new Object[]{false, "No EEPROM in slot"};
        }
        return new Object[]{false, "Data is Null"};
    }

    @Callback(doc="function(string: data, string: displayName, boolean: locked, int: color):string; writes data to the card, (64 characters for RFID, or 128 for MagStripe), the rest is silently discarded, 2nd argument will change the displayed name of the card in your inventory. if you pass true to the 3rd argument you will not be able to erase, or rewrite data, the 3rd argument will set the color of the card, use OC's sides api.", direct=true)
    public Object[] write(Context context, Arguments args) {
        String data = args.checkString(0);
        String title = args.optString(1, "");
        Boolean locked = args.optBoolean(2, false);
        int colorIn = args.optInteger(3, 0);
        int color = Integer.parseInt("FFFFFF", 16);
        if (colorIn >= 0 && colorIn <= 15) {
            switch (colorIn) {
                case 0: {
                    color = Integer.parseInt("FFFFFF", 16);
                    break;
                }
                case 1: {
                    color = Integer.parseInt("FFA500", 16);
                    break;
                }
                case 2: {
                    color = Integer.parseInt("FF00FF", 16);
                    break;
                }
                case 3: {
                    color = Integer.parseInt("ADD8E6", 16);
                    break;
                }
                case 4: {
                    color = Integer.parseInt("FFFF00", 16);
                    break;
                }
                case 5: {
                    color = Integer.parseInt("00FF00", 16);
                    break;
                }
                case 6: {
                    color = Integer.parseInt("FFC0CB", 16);
                    break;
                }
                case 7: {
                    color = Integer.parseInt("808080", 16);
                    break;
                }
                case 8: {
                    color = Integer.parseInt("C0C0C0", 16);
                    break;
                }
                case 9: {
                    color = Integer.parseInt("00FFFF", 16);
                    break;
                }
                case 10: {
                    color = Integer.parseInt("800080", 16);
                    break;
                }
                case 11: {
                    color = Integer.parseInt("0000FF", 16);
                    break;
                }
                case 12: {
                    color = Integer.parseInt("A52A2A", 16);
                    break;
                }
                case 13: {
                    color = Integer.parseInt("008000", 16);
                    break;
                }
                case 14: {
                    color = Integer.parseInt("FF0000", 16);
                    break;
                }
                case 15: {
                    color = Integer.parseInt("000000", 16);
                    break;
                }
                default: {
                    color = Integer.parseInt("FFFFFF", 16);
                }
            }
        }
        if (this.node.changeBuffer(-5.0) == 0.0) {
            if (data != null) {
                if (this.func_70301_a(0) != null) {
                    for (int x = 3; x <= 12; ++x) {
                        if (this.func_70301_a(x) != null) continue;
                        if (this.func_70301_a(0).func_77973_b() instanceof ItemRFIDCard) {
                            this.CardWriterItemStacks[x] = new ItemStack(ContentRegistry.rfidCardItem);
                            if (data.length() > 64) {
                                data = data.substring(0, 64);
                            }
                        } else if (this.func_70301_a(0).func_77973_b() instanceof ItemMagCard) {
                            this.CardWriterItemStacks[x] = new ItemStack(ContentRegistry.magCardItem);
                            if (data.length() > 128) {
                                data = data.substring(0, 128);
                            }
                        }
                        this.CardWriterItemStacks[x].func_77982_d(new NBTTagCompound());
                        this.CardWriterItemStacks[x].field_77990_d.func_74778_a("data", data);
                        if (!title.isEmpty()) {
                            this.CardWriterItemStacks[x].func_151001_c(title);
                        }
                        if (this.CardWriterItemStacks[x].field_77990_d.func_74779_i("uuid").isEmpty()) {
                            this.CardWriterItemStacks[x].field_77990_d.func_74778_a("uuid", UUID.randomUUID().toString());
                        }
                        if (locked.booleanValue()) {
                            this.CardWriterItemStacks[x].field_77990_d.func_74757_a("locked", locked.booleanValue());
                        }
                        this.CardWriterItemStacks[x].field_77990_d.func_74768_a("color", color);
                        this.func_70298_a(0, 1);
                        return new Object[]{true, this.CardWriterItemStacks[x].field_77990_d.func_74779_i("uuid")};
                    }
                    return new Object[]{false, "No Empty Slots"};
                }
                return new Object[]{false, "No card in slot"};
            }
            return new Object[]{false, "Data is Null"};
        }
        return new Object[]{false, "Not enough power in OC Network."};
    }

    public void onMessage(Message arg0) {
    }
}

