/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.network;

import ca.wescook.nutrition.data.NutrientManager;
import ca.wescook.nutrition.data.PlayerDataHandler;
import ca.wescook.nutrition.gui.ModGuiHandler;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.proxy.ClientProxy;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class PacketNutritionResponse {

    public static class Handler
    implements IMessageHandler<Message, IMessage> {
        public IMessage onMessage(Message message, MessageContext context) {
            if (ClientProxy.localNutrition != null) {
                ClientProxy.localNutrition.set(message.clientNutrients);
            } else {
                ClientProxy.localNutrition = new NutrientManager(message.clientNutrients);
            }
            GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
            if (currentScreen != null && currentScreen.equals((Object)ModGuiHandler.nutritionGui)) {
                ModGuiHandler.nutritionGui.redrawLabels();
            }
            return null;
        }
    }

    public static class Message
    implements IMessage {
        EntityPlayer serverPlayer;
        Map<Nutrient, Float> clientNutrients;

        public Message() {
        }

        public Message(EntityPlayer player) {
            this.serverPlayer = player;
        }

        public void toBytes(ByteBuf buf) {
            Map<Nutrient, Float> nutrientData = PlayerDataHandler.getForPlayer(this.serverPlayer).get();
            for (Map.Entry<Nutrient, Float> entry : nutrientData.entrySet()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey().name);
                buf.writeFloat(entry.getValue().floatValue());
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.clientNutrients = new HashMap<Nutrient, Float>();
            while (buf.isReadable()) {
                String identifier = ByteBufUtils.readUTF8String((ByteBuf)buf);
                Float value = Float.valueOf(buf.readFloat());
                this.clientNutrients.put(NutrientList.getByName(identifier), value);
            }
        }
    }
}

