/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.network;

import ca.wescook.nutrition.data.NutrientManager;
import ca.wescook.nutrition.data.PlayerDataHandler;
import ca.wescook.nutrition.network.Sync;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketNormalizeServerNutrients {

    public static class Handler
    implements IMessageHandler<Message, IMessage> {
        public IMessage onMessage(Message message, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            NutrientManager manager = PlayerDataHandler.getForPlayer((EntityPlayer)player);
            boolean wasChanged = false;
            for (Nutrient nutrient : NutrientList.get()) {
                Float currentValue = manager.get(nutrient);
                if (currentValue.floatValue() > 50.0f) {
                    wasChanged = true;
                    manager.set(nutrient, Float.valueOf(Math.max(50.0f, currentValue.floatValue() - message.nutrientDelta)));
                    continue;
                }
                if (!(currentValue.floatValue() < 50.0f)) continue;
                wasChanged = true;
                manager.set(nutrient, Float.valueOf(Math.min(50.0f, currentValue.floatValue() + message.nutrientDelta)));
            }
            if (wasChanged) {
                Sync.serverRequest((EntityPlayer)player);
            }
            return null;
        }
    }

    public static class Message
    implements IMessage {
        float nutrientDelta;

        public Message() {
        }

        public Message(float statsChange) {
            this.nutrientDelta = statsChange;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeFloat(this.nutrientDelta);
        }

        public void fromBytes(ByteBuf buf) {
            this.nutrientDelta = buf.readFloat();
        }
    }
}

