/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodValues;

public class EventTooltip {
    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.itemStack;
        String tooltip = null;
        if (!AppleCoreAPI.accessor.isFood(itemStack)) {
            return;
        }
        StringJoiner stringJoiner = new StringJoiner(", ");
        List<Nutrient> foundNutrients = NutrientUtils.getFoodNutrients(itemStack);
        for (Nutrient nutrient : foundNutrients) {
            if (!nutrient.visible) continue;
            stringJoiner.add(I18n.func_135052_a((String)("nutrient.nutrition:" + nutrient.name), (Object[])new Object[0]));
        }
        String nutrientString = stringJoiner.toString();
        FoodValues foodValues = AppleCoreAPI.accessor.getFoodValuesForPlayer(itemStack, event.entityPlayer);
        float nutritionValue = NutrientUtils.calculateNutrition(foodValues, foundNutrients);
        if (!nutrientString.equals("")) {
            tooltip = I18n.func_135052_a((String)"tooltip.nutrition:nutrients", (Object[])new Object[0]) + " " + EnumChatFormatting.DARK_GREEN + nutrientString + EnumChatFormatting.DARK_AQUA + " (" + String.format("%.1f", Float.valueOf(nutritionValue)) + "%)";
        }
        if (tooltip != null) {
            event.toolTip.add(tooltip);
        }
    }
}

