/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collection;
import magicbees.bees.BeeManager;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HiveDrop
implements IHiveDrop {
    private IAllele[] template;
    private int chance;
    private ItemStack[] bonus;
    private float ignoblePercent = 0.0f;

    public HiveDrop(IAllele[] beeTemplate, ItemStack[] bonusDrops, int dropChance) {
        this.template = beeTemplate;
        this.bonus = bonusDrops;
        this.chance = dropChance;
    }

    public HiveDrop setIgnoblePercentage(float f) {
        this.ignoblePercent = f;
        return this;
    }

    private IBee getBee(World w) {
        IBee bee = BeeManager.beeRoot.getBee(w, BeeManager.beeRoot.templateAsGenome(this.template));
        if (w.field_73012_v.nextFloat() < this.ignoblePercent) {
            bee.setIsNatural(false);
        }
        return bee;
    }

    public ItemStack getPrincess(World world, int x, int y, int z, int fortune) {
        return BeeManager.beeRoot.getMemberStack((IIndividual)this.getBee(world), EnumBeeType.PRINCESS.ordinal());
    }

    public Collection<ItemStack> getDrones(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> value = new ArrayList<ItemStack>(1);
        value.add(BeeManager.beeRoot.getMemberStack((IIndividual)this.getBee(world), EnumBeeType.DRONE.ordinal()));
        return value;
    }

    public Collection<ItemStack> getAdditional(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> value = new ArrayList<ItemStack>(this.bonus.length);
        for (int i = 0; i < this.bonus.length; ++i) {
            value.add(this.bonus[i].func_77946_l());
        }
        return value;
    }

    public int getChance(World world, int x, int y, int z) {
        return this.chance;
    }
}

