/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper;

import net.minecraft.nbt.NBTTagByte;
import ru.timeconqueror.lootgames.utils.future.ICodec;

public enum Type {
    BOMB(-1),
    EMPTY(0),
    ONE(1),
    TWO(2),
    THREE(3),
    FOUR(4),
    FIVE(5),
    SIX(6),
    SEVEN(7),
    EIGHT(8);

    private static final Type[] LOOKUP;
    public static final ICodec<Type, NBTTagByte> CODEC;
    private final byte id;

    private Type(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    static Type byId(byte id) {
        if (id + 1 >= LOOKUP.length) {
            throw new IllegalArgumentException("Provided unknown id: " + id);
        }
        return LOOKUP[id + 1];
    }

    static {
        CODEC = new Codec();
        LOOKUP = new Type[Type.values().length];
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type value;
            Type.LOOKUP[value.id + 1] = value = typeArray[i];
        }
    }

    public static class Codec
    implements ICodec<Type, NBTTagByte> {
        @Override
        public NBTTagByte encode(Type obj) {
            return new NBTTagByte(obj.getId());
        }

        @Override
        public Type decode(NBTTagByte nbtTagInt) {
            return Type.byId(nbtTagInt.func_150290_f());
        }
    }
}

