/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.helper.impl;

import com.google.common.base.Strings;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.McoServer;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import journeymap.client.data.DataCache;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IColorHelper;
import journeymap.client.forge.helper.IForgeHelper;
import journeymap.client.forge.helper.IRenderHelper;
import journeymap.client.forge.helper.impl.ColorHelper_1_7_10;
import journeymap.client.forge.helper.impl.RenderHelper_1_7_10;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class ForgeHelper_1_7_10
implements IForgeHelper {
    private IRenderHelper renderHelper = new RenderHelper_1_7_10();
    private IBlockAccess blockAccess = new JmBlockAccess();
    private static Minecraft mc = Minecraft.func_71410_x();

    @Override
    public IRenderHelper getRenderHelper() {
        return this.renderHelper;
    }

    @Override
    public IBlockAccess getIBlockAccess() {
        return this.blockAccess;
    }

    @Override
    public IColorHelper getColorHelper() {
        return new ColorHelper_1_7_10();
    }

    @Override
    public Minecraft getClient() {
        return FMLClientHandler.instance().getClient();
    }

    @Override
    public ScaledResolution getScaledResolution() {
        Minecraft mc = this.getClient();
        return new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
    }

    @Override
    public EnumSkyBlock getSkyBlock() {
        return EnumSkyBlock.Block;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.getClient().field_71466_p;
    }

    @Override
    public int getPlayerDimension() {
        return this.getClient().field_71439_g.field_70170_p.field_73011_w.field_76574_g;
    }

    @Override
    public boolean hasNoSky(World world) {
        return world.field_73011_w.field_76576_e;
    }

    @Override
    public World getWorld() {
        return this.getClient().field_71441_e;
    }

    @Override
    public World getWorld(Chunk chunk) {
        return chunk.field_76637_e;
    }

    @Override
    public int getLightOpacity(BlockMD blockMD, int x, int y, int z) {
        return blockMD.getBlock().getLightOpacity(this.blockAccess, x & 0xF, y, z & 0xF);
    }

    @Override
    public int getDimension(World world) {
        return world.field_73011_w.field_76574_g;
    }

    @Override
    public int getDimension(WorldProvider worldProvider) {
        return worldProvider.field_76574_g;
    }

    @Override
    public int getSavedLightValue(Chunk chunk, int localX, int y, int localZ) {
        try {
            return chunk.func_76614_a(this.getSkyBlock(), localX & 0xF, y, localZ & 0xF);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    @Override
    public RenderManager getRenderManager() {
        return RenderManager.field_78727_a;
    }

    @Override
    public String getEntityName(Entity entity) {
        return entity.func_70005_c_();
    }

    @Override
    public boolean hasCustomName(Entity entity) {
        return ((EntityLiving)entity).func_94056_bM();
    }

    @Override
    public AxisAlignedBB getBoundingBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        return AxisAlignedBB.func_72330_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Override
    public AxisAlignedBB getBoundingBox(EntityPlayer player, double lateralDistance, double verticalDistance) {
        return AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72314_b(lateralDistance, verticalDistance, lateralDistance);
    }

    @Override
    public Vec3 newVec3(double x, double y, double z) {
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    @Override
    public AxisAlignedBB getEntityBoundingBox(EntityLivingBase entity) {
        return entity.field_70121_D;
    }

    @Override
    public String getRealmsServerName() {
        Minecraft mc;
        String serverName;
        block10: {
            serverName = null;
            mc = ForgeHelper.INSTANCE.getClient();
            if (!mc.func_71356_B()) {
                try {
                    RealmsScreen realmsScreen;
                    NetHandlerPlayClient netHandler = mc.func_147114_u();
                    GuiScreen netHandlerGui = (GuiScreen)ReflectionHelper.getPrivateValue(NetHandlerPlayClient.class, (Object)netHandler, (String[])new String[]{"field_147307_j", "guiScreenServer"});
                    if (!(netHandlerGui instanceof GuiScreenRealmsProxy) || !((realmsScreen = ((GuiScreenRealmsProxy)netHandlerGui).func_154321_a()) instanceof RealmsMainScreen)) break block10;
                    RealmsMainScreen mainScreen = (RealmsMainScreen)realmsScreen;
                    long selectedServerId = (Long)ReflectionHelper.getPrivateValue(RealmsMainScreen.class, (Object)mainScreen, (String[])new String[]{"selectedServerId"});
                    List mcoServers = (List)ReflectionHelper.getPrivateValue(RealmsMainScreen.class, (Object)mainScreen, (String[])new String[]{"mcoServers"});
                    for (McoServer mcoServer : mcoServers) {
                        if (mcoServer.id != selectedServerId) continue;
                        serverName = mcoServer.name;
                        break;
                    }
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Unable to get Realms server name: " + LogFormatter.toString(t));
                }
            }
        }
        if (serverName != null) {
            return serverName;
        }
        ServerData serverData = mc.func_147104_D();
        if (serverData != null && (serverName = serverData.field_78847_a) != null) {
            if (Strings.isNullOrEmpty((String)(serverName = serverName.replaceAll("\\W+", "~").trim()).replaceAll("~", ""))) {
                serverName = serverData.field_78845_b;
            }
            return serverName;
        }
        if (serverName != null) {
            return serverName;
        }
        mc = ForgeHelper.INSTANCE.getClient();
        serverData = mc.func_147104_D();
        if (serverData != null && (serverName = serverData.field_78847_a) != null) {
            if (Strings.isNullOrEmpty((String)(serverName = serverName.replaceAll("\\W+", "~").trim()).replaceAll("~", ""))) {
                serverName = serverData.field_78845_b;
            }
            return serverName;
        }
        return null;
    }

    @Override
    public Vec3 getEntityPositionVector(Entity entity) {
        return Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
    }

    @Override
    public Tessellator getTessellator() {
        return Tessellator.field_78398_a;
    }

    @Override
    public boolean canBlockSeeTheSky(Chunk chunk, int x, int y, int z) {
        return chunk.func_76619_d(x, y, z);
    }

    @Override
    public int getHeight(Chunk chunk, int x, int z) {
        return chunk.func_76611_b(x, z);
    }

    @Override
    public int getPrecipitationHeight(Chunk chunk, int x, int z) {
        return chunk.func_76626_d(x, z);
    }

    @Override
    public int getLightOpacity(Chunk chunk, Block block, int localX, int y, int localZ) {
        return block.getLightOpacity((IBlockAccess)chunk.field_76637_e, (chunk.field_76635_g << 4) + localX, y, (chunk.field_76647_h << 4) + localZ);
    }

    @Override
    public TileEntity getTileEntity(int localX, int y, int localZ) {
        return this.blockAccess.func_147438_o(localX, y, localZ);
    }

    @Override
    public String getBlockName(Block block, int meta) {
        ItemStack stack;
        String displayName;
        Item item = Item.func_150898_a((Block)block);
        if (item == null) {
            item = block.func_149650_a(0, new Random(), 0);
        }
        if (item != null && !Strings.isNullOrEmpty((String)(displayName = (stack = new ItemStack(item, 1, block.func_149692_a(meta))).func_82833_r()))) {
            return displayName;
        }
        return null;
    }

    @Override
    public BiomeGenBase getBiome(ChunkMD chunkMD, int x, int y, int z) {
        try {
            return ForgeHelper_1_7_10.mc.field_71441_e.func_72807_a(x, z);
        }
        catch (Throwable throwable) {
            Journeymap.getLogger().error("Error in getBiome(): " + throwable);
            return ForgeHelper.INSTANCE.getWorld().func_72807_a(x, z);
        }
    }

    @Override
    public BiomeGenBase getBiome(int x, int y, int z) {
        ChunkMD chunkMD = DataCache.instance().getChunkMD(new ChunkCoordIntPair(x >> 4, z >> 4));
        return this.getBiome(chunkMD, x, y, z);
    }

    @Override
    public int getBlockMeta(Chunk chunk, int x, int y, int z) {
        return chunk.func_76628_c(x, y, z);
    }

    @Override
    public boolean hasNoSky(Entity entity) {
        return this.hasNoSky(entity.field_70170_p);
    }

    @Override
    public boolean hasChunkData(Chunk chunk) {
        return chunk.field_76636_d && !chunk.func_76621_g();
    }

    @Override
    public Iterator<Block> getRegisteredBlocks() {
        return GameData.getBlockRegistry().iterator();
    }

    @Override
    public SocketAddress getSocketAddress(NetworkManager netManager) {
        return netManager.func_74430_c();
    }

    @Override
    public String getFPS() {
        int idx;
        String fps = Minecraft.func_71410_x().field_71426_K;
        int n = idx = fps != null ? fps.indexOf(44) : -1;
        if (idx > 0) {
            return fps.substring(0, idx);
        }
        return "";
    }

    class JmBlockAccess
    implements IBlockAccess {
        JmBlockAccess() {
        }

        private Chunk getChunk(int x, int z) {
            ChunkMD chunkMD = DataCache.instance().getChunkMD(new ChunkCoordIntPair(x >> 4, z >> 4));
            if (chunkMD != null && chunkMD.hasChunk()) {
                return chunkMD.getChunk();
            }
            return null;
        }

        public Block func_147439_a(int x, int y, int z) {
            Chunk chunk;
            if (x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000 && y >= 0 && y < 256 && (chunk = this.getChunk(x, z)) != null) {
                return chunk.func_150810_a(x & 0xF, y, z & 0xF);
            }
            return Blocks.field_150350_a;
        }

        public TileEntity func_147438_o(int x, int y, int z) {
            return ForgeHelper.INSTANCE.getWorld().func_147438_o(x, y, z);
        }

        public int func_72802_i(int x, int y, int z, int min) {
            return ForgeHelper.INSTANCE.getWorld().func_72802_i(x, y, z, min);
        }

        public int func_72805_g(int x, int y, int z) {
            Chunk chunk;
            if (x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000 && y >= 0 && y < 256 && (chunk = this.getChunk(x, z)) != null) {
                return chunk.func_76628_c(x &= 0xF, y, z &= 0xF);
            }
            return 0;
        }

        public int func_72879_k(int x, int y, int z, int directionIn) {
            return ForgeHelper.INSTANCE.getWorld().func_72879_k(x, y, z, directionIn);
        }

        public boolean func_147437_c(int x, int y, int z) {
            Block block = this.func_147439_a(x, y, z);
            return block.isAir((IBlockAccess)this, x, y, z);
        }

        public BiomeGenBase func_72807_a(int x, int z) {
            try {
                return mc.field_71441_e.func_72807_a(x, z);
            }
            catch (Throwable throwable) {
                Journeymap.getLogger().error("Error in getBiomeGenForCoords(): " + throwable);
                return ForgeHelper.INSTANCE.getWorld().func_72807_a(x, z);
            }
        }

        public int func_72800_K() {
            return ForgeHelper.INSTANCE.getWorld().func_72800_K();
        }

        public boolean func_72806_N() {
            return ForgeHelper.INSTANCE.getWorld().func_72806_N();
        }

        public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
            if (x < -30000000 || z < -30000000 || x >= 30000000 || z >= 30000000) {
                return _default;
            }
            Chunk chunk = this.getChunk(x >> 4, z >> 4);
            if (chunk == null || chunk.func_76621_g()) {
                return _default;
            }
            return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
        }
    }
}

