/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei.dumper;

import codechicken.nei.config.DataDumper;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.ControllerWithOptionalFeatures;
import java.util.ArrayList;
import java.util.function.Function;

public abstract class MultiBlockFeatureSupportDumper
extends DataDumper {
    private final Function<ControllerWithOptionalFeatures, Boolean> isFeatureSupported;

    public MultiBlockFeatureSupportDumper(String name, Function<ControllerWithOptionalFeatures, Boolean> isFeatureSupported) {
        super("tools.dump.gt5u." + name);
        this.isFeatureSupported = isFeatureSupported;
    }

    public String[] header() {
        return new String[]{"className"};
    }

    public Iterable<String[]> dump(int mode) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 1; i < GregTech_API.METATILEENTITIES.length; ++i) {
            ControllerWithOptionalFeatures controller;
            IMetaTileEntity mte = GregTech_API.METATILEENTITIES[i];
            if (!(mte instanceof ControllerWithOptionalFeatures) || this.isFeatureSupported.apply(controller = (ControllerWithOptionalFeatures)((Object)mte)).booleanValue()) continue;
            list.add(new String[]{controller.getClass().getName()});
        }
        return list;
    }

    public int modeCount() {
        return 1;
    }
}

