/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei.dumper;

import codechicken.nei.NEIClientUtils;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.nei.dumper.GregTechIDDumper;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class MetaItemDumper
extends GregTechIDDumper {
    private final GT_MetaGenerated_Item item;
    private final String nameSuffix;

    public MetaItemDumper(GT_MetaGenerated_Item item, String name) {
        super(name);
        this.nameSuffix = name;
        this.item = item;
    }

    public String[] header() {
        return new String[]{"id", "stackName", "metaID"};
    }

    @Override
    protected Iterable<String[]> dump(GregTechIDDumper.Mode mode) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; i < this.item.mItemAmount; ++i) {
            int metaID = this.item.mOffset + i;
            boolean generated = this.item.mEnabledItems.get(i);
            if (mode == GregTechIDDumper.Mode.FREE && !generated) {
                list.add(new String[]{String.valueOf(i), "", String.valueOf(metaID)});
                continue;
            }
            if (mode != GregTechIDDumper.Mode.USED || !generated) continue;
            list.add(new String[]{String.valueOf(i), new ItemStack((Item)this.item, 1, metaID).func_82833_r(), String.valueOf(metaID)});
        }
        return list;
    }

    @Override
    public void dumpFile() {
        super.super$dumpFile();
        NEIClientUtils.printChatMessage((IChatComponent)new ChatComponentText(String.format("mOffset: %s, mItemAmount: %s", this.item.mOffset, this.item.mItemAmount)));
        this.logWarn();
    }

    public String translateN(String s, Object ... args) {
        if (this.name.equals(s) || (this.name + "s").equals(s)) {
            return this.nameSuffix;
        }
        return super.translateN(s, args);
    }
}

