/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.long_distance;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_Block_LongDistancePipe;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicHull_NonElectric;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_LongDistancePipelineBase
extends GT_MetaTileEntity_BasicHull_NonElectric {
    protected static final int INPUT_INDEX = 0;
    protected static final int OUTPUT_INDEX = 1;
    protected static final int SIDE_UP_DOWN_INDEX = 2;
    protected static final int SIDE_LEFT_RIGHT_INDEX = 3;
    public static int minimalDistancePoints = 64;
    protected GT_MetaTileEntity_LongDistancePipelineBase mTarget = null;
    protected volatile GT_MetaTileEntity_LongDistancePipelineBase mSender = null;
    protected volatile ChunkCoordinates mTargetPos = null;
    protected GT_MetaTileEntity_LongDistancePipelineBase mTooCloseTarget = null;
    protected GT_MetaTileEntity_LongDistancePipelineBase mTooCloseSender = null;

    public GT_MetaTileEntity_LongDistancePipelineBase(int aID, String aName, String aNameRegional, int aTier, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aDescription);
    }

    public GT_MetaTileEntity_LongDistancePipelineBase(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Only one Input and Output are allowed per pipeline", "Only Input and Output have to be chunkloaded", "Transfer rate is solely limited by input rate", "Minimum distance: " + minimalDistancePoints + " blocks"};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mTargetPos != null && this.mTarget != this) {
            aNBT.func_74757_a("target", true);
            aNBT.func_74768_a("target.x", this.mTargetPos.field_71574_a);
            aNBT.func_74768_a("target.y", this.mTargetPos.field_71572_b);
            aNBT.func_74768_a("target.z", this.mTargetPos.field_71573_c);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("target")) {
            this.mTargetPos = new ChunkCoordinates(aNBT.func_74762_e("target.x"), aNBT.func_74762_e("target.y"), aNBT.func_74762_e("target.z"));
            if (this.getDistanceToSelf(this.mTargetPos) < minimalDistancePoints) {
                this.mTargetPos = null;
            }
        }
    }

    public boolean isSameClass(GT_MetaTileEntity_LongDistancePipelineBase other) {
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
        if (tCurrentItem != null && GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList)) {
            this.scanPipes();
            return true;
        }
        return false;
    }

    public boolean isDead() {
        return this.getBaseMetaTileEntity() == null || this.getBaseMetaTileEntity().isDead();
    }

    public boolean checkTarget() {
        IGregTechTileEntity gt_tile = this.getBaseMetaTileEntity();
        if (gt_tile == null || !gt_tile.isAllowedToWork() || gt_tile.isClientSide()) {
            return false;
        }
        World world = gt_tile.getWorld();
        if (world == null) {
            return false;
        }
        if (this.mTargetPos == null) {
            this.scanPipes();
        } else if (this.mTarget == null || this.mTarget.isDead()) {
            this.mTarget = null;
            if (world.func_72899_e(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c)) {
                IMetaTileEntity tMeta;
                TileEntity te = world.func_147438_o(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c);
                if (te instanceof BaseMetaTileEntity && (tMeta = ((BaseMetaTileEntity)te).getMetaTileEntity()) instanceof GT_MetaTileEntity_LongDistancePipelineBase && this.isSameClass((GT_MetaTileEntity_LongDistancePipelineBase)tMeta)) {
                    this.mTarget = (GT_MetaTileEntity_LongDistancePipelineBase)tMeta;
                } else if (te != null) {
                    this.mTargetPos = null;
                }
            }
        }
        if (this.mTooCloseTarget != null && this.mTooCloseTarget.mSender == null) {
            this.mTooCloseTarget.mTooCloseSender = this;
        }
        if (this.mTooCloseSender != null && (this.mTooCloseSender.isDead() || this.mTooCloseSender.mTarget != null)) {
            this.mTooCloseSender = null;
        }
        if (this.mTarget == null || this.mTarget == this) {
            return false;
        }
        if (this.mTarget.mSender == null || this.mTarget.mSender.isDead() || this.mTarget.mSender.mTarget == null || this.mTarget.mSender.mTarget.isDead()) {
            this.mTarget.mSender = this;
            this.mTarget.mTooCloseSender = null;
        }
        return this.mTarget.mSender == this;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        if (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this) {
            ChunkCoordinates coords = this.mSender.getCoords();
            aList.addAll(Arrays.asList("Is Pipeline Output", "Pipeline Input is at: X: " + coords.field_71574_a + " Y: " + coords.field_71572_b + " Z: " + coords.field_71573_c));
        } else {
            aList.addAll(Arrays.asList(this.checkTarget() ? "Is connected to Pipeline Output" : "Pipeline Output is not connected/chunkloaded", "Pipeline Output should be around: X: " + this.mTargetPos.field_71574_a + " Y: " + this.mTargetPos.field_71572_b + " Z: " + this.mTargetPos.field_71573_c));
        }
        return aList;
    }

    public abstract int getPipeMeta();

    protected void scanPipes() {
        if (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this) {
            return;
        }
        IGregTechTileEntity gtTile = this.getBaseMetaTileEntity();
        if (gtTile == null) {
            return;
        }
        World world = gtTile.getWorld();
        if (world == null) {
            return;
        }
        this.mTargetPos = this.getCoords();
        this.mTarget = this;
        this.mSender = null;
        Block aBlock = gtTile.getBlockAtSide(gtTile.getBackFacing());
        if (aBlock instanceof GT_Block_LongDistancePipe) {
            byte aMetaData = gtTile.getMetaIDAtSide(gtTile.getBackFacing());
            if (aMetaData != this.getPipeMeta()) {
                return;
            }
            HashSet<ChunkCoordinates> tVisited = new HashSet<ChunkCoordinates>(Collections.singletonList(this.getCoords()));
            HashSet<ChunkCoordinates> tWires = new HashSet<ChunkCoordinates>();
            LinkedList<ChunkCoordinates> tQueue = new LinkedList<ChunkCoordinates>(Collections.singletonList(this.getFacingOffset(gtTile, gtTile.getBackFacing())));
            while (!tQueue.isEmpty()) {
                IMetaTileEntity iMetaTileEntity;
                ChunkCoordinates aCoords = (ChunkCoordinates)tQueue.poll();
                if (world.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) == aBlock && world.func_72805_g(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) == aMetaData) {
                    tWires.add(aCoords);
                    ChunkCoordinates tCoords = new ChunkCoordinates(aCoords.field_71574_a + 1, aCoords.field_71572_b, aCoords.field_71573_c);
                    if (tVisited.add(tCoords)) {
                        tQueue.add(tCoords);
                    }
                    if (tVisited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a - 1, aCoords.field_71572_b, aCoords.field_71573_c))) {
                        tQueue.add(tCoords);
                    }
                    if (tVisited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b + 1, aCoords.field_71573_c))) {
                        tQueue.add(tCoords);
                    }
                    if (tVisited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b - 1, aCoords.field_71573_c))) {
                        tQueue.add(tCoords);
                    }
                    if (tVisited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c + 1))) {
                        tQueue.add(tCoords);
                    }
                    if (!tVisited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c - 1))) continue;
                    tQueue.add(tCoords);
                    continue;
                }
                TileEntity tTileEntity = world.func_147438_o(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
                if (tTileEntity == gtTile || !(tTileEntity instanceof BaseMetaTileEntity) || !((iMetaTileEntity = ((BaseMetaTileEntity)tTileEntity).getMetaTileEntity()) instanceof GT_MetaTileEntity_LongDistancePipelineBase)) continue;
                GT_MetaTileEntity_LongDistancePipelineBase tGtTile = (GT_MetaTileEntity_LongDistancePipelineBase)iMetaTileEntity;
                if (this.isSameClass(tGtTile) && tWires.contains(tGtTile.getFacingOffset((BaseMetaTileEntity)tTileEntity, ((BaseMetaTileEntity)tTileEntity).getFrontFacing()))) {
                    int distance = this.getDistanceToSelf(aCoords);
                    if (distance > minimalDistancePoints) {
                        this.mTarget = tGtTile;
                        this.mTargetPos = tGtTile.getCoords();
                        this.mTooCloseTarget = null;
                        return;
                    }
                    if (this.mTooCloseTarget == null) {
                        this.mTooCloseTarget = tGtTile;
                    }
                }
                tVisited.remove(aCoords);
            }
        }
    }

    protected int getDistanceToSelf(ChunkCoordinates aCoords) {
        return Math.abs(this.getBaseMetaTileEntity().getXCoord() - aCoords.field_71574_a) + Math.abs(this.getBaseMetaTileEntity().getYCoord() - aCoords.field_71572_b) / 2 + Math.abs(this.getBaseMetaTileEntity().getZCoord() - aCoords.field_71573_c);
    }

    public ChunkCoordinates getFacingOffset(IGregTechTileEntity gt_tile, ForgeDirection side) {
        return new ChunkCoordinates(gt_tile.getOffsetX(side, 1), (int)gt_tile.getOffsetY(side, 1), gt_tile.getOffsetZ(side, 1));
    }

    public ChunkCoordinates getCoords() {
        IGregTechTileEntity gt_tile = this.getBaseMetaTileEntity();
        return new ChunkCoordinates(gt_tile.getXCoord(), (int)gt_tile.getYCoord(), gt_tile.getZCoord());
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mTargetPos = null;
        this.mSender = null;
    }

    @Override
    public boolean shouldTriggerBlockUpdate() {
        return true;
    }

    public abstract ITexture[] getTextureOverlays();

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[4][17][];
        ITexture[] overlays = this.getTextureOverlays();
        for (int i = 0; i < rTextures[0].length; ++i) {
            rTextures[0][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], overlays[0]};
            rTextures[1][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], overlays[1]};
            rTextures[2][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], overlays[2]};
            rTextures[3][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], overlays[3]};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        ++colorIndex;
        if (sideDirection == facingDirection) {
            return this.mTextures[0][colorIndex];
        }
        if (sideDirection == facingDirection.getOpposite()) {
            return this.mTextures[1][colorIndex];
        }
        switch (facingDirection) {
            case DOWN: 
            case UP: {
                return this.mTextures[2][colorIndex];
            }
            case NORTH: {
                switch (sideDirection) {
                    case DOWN: 
                    case UP: {
                        return this.mTextures[2][colorIndex];
                    }
                    case EAST: 
                    case WEST: {
                        return this.mTextures[3][colorIndex];
                    }
                }
                break;
            }
            case SOUTH: {
                switch (sideDirection) {
                    case DOWN: 
                    case UP: {
                        return this.mTextures[2][colorIndex];
                    }
                    case EAST: 
                    case WEST: {
                        return this.mTextures[3][colorIndex];
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                return this.mTextures[3][colorIndex];
            }
        }
        return this.mTextures[0][colorIndex];
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        ForgeDirection facing = this.getBaseMetaTileEntity().getFrontFacing();
        ForgeDirection side = accessor.getSide();
        NBTTagCompound tag = accessor.getNBTData();
        boolean hasInput = tag.func_74767_n("hasInput");
        boolean hasInputTooClose = tag.func_74767_n("hasInputTooClose");
        boolean hasOutput = tag.func_74767_n("hasOutput");
        boolean hasOutputTooClose = tag.func_74767_n("hasOutputTooClose");
        if (side == facing) {
            currentTip.add(SpecialChars.GOLD + "Pipeline Input" + SpecialChars.RESET);
        } else if (side == facing.getOpposite()) {
            currentTip.add(SpecialChars.BLUE + "Pipeline Output" + SpecialChars.RESET);
        } else {
            currentTip.add("Pipeline Side");
        }
        if (!(hasInput || hasInputTooClose || hasOutput || hasOutputTooClose)) {
            currentTip.add(SpecialChars.YELLOW + "Not connected" + SpecialChars.RESET);
        }
        if (hasInput) {
            currentTip.add(SpecialChars.GREEN + "Connected to " + SpecialChars.GOLD + "Input" + SpecialChars.RESET);
        } else if (hasInputTooClose) {
            currentTip.add(SpecialChars.RED + "Connected Input too close" + SpecialChars.RESET);
        } else if (hasOutput) {
            currentTip.add(SpecialChars.GREEN + "Connected to " + SpecialChars.BLUE + "Output" + SpecialChars.RESET);
        } else if (hasOutputTooClose) {
            currentTip.add(SpecialChars.RED + "Connected Output too close" + SpecialChars.RESET);
        }
        super.getWailaBody(itemStack, currentTip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("hasInput", this.mSender != null);
        tag.func_74757_a("hasInputTooClose", this.mTooCloseSender != null);
        tag.func_74757_a("hasOutput", this.mTarget != null && this.mTarget != this);
        tag.func_74757_a("hasOutputTooClose", this.mTooCloseTarget != null);
    }
}

