/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.MachineType;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.ItemData;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_AssemblyLineUtils;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import java.util.Objects;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Scanner
extends GT_MetaTileEntity_BasicMachine {
    public GT_MetaTileEntity_Scanner(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, MachineType.SCANNER.tooltipDescription(), 1, 1, "Scanner.png", "", TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_SCANNER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_SCANNER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_SCANNER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_SCANNER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_SCANNER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_SCANNER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_GLOW).glow().build()));
    }

    public GT_MetaTileEntity_Scanner(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_Scanner(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Scanner(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    @Override
    public int checkRecipe() {
        ItemStack aStack = this.getInputAt(0);
        if (this.getOutputAt(0) != null) {
            ++this.mOutputBlocked;
        } else if (GT_Utility.isStackValid(aStack) && aStack.field_77994_a > 0) {
            block52: {
                if (this.getFillableStack() != null && this.getFillableStack().containsFluid(Materials.Honey.getFluid(100L))) {
                    try {
                        IIndividual tIndividual = AlleleManager.alleleRegistry.getIndividual(aStack);
                        if (tIndividual != null) {
                            if (tIndividual.analyze()) {
                                this.getFillableStack().amount -= 100;
                                this.mOutputItems[0] = GT_Utility.copyOrNull(aStack);
                                aStack.field_77994_a = 0;
                                NBTTagCompound tNBT = new NBTTagCompound();
                                tIndividual.writeToNBT(tNBT);
                                this.mOutputItems[0].func_77982_d(tNBT);
                                this.calculateOverclockedNess(2, 500);
                                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                                    return 1;
                                }
                                return 2;
                            }
                            this.mOutputItems[0] = GT_Utility.copyOrNull(aStack);
                            aStack.field_77994_a = 0;
                            this.mMaxProgresstime = 1;
                            this.mEUt = 1;
                            return 2;
                        }
                    }
                    catch (Throwable e) {
                        if (!GT_Values.D1) break block52;
                        e.printStackTrace(GT_Log.err);
                    }
                }
            }
            if (ItemList.IC2_Crop_Seeds.isStackEqual(aStack, true, true)) {
                NBTTagCompound tNBT = aStack.func_77978_p();
                if (tNBT == null) {
                    tNBT = new NBTTagCompound();
                }
                if (tNBT.func_74771_c("scan") < 4) {
                    tNBT.func_74774_a("scan", (byte)4);
                    this.calculateOverclockedNess(8, 160);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                } else {
                    this.mMaxProgresstime = 1;
                    this.mEUt = 1;
                }
                --aStack.field_77994_a;
                this.mOutputItems[0] = GT_Utility.copyAmount(1L, aStack);
                assert (this.mOutputItems[0] != null);
                this.mOutputItems[0].func_77982_d(tNBT);
                return 2;
            }
            if (ItemList.Tool_DataOrb.isStackEqual(this.getSpecialSlot(), false, true)) {
                if (ItemList.Tool_DataOrb.isStackEqual(aStack, false, true)) {
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    this.calculateOverclockedNess(30, 512);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
                ItemData tData = GT_OreDictUnificator.getAssociation(aStack);
                if (!(tData == null || tData.mPrefix != OrePrefixes.dust && tData.mPrefix != OrePrefixes.cell || tData.mMaterial.mMaterial.mElement == null || tData.mMaterial.mMaterial.mElement.mIsIsotope || tData.mMaterial.mMaterial == Materials.Magic || tData.mMaterial.mMaterial.getMass() <= 0L)) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                    Behaviour_DataOrb.setDataTitle(this.mOutputItems[0], "Elemental-Scan");
                    Behaviour_DataOrb.setDataName(this.mOutputItems[0], tData.mMaterial.mMaterial.mElement.name());
                    this.calculateOverclockedNess(30, GT_Utility.safeInt(tData.mMaterial.mMaterial.getMass() * 8192L));
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
            }
            if (ItemList.Tool_DataStick.isStackEqual(this.getSpecialSlot(), false, true)) {
                if (ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    this.calculateOverclockedNess(30, 128);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
                if (aStack.func_77973_b() == Items.field_151164_bB) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    assert (this.mOutputItems[0] != null);
                    this.mOutputItems[0].func_77982_d(aStack.func_77978_p());
                    this.calculateOverclockedNess(30, 128);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
                if (aStack.func_77973_b() == Items.field_151098_aY) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    assert (this.mOutputItems[0] != null);
                    this.mOutputItems[0].func_77982_d(GT_Utility.getNBTContainingShort(new NBTTagCompound(), "map_id", (short)aStack.func_77960_j()));
                    this.calculateOverclockedNess(30, 128);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
                if ((aStack.func_77973_b().func_77658_a().contains("Schematic") || aStack.func_77973_b().func_77658_a().contains("schematic")) && !aStack.func_77973_b().func_77658_a().contains("Schematics")) {
                    if (this.mTier < 3) {
                        return 1;
                    }
                    String sTier = "";
                    int stackItemID = Item.func_150891_b((Item)aStack.func_77973_b());
                    int stackItemDamage = aStack.func_77960_j();
                    if (stackItemID == Item.func_150891_b((Item)Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftCore.ID, "item.schematic", 1L, 0)).func_77973_b())) {
                        if (stackItemDamage == 0 && aStack.toString().equals(Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftCore.ID, "item.schematic", 1L, 0)).func_77946_l().toString())) {
                            sTier = "100";
                        } else if (stackItemDamage == 1 && aStack.toString().equals(Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftCore.ID, "item.schematic", 1L, 1)).func_77946_l().toString())) {
                            sTier = "2";
                        }
                    } else if (stackItemID == Item.func_150891_b((Item)Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftMars.ID, "item.schematic", 1L, 0)).func_77973_b())) {
                        if (stackItemDamage == 0 && aStack.toString().equals(Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftMars.ID, "item.schematic", 1L, 0)).func_77946_l().toString())) {
                            sTier = "3";
                        } else if (stackItemDamage == 1 && aStack.toString().equals(Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftMars.ID, "item.schematic", 1L, 1)).func_77946_l().toString())) {
                            sTier = "101";
                        } else if (stackItemDamage == 2 && aStack.toString().equals(Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftMars.ID, "item.schematic", 1L, 2)).func_77946_l().toString())) {
                            sTier = "102";
                        }
                    } else {
                        sTier = aStack.func_77977_a().matches(".*\\d+.*") ? aStack.func_77977_a().split("(?<=\\D)(?=\\d)")[1].substring(0, 1) : "1";
                    }
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    assert (this.mOutputItems[0] != null);
                    this.mOutputItems[0].func_77982_d(GT_Utility.getNBTContainingShort(new NBTTagCompound(), "rocket_tier", Short.parseShort(sTier)));
                    this.calculateOverclockedNess(480, 36000);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    return 2;
                }
            }
            if (this.getSpecialSlot() == null && ItemList.Tool_DataStick.isStackEqual(aStack, false, true) && GT_Utility.ItemNBT.getBookTitle(aStack).equals("Raw Prospection Data")) {
                GT_Utility.ItemNBT.setBookTitle(aStack, "Analyzed Prospection Data");
                GT_Utility.ItemNBT.convertProspectionData(aStack);
                --aStack.field_77994_a;
                this.mOutputItems[0] = GT_Utility.copyAmount(1L, aStack);
                this.calculateOverclockedNess(30, 1000);
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return 1;
                }
                return 2;
            }
            if (ItemList.Tool_DataStick.isStackEqual(this.getSpecialSlot(), false, true)) {
                for (GT_Recipe.GT_Recipe_AssemblyLine tRecipe : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
                    if (!GT_Utility.areStacksEqual(tRecipe.mResearchItem, aStack, true)) continue;
                    boolean failScanner = true;
                    for (GT_Recipe scannerRecipe : GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.mRecipeList) {
                        if (!GT_Utility.areStacksEqual(scannerRecipe.mInputs[0], aStack, true)) continue;
                        failScanner = false;
                        break;
                    }
                    if (failScanner) {
                        return 1;
                    }
                    this.mOutputItems[0] = GT_Utility.copyAmount(1L, this.getSpecialSlot());
                    if (!GT_AssemblyLineUtils.setAssemblyLineRecipeOnDataStick(this.mOutputItems[0], tRecipe)) continue;
                    --aStack.field_77994_a;
                    this.calculateOverclockedNess(30, tRecipe.mResearchTime);
                    if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                        return 1;
                    }
                    --this.getSpecialSlot().field_77994_a;
                    return 2;
                }
            }
        }
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProgresstime >= this.mMaxProgresstime - 1 && this.mOutputItems[0] != null && this.mOutputItems[0].func_77977_a().equals("gt.metaitem.01.32707")) {
            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "scanning");
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes;
    }

    @Override
    public int getCapacity() {
        return 1000;
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && this.getRecipeList().containsInput(aStack);
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient(SoundResource.IC2_MACHINES_MAGNETIZER_LOOP, 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }
}

