/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class VoidProtectionHelper {
    private IVoidable machine;
    private boolean protectExcessItem;
    private boolean protectExcessFluid;
    private int maxParallel = 1;
    private ItemStack[] itemOutputs;
    private FluidStack[] fluidOutputs;
    private boolean built;

    @Deprecated
    public VoidProtectionHelper setController(GT_MetaTileEntity_MultiBlockBase machineMeta) {
        return this.setMachine(machineMeta, machineMeta.protectsExcessItem(), machineMeta.protectsExcessFluid());
    }

    @Deprecated
    public VoidProtectionHelper setController(GT_MetaTileEntity_MultiBlockBase machineMeta, boolean protectExcessItem, boolean protectExcessFluid) {
        return this.setMachine(machineMeta, protectExcessItem, protectExcessFluid);
    }

    public VoidProtectionHelper setMachine(IVoidable machine) {
        return this.setMachine(machine, machine.protectsExcessItem(), machine.protectsExcessFluid());
    }

    public VoidProtectionHelper setMachine(IVoidable machine, boolean protectExcessItem, boolean protectExcessFluid) {
        this.protectExcessItem = protectExcessItem;
        this.protectExcessFluid = protectExcessFluid;
        this.machine = machine;
        return this;
    }

    public VoidProtectionHelper setItemOutputs(ItemStack[] itemOutputs) {
        this.itemOutputs = itemOutputs;
        return this;
    }

    public VoidProtectionHelper setFluidOutputs(FluidStack[] fluidOutputs) {
        this.fluidOutputs = fluidOutputs;
        return this;
    }

    public VoidProtectionHelper setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
        return this;
    }

    public VoidProtectionHelper build() {
        if (this.built) {
            throw new IllegalStateException("Tried to build twice");
        }
        if (this.machine == null) {
            throw new IllegalStateException("Machine is not set");
        }
        this.built = true;
        this.determineParallel();
        return this;
    }

    public int getMaxParallel() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get parallels before building");
        }
        return this.maxParallel;
    }

    private void determineParallel() {
        if (this.itemOutputs == null) {
            this.itemOutputs = new ItemStack[0];
        }
        if (this.fluidOutputs == null) {
            this.fluidOutputs = new FluidStack[0];
        }
        if (this.protectExcessItem && this.itemOutputs.length > 0 && !this.machine.canDumpItemToME()) {
            this.maxParallel = Math.min(this.calculateMaxItemParallels(), this.maxParallel);
        }
        if (this.protectExcessFluid && this.fluidOutputs.length > 0 && !this.machine.canDumpFluidToME()) {
            this.maxParallel = Math.min(this.calculateMaxFluidParallels(), this.maxParallel);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int calculateMaxFluidParallels() {
        void var6_10;
        List<? extends IFluidStore> hatches = this.machine.getFluidOutputSlots(this.fluidOutputs);
        if (hatches.size() < this.fluidOutputs.length) {
            return 0;
        }
        HashMap<FluidStack, Integer> tFluidOutputMap = new HashMap<FluidStack, Integer>();
        HashMap<FluidStack, ParallelData> tParallels = new HashMap<FluidStack, ParallelData>();
        FluidStack[] fluidStackArray = this.fluidOutputs;
        int n = fluidStackArray.length;
        boolean bl = false;
        while (var6_10 < n) {
            FluidStack aY = fluidStackArray[var6_10];
            if (aY != null && aY.amount > 0) {
                tFluidOutputMap.merge(aY, aY.amount, Integer::sum);
                tParallels.put(aY, new ParallelData(0, 0));
            }
            ++var6_10;
        }
        if (tFluidOutputMap.isEmpty()) {
            return this.maxParallel;
        }
        for (IFluidStore iFluidStore : hatches) {
            int n2 = iFluidStore.getCapacity() - iFluidStore.getFluidAmount();
            if (n2 <= 0 || iFluidStore.isEmptyAndAcceptsAnyFluid()) continue;
            for (Map.Entry entry : tParallels.entrySet()) {
                FluidStack tFluidOutput = (FluidStack)entry.getKey();
                if (!iFluidStore.canStoreFluid(tFluidOutput)) continue;
                ParallelData tParallel = (ParallelData)entry.getValue();
                Integer tCraftSize = (Integer)tFluidOutputMap.get(tFluidOutput);
                tParallel.batch += (tParallel.partial + n2) / tCraftSize;
                tParallel.partial = (tParallel.partial + n2) % tCraftSize;
            }
        }
        PriorityQueue<ParallelStackInfo> aParallelQueue = new PriorityQueue<ParallelStackInfo>(Comparator.comparing(i -> ((ParallelStackInfo)i).batch));
        for (Map.Entry entry : tParallels.entrySet()) {
            aParallelQueue.add(new ParallelStackInfo(((ParallelData)entry.getValue()).batch, ((ParallelData)entry.getValue()).partial, (FluidStack)entry.getKey()));
        }
        for (IFluidStore iFluidStore : hatches) {
            if (!iFluidStore.isEmptyAndAcceptsAnyFluid()) continue;
            ParallelStackInfo tParallel = aParallelQueue.poll();
            assert (tParallel != null);
            Integer n3 = (Integer)tFluidOutputMap.get(tParallel.stack);
            int tSpaceLeft = iFluidStore.getCapacity();
            tParallel.batch += (tParallel.partial + tSpaceLeft) / n3;
            tParallel.partial = (tParallel.partial + tSpaceLeft) % n3;
            aParallelQueue.add(tParallel);
        }
        return ((ParallelStackInfo)aParallelQueue.element()).batch;
    }

    private int calculateMaxItemParallels() {
        List<ItemStack> busStacks = this.machine.getItemOutputSlots(this.itemOutputs);
        ItemStackMap tItemOutputMap = new ItemStackMap();
        ItemStackMap tParallels = new ItemStackMap();
        int tSlotsFree = 0;
        for (ItemStack tItem : this.itemOutputs) {
            if (tItem == null || tItem.field_77994_a <= 0) continue;
            tItemOutputMap.merge(tItem, tItem.field_77994_a, Integer::sum);
            tParallels.put(tItem, new ParallelData(0, 0));
        }
        if (tItemOutputMap.isEmpty()) {
            return this.maxParallel;
        }
        if (this.itemOutputs.length > 0) {
            for (ItemStack tBusStack : busStacks) {
                if (tBusStack == null) {
                    ++tSlotsFree;
                    continue;
                }
                int tMaxBusStackSize = tBusStack.func_77976_d();
                if (tBusStack.field_77994_a >= tMaxBusStackSize) continue;
                int tSpaceLeft = tMaxBusStackSize - tBusStack.field_77994_a;
                Integer tCraftSize = (Integer)tItemOutputMap.get(tBusStack);
                if (tCraftSize == null) continue;
                ParallelData tParallel = (ParallelData)tParallels.get(tBusStack);
                tParallel.batch += (tParallel.partial + tSpaceLeft) / tCraftSize;
                tParallel.partial = (tParallel.partial + tSpaceLeft) % tCraftSize;
            }
            PriorityQueue<ParallelStackInfo> aParallelQueue = new PriorityQueue<ParallelStackInfo>(Comparator.comparing(i -> ((ParallelStackInfo)i).batch));
            for (Map.Entry entry : tParallels.entrySet()) {
                aParallelQueue.add(new ParallelStackInfo(((ParallelData)entry.getValue()).batch, ((ParallelData)entry.getValue()).partial, (ItemStack)entry.getKey()));
            }
            while (tSlotsFree > 0) {
                ParallelStackInfo tParallel = aParallelQueue.poll();
                assert (tParallel != null);
                Integer tCraftSize = (Integer)tItemOutputMap.get(tParallel.stack);
                int tStackSize = ((ItemStack)tParallel.stack).func_77976_d();
                tParallel.batch += (tParallel.partial + tStackSize) / tCraftSize;
                tParallel.partial = (tParallel.partial + tStackSize) % tCraftSize;
                aParallelQueue.add(tParallel);
                --tSlotsFree;
            }
            return ((ParallelStackInfo)aParallelQueue.element()).batch;
        }
        return 0;
    }

    private static class ParallelData {
        private int batch;
        private int partial;

        private ParallelData(int batch, int partial) {
            this.batch = batch;
            this.partial = partial;
        }
    }

    private static class ParallelStackInfo<T> {
        private int batch;
        private int partial;
        private final T stack;

        private ParallelStackInfo(int batch, int partial, T stack) {
            this.batch = batch;
            this.partial = partial;
            this.stack = stack;
        }
    }
}

