/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUIColorOverride;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCoverGUI;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_TooltipDataCache;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_CoverBehaviorBase<T extends ISerializableObject> {
    public EntityPlayer lastPlayer = null;
    private final Class<T> typeToken;
    private final ITexture coverFGTexture;
    protected GT_TooltipDataCache mTooltipCache = new GT_TooltipDataCache();
    protected GT_GUIColorOverride colorOverride;
    private static final String guiTexturePath = "gregtech:textures/gui/GuiCover.png";

    protected GT_CoverBehaviorBase(Class<T> typeToken) {
        this(typeToken, null);
    }

    protected GT_CoverBehaviorBase(Class<T> typeToken, ITexture coverTexture) {
        this.typeToken = typeToken;
        this.coverFGTexture = coverTexture;
        this.reloadColorOverride();
    }

    public void reloadColorOverride() {
        this.colorOverride = GT_GUIColorOverride.get(guiTexturePath);
    }

    public abstract T createDataObject(int var1);

    public abstract T createDataObject();

    public final T createDataObject(NBTBase aNBT) {
        if (aNBT instanceof NBTTagInt) {
            return this.createDataObject(((NBTTagInt)aNBT).func_150287_d());
        }
        T ret = this.createDataObject();
        ret.loadDataFromNBT(aNBT);
        return ret;
    }

    public final T cast(ISerializableObject aData) {
        if (this.typeToken.isInstance(aData)) {
            return this.forceCast(aData);
        }
        return null;
    }

    private T forceCast(ISerializableObject aData) {
        try {
            return (T)((ISerializableObject)this.typeToken.cast(aData));
        }
        catch (Exception e) {
            throw new RuntimeException("Casting data in " + this.getClass() + ", data " + aData, e);
        }
    }

    public final Block getFacadeBlock(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getFacadeBlockImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final int getFacadeMeta(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getFacadeMetaImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ItemStack getDisplayStack(int aCoverID, ISerializableObject aCoverVariable) {
        return this.getDisplayStackImpl(aCoverID, this.forceCast(aCoverVariable));
    }

    public final ITexture getSpecialCoverFGTexture(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverFGTextureImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ITexture getSpecialCoverTexture(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getSpecialCoverTextureImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean isDataNeededOnClient(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.isDataNeededOnClientImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final void onDataChanged(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onDataChangedImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final void preDataChanged(ForgeDirection side, int aCoverID, int aNewCoverId, ISerializableObject aCoverVariable, ISerializableObject aNewCoverVariable, ICoverable aTileEntity) {
        this.preDataChangedImpl(side, aCoverID, aNewCoverId, this.forceCast(aCoverVariable), this.forceCast(aNewCoverVariable), aTileEntity);
    }

    public final void onDropped(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onDroppedImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return this.isRedstoneSensitiveImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aTimer);
    }

    public final T doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return this.doCoverThingsImpl(side, aInputRedstone, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aTimer);
    }

    public final boolean onCoverRightClick(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.onCoverRightClickImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer, aX, aY, aZ);
    }

    public final T onCoverScrewdriverClick(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return this.onCoverScrewdriverClickImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer, aX, aY, aZ);
    }

    public final boolean onCoverShiftRightClick(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer) {
        return this.onCoverShiftRightClickImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer);
    }

    @Deprecated
    public final Object getClientGUI(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return this.getClientGUIImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aPlayer, aWorld);
    }

    public final boolean onCoverRemoval(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        return this.onCoverRemovalImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity, aForced);
    }

    public final void onBaseTEDestroyed(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        this.onBaseTEDestroyedImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final String getDescription(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getDescriptionImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final float getBlastProofLevel(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getBlastProofLevelImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsRedstoneGoIn(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoInImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsRedstoneGoOut(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoOutImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsEnergyIn(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsEnergyInImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsEnergyOut(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.letsEnergyOutImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean letsFluidIn(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.letsFluidInImpl(side, aCoverID, this.forceCast(aCoverVariable), aFluid, aTileEntity);
    }

    public final boolean letsFluidOut(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.letsFluidOutImpl(side, aCoverID, this.forceCast(aCoverVariable), aFluid, aTileEntity);
    }

    public final boolean letsItemsIn(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return this.letsItemsInImpl(side, aCoverID, this.forceCast(aCoverVariable), aSlot, aTileEntity);
    }

    public final boolean letsItemsOut(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return this.letsItemsOutImpl(side, aCoverID, this.forceCast(aCoverVariable), aSlot, aTileEntity);
    }

    public final boolean isGUIClickable(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.isGUIClickableImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean manipulatesSidedRedstoneOutput(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.manipulatesSidedRedstoneOutputImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final boolean alwaysLookConnected(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.alwaysLookConnectedImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final byte getRedstoneInput(ForgeDirection side, byte aInputRedstone, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getRedstoneInputImpl(side, aInputRedstone, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final int getTickRate(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getTickRateImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final byte getLensColor(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getLensColorImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public final ItemStack getDrop(ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return this.getDropImpl(side, aCoverID, this.forceCast(aCoverVariable), aTileEntity);
    }

    public boolean useModularUI() {
        return false;
    }

    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new UIFactory(buildContext).createWindow();
    }

    protected Block getFacadeBlockImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return null;
    }

    protected int getFacadeMetaImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    protected ItemStack getDisplayStackImpl(int aCoverID, T aCoverVariable) {
        return GT_Utility.intToStack(aCoverID);
    }

    protected ITexture getSpecialCoverFGTextureImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return this.coverFGTexture;
    }

    protected ITexture getSpecialCoverTextureImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return null;
    }

    protected boolean isDataNeededOnClientImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected void onDataChangedImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
    }

    protected void preDataChangedImpl(ForgeDirection side, int aCoverID, int aNewCoverId, T aCoverVariable, T aNewCoverVariable, ICoverable aTileEntity) {
    }

    protected void onDroppedImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
    }

    protected void onBaseTEDestroyedImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
    }

    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    protected T doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, T aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable;
    }

    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    protected T onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return aCoverVariable;
    }

    protected boolean onCoverShiftRightClickImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer) {
        if (this.hasCoverGUI() && aPlayer instanceof EntityPlayerMP) {
            this.lastPlayer = aPlayer;
            if (this.useModularUI()) {
                GT_UIInfos.openCoverUI(aTileEntity, aPlayer, side);
            } else {
                GT_Values.NW.sendToPlayer(new GT_Packet_TileEntityCoverGUI(side, aCoverID, (ISerializableObject)aCoverVariable, aTileEntity, (EntityPlayerMP)aPlayer), (EntityPlayerMP)aPlayer);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    protected Object getClientGUIImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return null;
    }

    protected boolean onCoverRemovalImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        return true;
    }

    protected String getDescriptionImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return "";
    }

    protected float getBlastProofLevelImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 10.0f;
    }

    protected boolean letsRedstoneGoInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, T aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return false;
    }

    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, T aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return false;
    }

    protected boolean isGUIClickableImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected boolean alwaysLookConnectedImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    protected byte getRedstoneInputImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return this.letsRedstoneGoIn(side, aCoverID, (ISerializableObject)aCoverVariable, aTileEntity) ? aInputRedstone : (byte)0;
    }

    protected int getTickRateImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return 0;
    }

    protected byte getLensColorImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return -1;
    }

    protected ItemStack getDropImpl(ForgeDirection side, int aCoverID, T aCoverVariable, ICoverable aTileEntity) {
        return GT_OreDictUnificator.get(true, aTileEntity.getCoverItemAtSide(side));
    }

    public boolean isCoverPlaceable(ForgeDirection side, ItemStack aStack, ICoverable aTileEntity) {
        return this.isCoverPlaceable(side, new GT_ItemStack(aStack), aTileEntity);
    }

    @Deprecated
    public boolean isCoverPlaceable(ForgeDirection side, GT_ItemStack aStack, ICoverable aTileEntity) {
        return true;
    }

    public boolean hasCoverGUI() {
        return false;
    }

    public boolean onCoverRightclickClient(ForgeDirection side, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return false;
    }

    public boolean isSimpleCover() {
        return false;
    }

    public void placeCover(ForgeDirection side, ItemStack aCover, ICoverable aTileEntity) {
        aTileEntity.setCoverIDAtSide(side, GT_Utility.stackToInt(aCover));
    }

    @Deprecated
    public String trans(String aNr, String aEnglish) {
        return GT_Utility.trans(aNr, aEnglish);
    }

    protected class UIFactory {
        private final GT_CoverUIBuildContext uiBuildContext;
        protected final Supplier<Integer> COLOR_TITLE = () -> this.getTextColorOrDefault("title", 0x222222);
        protected final Supplier<Integer> COLOR_TEXT_GRAY = () -> this.getTextColorOrDefault("text_gray", 0x555555);
        protected final Supplier<Integer> COLOR_TEXT_WARN = () -> this.getTextColorOrDefault("text_warn", 0xFF0000);

        public UIFactory(GT_CoverUIBuildContext buildContext) {
            this.uiBuildContext = buildContext;
        }

        public ModularWindow createWindow() {
            ModularWindow.Builder builder = ModularWindow.builder((int)this.getGUIWidth(), (int)this.getGUIHeight());
            builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
            builder.setGuiTint(this.getUIBuildContext().getGuiColorization());
            if (this.doesBindPlayerInventory() && !this.getUIBuildContext().isAnotherWindow()) {
                builder.bindPlayerInventory(this.getUIBuildContext().getPlayer());
            }
            this.addTitleToUI(builder);
            this.addUIWidgets(builder);
            if (this.getUIBuildContext().isAnotherWindow()) {
                builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(this.getGUIWidth() - 15, 3));
            }
            return builder.build();
        }

        protected void addUIWidgets(ModularWindow.Builder builder) {
        }

        public GT_CoverUIBuildContext getUIBuildContext() {
            return this.uiBuildContext;
        }

        @Nullable
        public T getCoverData() {
            if (this.isCoverValid()) {
                return GT_CoverBehaviorBase.this.forceCast(this.getUIBuildContext().getTile().getComplexCoverDataAtSide(this.getUIBuildContext().getCoverSide()));
            }
            return null;
        }

        public boolean setCoverData(T data) {
            if (this.isCoverValid()) {
                this.getUIBuildContext().getTile().receiveCoverData(this.getUIBuildContext().getCoverSide(), this.getUIBuildContext().getCoverID(), (ISerializableObject)data, this.getUIBuildContext().getPlayer() instanceof EntityPlayerMP ? (EntityPlayerMP)this.getUIBuildContext().getPlayer() : null);
                return true;
            }
            return false;
        }

        public boolean isCoverValid() {
            return !this.getUIBuildContext().getTile().isDead() && this.getUIBuildContext().getTile().getCoverBehaviorAtSideNew(this.getUIBuildContext().getCoverSide()) != GregTech_API.sNoBehavior;
        }

        protected void addTitleToUI(ModularWindow.Builder builder) {
            ItemStack coverItem = GT_Utility.intToStack(this.getUIBuildContext().getCoverID());
            if (coverItem != null) {
                ((ModularWindow.Builder)builder.widget(new ItemDrawable(coverItem).asWidget().setPos(5, 5).setSize(16, 16))).widget(new TextWidget(coverItem.func_82833_r()).setDefaultColor(this.COLOR_TITLE.get().intValue()).setPos(25, 9));
            }
        }

        protected int getGUIWidth() {
            return 176;
        }

        protected int getGUIHeight() {
            return 107;
        }

        protected boolean doesBindPlayerInventory() {
            return false;
        }

        protected int getTextColorOrDefault(String textType, int defaultColor) {
            return GT_CoverBehaviorBase.this.colorOverride.getTextColorOrDefault(textType, defaultColor);
        }
    }
}

