/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasInventory;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GT_Packet_SetConfigurationCircuit
extends GT_Packet_New {
    protected int mX;
    protected short mY;
    protected int mZ;
    protected int dimId;
    protected ItemStack circuit;

    public GT_Packet_SetConfigurationCircuit() {
        super(true);
    }

    public GT_Packet_SetConfigurationCircuit(IGregTechTileEntity tile, ItemStack circuit) {
        this(tile.getXCoord(), tile.getYCoord(), tile.getZCoord(), circuit);
    }

    public GT_Packet_SetConfigurationCircuit(BaseTileEntity tile, ItemStack circuit) {
        this(tile.getXCoord(), tile.getYCoord(), tile.getZCoord(), circuit);
    }

    public GT_Packet_SetConfigurationCircuit(int x, short y, int z, ItemStack circuit) {
        super(false);
        this.mX = x;
        this.mY = y;
        this.mZ = z;
        this.circuit = circuit;
    }

    @Override
    public byte getPacketID() {
        return 12;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        ByteBufUtils.writeItemStack((ByteBuf)aOut, (ItemStack)this.circuit);
    }

    @Override
    public void setINetHandler(INetHandler aHandler) {
        this.dimId = aHandler instanceof NetHandlerPlayServer ? ((NetHandlerPlayServer)aHandler).field_147369_b.field_71093_bK : -2;
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        return new GT_Packet_SetConfigurationCircuit(aData.readInt(), aData.readShort(), aData.readInt(), ISerializableObject.readItemStackFromGreggyByteBuf(aData));
    }

    @Override
    public void process(IBlockAccess aWorld) {
        WorldServer world = DimensionManager.getWorld((int)this.dimId);
        if (world == null) {
            return;
        }
        TileEntity tile = world.func_147438_o(this.mX, (int)this.mY, this.mZ);
        if (!(tile instanceof BaseTileEntity) || ((BaseTileEntity)tile).isDead()) {
            return;
        }
        IConfigurationCircuitSupport machine = ((BaseTileEntity)tile).getConfigurationCircuitSupport();
        if (machine == null) {
            return;
        }
        if (!machine.allowSelectCircuit()) {
            return;
        }
        machine.getConfigurationCircuits().stream().filter(stack -> GT_Utility.areStacksEqual(stack, this.circuit)).findFirst().ifPresent(stack -> ((IHasInventory)tile).func_70299_a(machine.getCircuitSlot(), (ItemStack)stack));
    }
}

