/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class WallShareablePart
extends MultiBlockPart {
    protected List<ChunkCoordinates> targetPositions = new ArrayList<ChunkCoordinates>();
    protected List<IMultiBlockController> targets = new ArrayList<IMultiBlockController>();

    @Override
    public void setTarget(IMultiBlockController aTarget, int aAllowedModes) {
        if (this.targets.size() > 1 || this.targetPositions.size() > 1) {
            this.mAllowedModes = 0;
            this.mMode = 0;
        } else {
            this.mAllowedModes = aAllowedModes;
        }
        if (aTarget == null) {
            return;
        }
        this.targets.add(aTarget);
        this.targetPositions.add(aTarget.getCoords());
    }

    @Override
    public String getLockedInventory() {
        this.issueClientUpdate();
        if (this.targets.size() > 1 || this.targetPositions.size() > 1) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(false);
        if (!this.getNameOfInventoryFromIndex(controller, this.mLockedInventoryIndex).equals(this.mLockedInventory)) {
            this.mLockedInventory = this.getNameOfInventoryFromIndex(controller, this.mLockedInventoryIndex);
            if (this.mLockedInventory.equals("all")) {
                this.mLockedInventory = "";
            }
        }
        return this.mLockedInventory.equals("") ? null : this.mLockedInventory;
    }

    @Override
    public IMultiBlockController getTarget(boolean aCheckValidity) {
        if (this.targets.size() > 1 || this.targetPositions.size() > 1 || this.targets.size() <= 0 || this.targetPositions.size() <= 0) {
            return null;
        }
        this.target = this.targets.get(0);
        this.mTargetPos = this.targetPositions.get(0);
        return super.getTarget(aCheckValidity);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multiTileEntity.casing.wallSharable";
    }

    @Override
    public boolean breakBlock() {
        for (ChunkCoordinates coordinates : this.targetPositions) {
            IMultiBlockController target = this.getTarget(coordinates, false);
            if (target == null) continue;
            target.onStructureChange();
        }
        return false;
    }

    @Override
    public void onBlockAdded() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.getTileEntityAtSide(side);
            if (te instanceof MultiBlockPart) {
                MultiBlockPart part = (MultiBlockPart)te;
                IMultiBlockController tController = part.getTarget(false);
                if (tController == null) continue;
                tController.onStructureChange();
                continue;
            }
            if (!(te instanceof IMultiBlockController)) continue;
            IMultiBlockController controller = (IMultiBlockController)te;
            controller.onStructureChange();
        }
    }

    public IMultiBlockController getTarget(ChunkCoordinates coordinates, boolean aCheckValidity) {
        TileEntity te;
        IMultiBlockController target = null;
        if (coordinates == null) {
            return null;
        }
        if (this.field_145850_b.func_72899_e(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c) && (te = this.field_145850_b.func_147438_o(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c)) instanceof IMultiBlockController) {
            target = (IMultiBlockController)te;
        }
        if (aCheckValidity) {
            return target != null && target.checkStructure(false) ? target : null;
        }
        return target;
    }
}

