/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.machine;

import com.google.common.primitives.Ints;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.fluid.FluidTankGT;
import gregtech.api.interfaces.ITexture;
import gregtech.api.logic.PollutionLogic;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.logic.interfaces.PollutionLogicHost;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.logic.interfaces.ProcessingLogicHost;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.base.MultiTileEntity;
import gregtech.api.multitileentity.base.TickableMultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiTileMachine;
import gregtech.api.net.GT_Packet_MultiTileEntity;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.client.GT_SoundLoop;
import gregtech.common.GT_Pollution;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MultiTileBasicMachine
extends TickableMultiTileEntity
implements IMultiTileMachine {
    protected static final int ACTIVE = GT_Values.B[0];
    protected static final int TICKS_BETWEEN_RECIPE_CHECKS = 100;
    protected static final int POLLUTION_TICK = 20;
    protected static final byte INTERRUPT_SOUND_INDEX = 8;
    protected static final byte PROCESS_START_SOUND_INDEX = 1;
    protected static final IItemHandlerModifiable EMPTY_INVENTORY = new ItemStackHandler(0);
    public ITexture activeOverlayTexture = null;
    public ITexture activeOverlayGlowTexture = null;
    public ITexture inactiveOverlayTexture = null;
    public ITexture inactiveOverlayGlowTexture = null;
    protected int maxParallel = 1;
    protected boolean active = false;
    protected long storedEnergy = 0L;
    protected long voltage = 0L;
    protected long amperage = 2L;
    protected long eut = 0L;
    protected int tier = 0;
    protected long maxProgressTime = 0L;
    protected long progressTime = 0L;
    protected long burnTime = 0L;
    protected long totalBurnTime = 0L;
    protected FluidTankGT[] inputTanks = GT_Values.emptyFluidTankGT;
    protected FluidTankGT[] outputTanks = GT_Values.emptyFluidTankGT;
    protected FluidStack[] fluidsToOutput = GT_Values.emptyFluidStack;
    protected ItemStack[] itemsToOutput = GT_Values.emptyItemStackArray;
    protected IItemHandlerModifiable inputInventory = EMPTY_INVENTORY;
    protected IItemHandlerModifiable outputInventory = EMPTY_INVENTORY;
    protected boolean outputInventoryChanged = false;
    protected boolean powerShutDown = false;
    protected boolean wasEnabled = false;
    protected boolean canWork = true;
    protected boolean isElectric = true;
    protected boolean isSteam = false;
    protected boolean acceptsFuel = false;
    protected boolean isWireless = false;
    protected byte soundEvent = 0;
    protected int soundEventValue = 0;
    @SideOnly(value=Side.CLIENT)
    protected GT_SoundLoop activitySoundLoop;

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.machine.basic";
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        int i;
        super.writeMultiTileNBT(nbt);
        if (this.maxParallel > 0) {
            nbt.func_74768_a("gt.parallel", this.maxParallel);
        }
        if (this.active) {
            nbt.func_74757_a("gt.active", this.active);
        }
        if (this.inputInventory != null && this.inputInventory.getSlots() > 0) {
            this.writeInventory(nbt, this.inputInventory, "gt.invlist.in");
        }
        if (this.outputInventory != null && this.outputInventory.getSlots() > 0) {
            this.writeInventory(nbt, this.outputInventory, "gt.invlist.out");
        }
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.inputTanks[i].writeToNBT(nbt, "gt.tank.in." + i);
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.outputTanks[i].writeToNBT(nbt, "gt.tank.out." + i);
        }
        if (this.fluidsToOutput != null && this.fluidsToOutput.length > 0) {
            this.writeFluids(nbt, this.fluidsToOutput, "gt.fluidout");
        }
        if (this.itemsToOutput != null) {
            this.saveItemsToOutput(nbt);
        }
        nbt.func_74768_a("gt.tier", this.tier);
        nbt.func_74772_a("gt.eut.consumption", this.eut);
        nbt.func_74772_a("gt.burn.time.left", this.burnTime);
        nbt.func_74772_a("gt.total.burn.time", this.totalBurnTime);
        nbt.func_74757_a("gt.allowed.work", this.canWork);
        nbt.func_74757_a("gt.active", this.active);
    }

    protected void writeFluids(NBTTagCompound nbt, FluidStack[] fluids, String fluidListTag) {
        if (fluids != null && fluids.length > 0) {
            NBTTagList tList = new NBTTagList();
            for (FluidStack tFluid : fluids) {
                if (tFluid == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tFluid.writeToNBT(tag);
                tList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a(fluidListTag, (NBTBase)tList);
        }
    }

    protected void writeInventory(NBTTagCompound nbt, IItemHandlerModifiable inv, String invListTag) {
        if (inv != null && inv.getSlots() > 0) {
            NBTTagList tList = new NBTTagList();
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack tStack = inv.getStackInSlot(slot);
                if (tStack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("s", (byte)slot);
                tStack.func_77955_b(tag);
                tList.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a(invListTag, (NBTBase)tList);
        }
    }

    protected void saveItemsToOutput(NBTTagCompound aNBT) {
        NBTTagList nbtList = new NBTTagList();
        for (int slot = 0; slot < this.itemsToOutput.length; ++slot) {
            ItemStack itemStack = this.itemsToOutput[slot];
            if (itemStack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("s", (byte)slot);
            itemStack.func_77955_b(tag);
            nbtList.func_74742_a((NBTBase)tag);
        }
        aNBT.func_74782_a("gt.itemout", (NBTBase)nbtList);
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        int i;
        super.readMultiTileNBT(nbt);
        if (nbt.func_74764_b("gt.parallel")) {
            this.maxParallel = Math.max(1, nbt.func_74762_e("gt.parallel"));
        }
        if (nbt.func_74764_b("gt.active")) {
            this.active = nbt.func_74767_n("gt.active");
        }
        this.inputInventory = new ItemStackHandler(Math.max(nbt.func_74762_e("gt.invsize.in"), 0));
        this.outputInventory = new ItemStackHandler(Math.max(nbt.func_74762_e("gt.invsize.out"), 0));
        this.loadInventory(nbt, this.inputInventory, "gt.invlist.in");
        this.loadInventory(nbt, this.outputInventory, "gt.invlist.out");
        long capacity = 1000L;
        if (nbt.func_74764_b("gt.tankcap")) {
            capacity = Ints.saturatedCast((long)nbt.func_74763_f("gt.tankcap"));
        }
        this.inputTanks = new FluidTankGT[this.getFluidInputCount()];
        this.outputTanks = new FluidTankGT[this.getFluidOutputCount()];
        this.fluidsToOutput = new FluidStack[this.getFluidOutputCount()];
        for (i = 0; i < this.inputTanks.length; ++i) {
            this.inputTanks[i] = new FluidTankGT(capacity).setCapacityMultiplier((long)this.maxParallel * 2L).readFromNBT(nbt, "gt.tank.in." + i);
        }
        for (i = 0; i < this.outputTanks.length; ++i) {
            this.outputTanks[i] = new FluidTankGT(capacity).setCapacityMultiplier((long)this.maxParallel * 2L).readFromNBT(nbt, "gt.tank.out." + i);
        }
        for (i = 0; i < this.fluidsToOutput.length; ++i) {
            this.fluidsToOutput[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("gt.fluidout." + i));
        }
        this.loadItemsToOutput(nbt);
        this.tier = nbt.func_74762_e("gt.tier");
        this.eut = nbt.func_74763_f("gt.eut.consumption");
        this.burnTime = nbt.func_74763_f("gt.burn.time.left");
        this.totalBurnTime = nbt.func_74763_f("gt.total.burn.time");
        this.canWork = nbt.func_74767_n("gt.allowed.work");
        this.active = nbt.func_74767_n("gt.active");
    }

    protected void loadInventory(NBTTagCompound aNBT, IItemHandlerModifiable inv, String invListTag) {
        NBTTagList tList = aNBT.func_150295_c(invListTag, 10);
        for (int i = 0; i < tList.func_74745_c(); ++i) {
            NBTTagCompound tNBT = tList.func_150305_b(i);
            short tSlot = tNBT.func_74765_d("s");
            if (tSlot < 0 || tSlot >= inv.getSlots()) continue;
            inv.setStackInSlot((int)tSlot, GT_Utility.loadItem(tNBT));
        }
    }

    protected void loadItemsToOutput(NBTTagCompound aNBT) {
        NBTTagList tList = aNBT.func_150295_c("gt.itemout", 10);
        this.itemsToOutput = new ItemStack[tList.func_74745_c()];
        for (int i = 0; i < tList.func_74745_c(); ++i) {
            NBTTagCompound tNBT = tList.func_150305_b(i);
            byte tSlot = tNBT.func_74771_c("s");
            if (tSlot < 0 || tSlot >= this.itemsToOutput.length) continue;
            this.itemsToOutput[tSlot] = GT_Utility.loadItem(tNBT);
        }
    }

    @Override
    public void loadTextures(String folder) {
        super.loadTextures(folder);
        block8: for (MultiTileEntity.StatusTextures textureName : MultiTileEntity.StatusTextures.TEXTURES) {
            ITexture texture = null;
            try {
                Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(Mods.GregTech.ID, "textures/blocks/multitileentity/" + folder + "/" + textureName.getName() + ".png"));
            }
            catch (IOException ignored) {
                texture = TextureFactory.of(Textures.BlockIcons.VOID);
            }
            if (texture == null) {
                texture = textureName.hasGlow() ? TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("multitileentity/" + folder + "/" + textureName.getName())).glow().build() : TextureFactory.of(new Textures.BlockIcons.CustomIcon("multitileentity/" + folder + "/" + textureName.getName()));
            }
            switch (textureName) {
                case Active: {
                    this.activeOverlayTexture = texture;
                    continue block8;
                }
                case ActiveWithGlow: {
                    this.activeOverlayGlowTexture = texture;
                    continue block8;
                }
                case Inactive: {
                    this.inactiveOverlayTexture = texture;
                    continue block8;
                }
                case InactiveWithGlow: {
                    this.inactiveOverlayGlowTexture = texture;
                }
            }
        }
    }

    @Override
    public void copyTextures() {
        super.copyTextures();
        TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID());
        if (!(tCanonicalTileEntity instanceof MultiTileBasicMachine)) {
            return;
        }
        MultiTileBasicMachine canonicalEntity = (MultiTileBasicMachine)tCanonicalTileEntity;
        this.activeOverlayTexture = canonicalEntity.activeOverlayTexture;
        this.activeOverlayGlowTexture = canonicalEntity.activeOverlayGlowTexture;
        this.inactiveOverlayTexture = canonicalEntity.inactiveOverlayTexture;
        this.inactiveOverlayGlowTexture = canonicalEntity.inactiveOverlayGlowTexture;
    }

    @Override
    public ITexture getTexture(ForgeDirection side) {
        ITexture texture = super.getTexture(side);
        if (side == this.facing) {
            if (this.isActive()) {
                return TextureFactory.of(texture, this.activeOverlayTexture, this.activeOverlayGlowTexture);
            }
            return TextureFactory.of(texture, this.inactiveOverlayTexture, this.inactiveOverlayGlowTexture);
        }
        return TextureFactory.of(texture, this.getCoverTexture(side));
    }

    @Override
    public GT_Packet_MultiTileEntity getClientDataPacket() {
        GT_Packet_MultiTileEntity packet = super.getClientDataPacket();
        int booleans = this.getBooleans();
        packet.setBooleans(booleans);
        packet.setSoundEvent(this.soundEvent, this.soundEventValue);
        return packet;
    }

    public int getFluidInputCount() {
        return 7;
    }

    public int getFluidOutputCount() {
        return 3;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    public String func_145825_b() {
        String name = this.getCustomName();
        if (name != null) {
            return name;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return this.playerOwnsThis(aPlayer, false) && this.mTickTimer > 40L && this.getTileEntityOffset(0, 0, 0) == this && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0 && this.allowInteraction((Entity)aPlayer);
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return side != this.facing;
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return side != this.facing;
    }

    @Override
    protected IFluidTank[] getFluidTanks(ForgeDirection side) {
        boolean fluidInput = this.isLiquidInput(side);
        boolean fluidOutput = this.isLiquidOutput(side);
        if (fluidInput && fluidOutput) {
            IFluidTank[] rTanks = new IFluidTank[this.inputTanks.length + this.outputTanks.length];
            System.arraycopy(this.inputTanks, 0, rTanks, 0, this.inputTanks.length);
            System.arraycopy(this.outputTanks, 0, rTanks, this.inputTanks.length, this.outputTanks.length);
            return rTanks;
        }
        if (fluidInput) {
            return this.inputTanks;
        }
        if (fluidOutput) {
            return this.outputTanks;
        }
        return GT_Values.emptyFluidTank;
    }

    @Override
    public IFluidTank getFluidTankFillable(ForgeDirection side, FluidStack aFluidToFill) {
        return this.getFluidTankFillable(this.facing, side, aFluidToFill);
    }

    public IFluidTank getFluidTankFillable(ForgeDirection sideSource, ForgeDirection sideDestination, FluidStack fluidToFill) {
        if (sideSource.compareTo((Enum)sideDestination) != 0) {
            return null;
        }
        for (FluidTankGT tankGT : this.inputTanks) {
            if (!tankGT.contains(fluidToFill)) continue;
            return tankGT;
        }
        for (FluidTankGT fluidTankGT : this.inputTanks) {
            if (!fluidTankGT.isEmpty()) continue;
            return fluidTankGT;
        }
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable(ForgeDirection side, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable(this.facing, side, aFluidToDrain);
    }

    protected IFluidTank getFluidTankDrainable(ForgeDirection sideSource, ForgeDirection sideDestination, FluidStack fluidToDrain) {
        if (sideSource.compareTo((Enum)sideDestination) != 0) {
            return null;
        }
        for (FluidTankGT fluidTankGT : this.outputTanks) {
            if (!(fluidToDrain == null ? fluidTankGT.has() : fluidTankGT.contains(fluidToDrain))) continue;
            return fluidTankGT;
        }
        return null;
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.hasInventoryChanged;
    }

    public void markOutputInventoryBeenModified() {
        this.outputInventoryChanged = true;
    }

    public boolean hasOutputInventoryBeenModified() {
        return this.outputInventoryChanged;
    }

    public void markInputInventoryBeenModified() {
        this.hasInventoryChanged = true;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void onPostTick(long tick, boolean isServerSide) {
        if (isServerSide) {
            this.runMachine(tick);
        } else {
            this.doActivitySound(this.getActivitySoundLoop());
        }
    }

    protected void runMachine(long tick) {
        if (this.acceptsFuel() && this.isActive() && !this.consumeFuel()) {
            this.stopMachine(true);
            return;
        }
        if (this.hasThingsToDo()) {
            this.func_70296_d();
            this.runningTick(tick);
        } else if ((tick % 100L == 0L || this.hasWorkJustBeenEnabled() || this.hasInventoryBeenModified()) && this.isAllowedToWork()) {
            this.wasEnabled = false;
            if (this.checkRecipe()) {
                this.setActive(true);
                this.setSound((byte)5, 1);
                this.updateSlots();
                this.func_70296_d();
                this.issueClientUpdate();
            }
        }
    }

    protected void runningTick(long tick) {
        if (this instanceof PowerLogicHost) {
            this.consumeEnergy();
        }
        if (this.maxProgressTime > 0L && ++this.progressTime >= this.maxProgressTime) {
            this.progressTime = 0L;
            this.maxProgressTime = 0L;
            this.outputItems();
            this.outputFluids();
            if (this.isAllowedToWork() && !this.checkRecipe()) {
                this.setActive(false);
                this.issueClientUpdate();
            }
            this.updateSlots();
        }
        if (this instanceof PollutionLogicHost && tick % 20L == 0L) {
            this.doPollution();
        }
        this.emitEnergy();
    }

    protected boolean checkRecipe() {
        if (!(this instanceof ProcessingLogicHost)) {
            return false;
        }
        ProcessingLogic logic = ((ProcessingLogicHost)((Object)this)).getProcessingLogic();
        logic.clear();
        CheckRecipeResult result = logic.setInputItems(this.getInputItems()).setInputFluids(this.getInputFluids()).setCurrentOutputItems(this.outputInventory.getStacks().toArray(new ItemStack[0])).process();
        this.setDuration(logic.getDuration());
        this.setEut(logic.getCalculatedEut());
        this.setItemOutputs(logic.getOutputItems());
        this.setFluidOutputs(logic.getOutputFluids());
        return result.wasSuccessful();
    }

    protected void doPollution() {
        PollutionLogic logic = ((PollutionLogicHost)((Object)this)).getPollutionLogic();
        if (logic == null) {
            return;
        }
        GT_Pollution.addPollution(this.getWorld(), this.getXCoord() >> 4, this.getZCoord() >> 4, logic.getPollutionAmount());
    }

    protected void emitEnergy() {
    }

    protected void consumeEnergy() {
        PowerLogic logic = ((PowerLogicHost)((Object)this)).getPowerLogic(ForgeDirection.UNKNOWN);
        if (logic == null) {
            return;
        }
        if (!logic.removeEnergyUnsafe(this.eut)) {
            this.stopMachine(true);
        }
    }

    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        switch (aIndex) {
            case 1: {
                if (this.getProcessStartSound() == null) break;
                GT_Utility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
                break;
            }
            case 8: {
                GT_Utility.doSoundAtClient(SoundResource.IC2_MACHINES_INTERRUPT_ONE, 100, 1.0f, aX, aY, aZ);
            }
        }
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == 1 && this.getProcessStartSound() != null) {
            GT_Utility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, aX, aY, aZ);
        }
    }

    protected ResourceLocation getProcessStartSound() {
        return null;
    }

    protected int getTimeBetweenProcessSounds() {
        return 100;
    }

    @SideOnly(value=Side.CLIENT)
    protected void doActivitySound(ResourceLocation activitySound) {
        if (this.isActive() && activitySound != null) {
            if (this.activitySoundLoop == null) {
                this.activitySoundLoop = new GT_SoundLoop(activitySound, this, false, true);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.activitySoundLoop);
            }
        } else if (this.activitySoundLoop != null) {
            this.activitySoundLoop = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySoundLoop() {
        return null;
    }

    protected ItemStack[] getInputItems() {
        return this.inputInventory.getStacks().toArray(new ItemStack[0]);
    }

    protected FluidStack[] getInputFluids() {
        return (FluidStack[])Arrays.stream(this.inputTanks).map(FluidTankGT::get).toArray(FluidStack[]::new);
    }

    protected void outputItems() {
        this.outputItems(this.itemsToOutput);
        this.itemsToOutput = null;
    }

    protected void outputItems(ItemStack ... itemsToOutput) {
        this.outputItems(this.outputInventory, itemsToOutput);
    }

    protected void outputItems(IItemHandlerModifiable inventory, ItemStack ... itemsToOutput) {
        if (itemsToOutput == null || inventory == null) {
            return;
        }
        for (ItemStack item : itemsToOutput) {
            int index = 0;
            while (item != null && item.field_77994_a > 0 && index < inventory.getSlots()) {
                item = inventory.insertItem(index++, item.func_77946_l(), false);
            }
        }
    }

    protected void outputFluids() {
        this.outputFluids(this.fluidsToOutput);
        this.fluidsToOutput = null;
    }

    protected void outputFluids(FluidStack ... fluidsToOutput) {
        this.outputFluids(this.outputTanks, fluidsToOutput);
    }

    protected void outputFluids(FluidTankGT[] tankArray, FluidStack ... fluidsToOutput) {
        if (fluidsToOutput == null) {
            return;
        }
        for (FluidStack fluid : fluidsToOutput) {
            this.tryToFillTanks(fluid, tankArray);
        }
    }

    protected void tryToFillTanks(FluidStack fluid, FluidTankGT ... tanks) {
        for (FluidTankGT tank : tanks) {
            if (!tank.canFillAll(fluid)) continue;
            fluid.amount = (int)((long)fluid.amount - tank.add(fluid.amount, fluid));
        }
    }

    public long getProgress() {
        return this.progressTime;
    }

    public long getMaxProgress() {
        return this.maxProgressTime;
    }

    public boolean increaseProgress(int aProgressAmountInTicks) {
        this.progressTime += (long)aProgressAmountInTicks;
        return true;
    }

    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0L;
    }

    public boolean hasWorkJustBeenEnabled() {
        return this.wasEnabled;
    }

    public void enableWorking() {
        this.wasEnabled = true;
        this.canWork = true;
    }

    public void disableWorking() {
        this.canWork = false;
    }

    public boolean wasShutdown() {
        return this.powerShutDown;
    }

    public boolean isAllowedToWork() {
        return this.canWork;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    protected boolean isElectric() {
        return this.isElectric;
    }

    protected void setElectric(boolean isElectric) {
        this.isElectric = isElectric;
    }

    protected boolean isSteam() {
        return this.isSteam;
    }

    protected void setSteam(boolean isSteam) {
        this.isSteam = isSteam;
    }

    protected boolean acceptsFuel() {
        return this.acceptsFuel;
    }

    protected void setFuel(boolean acceptsFuel) {
        this.acceptsFuel = acceptsFuel;
    }

    protected boolean isWireless() {
        return this.isWireless;
    }

    protected void setWireless(boolean isWireless) {
        this.isWireless = isWireless;
    }

    protected boolean drainEut(long eut) {
        return this.decreaseStoredEnergyUnits(eut, false);
    }

    protected boolean generateEut(long eut) {
        return this.increaseStoredEnergyUnits(eut, true);
    }

    protected boolean isGenerator() {
        return false;
    }

    protected boolean consumeFuel() {
        if (this.isActive() && this.burnTime <= 0L) {
            for (int i = 0; i < this.inputInventory.getSlots(); ++i) {
                int checkBurnTime;
                if (this.inputInventory.getStackInSlot(i) == null || (checkBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inputInventory.getStackInSlot(i)) / 10) <= 0) continue;
                --this.inputInventory.getStackInSlot((int)i).field_77994_a;
                this.burnTime = checkBurnTime;
                this.totalBurnTime = checkBurnTime;
                break;
            }
            this.updateSlots();
        }
        if (--this.burnTime < 0L) {
            this.burnTime = 0L;
            this.totalBurnTime = 0L;
            return false;
        }
        return true;
    }

    @Override
    protected void addDebugInfo(EntityPlayer player, int logLevel, ArrayList<String> list) {
        MultiTileBasicMachine multiTileBasicMachine;
        list.add(GT_Utility.trans("186", "Owned by: ") + EnumChatFormatting.BLUE + this.getOwnerName() + EnumChatFormatting.RESET + " (" + EnumChatFormatting.AQUA + this.getOwnerUuid() + EnumChatFormatting.RESET + ")");
        if (this.acceptsFuel()) {
            list.add("Fuel: " + EnumChatFormatting.GOLD + this.burnTime + "/" + this.totalBurnTime);
        }
        if ((multiTileBasicMachine = this) instanceof PowerLogicHost) {
            PowerLogicHost powerLogicHost = (PowerLogicHost)((Object)multiTileBasicMachine);
            PowerLogic logic = powerLogicHost.getPowerLogic(this.facing);
            if (this.isElectric) {
                list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(logic.getStoredEnergy()) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(logic.getCapacity()) + EnumChatFormatting.RESET + " EU");
                list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(this.eut) + EnumChatFormatting.RESET + " EU/t");
                list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(logic.getVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(logic.getVoltage())] + EnumChatFormatting.RESET);
            }
        }
        this.addProgressStringToScanner(player, logLevel, list);
        list.add("Average CPU load of ~" + GT_Utility.formatNumbers(0L) + "ns over " + GT_Utility.formatNumbers(0L) + " ticks with worst time of " + GT_Utility.formatNumbers(0L) + "ns.");
    }

    protected void addProgressStringToScanner(EntityPlayer player, int logLevel, ArrayList<String> list) {
        list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.progressTime > 20L ? this.progressTime / 20L : this.progressTime) + EnumChatFormatting.RESET + (this.progressTime > 20L ? " s / " : " ticks / ") + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.maxProgressTime > 20L ? this.maxProgressTime / 20L : this.maxProgressTime) + EnumChatFormatting.RESET + (this.maxProgressTime > 20L ? " s" : " ticks"));
    }

    protected void stopMachine(boolean powerShutDown) {
        this.progressTime = 0L;
        this.setActive(false);
        this.disableWorking();
        if (powerShutDown) {
            this.setSound((byte)6, 8);
        }
        this.issueClientUpdate();
    }

    protected void updateSlots() {
        for (int i = 0; i < this.inputInventory.getSlots(); ++i) {
            ItemStack item = this.inputInventory.getStackInSlot(i);
            if (item == null || item.field_77994_a > 0) continue;
            this.inputInventory.setStackInSlot(i, null);
        }
        for (FluidTankGT inputTank : this.inputTanks) {
            if (inputTank == null) continue;
            if (inputTank.get() != null && inputTank.get().amount <= 0) {
                inputTank.setEmpty();
                continue;
            }
            FluidStack afterRecipe = inputTank.get();
            FluidStack beforeRecipe = inputTank.get(Integer.MAX_VALUE);
            if (afterRecipe == null || beforeRecipe == null) continue;
            int difference = beforeRecipe.amount - afterRecipe.amount;
            inputTank.remove(difference);
        }
    }

    protected void setEut(long eut) {
        if (eut < 0L) {
            eut = -eut;
        }
        this.eut = eut;
    }

    protected void setDuration(long duration) {
        if (duration < 0L) {
            duration = -duration;
        }
        this.maxProgressTime = duration;
    }

    @Override
    public int getBooleans() {
        int booleans = 0;
        if (this.isActive()) {
            booleans |= ACTIVE;
        }
        return booleans;
    }

    @Override
    public void setBooleans(int booleans) {
        this.setActive((booleans & ACTIVE) == ACTIVE);
    }

    protected boolean hasItemInput() {
        return true;
    }

    protected boolean hasItemOutput() {
        return true;
    }

    protected boolean hasFluidInput() {
        return true;
    }

    protected boolean hasFluidOutput() {
        return true;
    }

    protected void setItemOutputs(ItemStack ... outputs) {
        this.itemsToOutput = outputs;
    }

    protected void setFluidOutputs(FluidStack ... outputs) {
        this.fluidsToOutput = outputs;
    }

    @Override
    public void setSound(byte soundEvent, int soundEventValue) {
        this.soundEvent = soundEvent;
        this.soundEventValue = soundEventValue;
        if (this.isClientSide()) {
            switch (soundEventValue) {
                case 1: {
                    if (this.getProcessStartSound() == null) break;
                    GT_Utility.doSoundAtClient(this.getProcessStartSound(), this.getTimeBetweenProcessSounds(), 1.0f, (double)this.getXCoord(), (double)this.getYCoord(), (double)this.getZCoord());
                    break;
                }
                case 8: {
                    GT_Utility.doSoundAtClient(SoundResource.IC2_MACHINES_INTERRUPT_ONE, 100, 1.0f, (double)this.getXCoord(), (double)this.getYCoord(), (double)this.getZCoord());
                }
            }
        }
    }
}

