/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import gregtech.api.interfaces.tileentity.IRecipeLockable;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.FindRecipeResult;
import gregtech.api.recipe.check.SingleRecipeCheck;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingLogic {
    protected IVoidable machine;
    protected IRecipeLockable recipeLockableMachine;
    protected Supplier<GT_Recipe.GT_Recipe_Map> recipeMapSupplier;
    protected GT_Recipe lastRecipe;
    protected GT_Recipe.GT_Recipe_Map lastRecipeMap;
    protected ItemStack specialSlotItem;
    protected ItemStack[] inputItems;
    protected ItemStack[] outputItems;
    protected ItemStack[] currentOutputItems;
    protected FluidStack[] inputFluids;
    protected FluidStack[] outputFluids;
    protected FluidStack[] currentOutputFluids;
    protected long calculatedEut;
    protected int duration;
    protected long availableVoltage;
    protected long availableAmperage;
    protected int overClockTimeReduction = 1;
    protected int overClockPowerIncrease = 2;
    protected boolean protectItems;
    protected boolean protectFluids;
    protected boolean isRecipeLocked;
    protected int maxParallel = 1;
    protected int calculatedParallels = 0;
    protected Supplier<Integer> maxParallelSupplier;
    protected int batchSize = 1;
    protected float euModifier = 1.0f;
    protected float speedBoost = 1.0f;
    protected boolean amperageOC = true;

    public ProcessingLogic setInputItems(ItemStack ... itemInputs) {
        this.inputItems = itemInputs;
        return this;
    }

    public ProcessingLogic setInputItems(List<ItemStack> itemOutputs) {
        this.inputItems = itemOutputs.toArray(new ItemStack[0]);
        return this;
    }

    public ProcessingLogic setInputFluids(FluidStack ... fluidInputs) {
        this.inputFluids = fluidInputs;
        return this;
    }

    public ProcessingLogic setInputFluids(List<FluidStack> fluidInputs) {
        this.inputFluids = fluidInputs.toArray(new FluidStack[0]);
        return this;
    }

    public ProcessingLogic setSpecialSlotItem(ItemStack specialSlotItem) {
        this.specialSlotItem = specialSlotItem;
        return this;
    }

    public ProcessingLogic setOutputItems(ItemStack ... itemOutputs) {
        this.outputItems = itemOutputs;
        return this;
    }

    public ProcessingLogic setOutputFluids(FluidStack ... fluidOutputs) {
        this.outputFluids = fluidOutputs;
        return this;
    }

    public ProcessingLogic setCurrentOutputItems(ItemStack ... currentOutputItems) {
        this.currentOutputItems = currentOutputItems;
        return this;
    }

    public ProcessingLogic setCurrentOutputFluids(FluidStack ... currentOutputFluids) {
        this.currentOutputFluids = currentOutputFluids;
        return this;
    }

    public ProcessingLogic setRecipeLocking(IRecipeLockable recipeLockableMachine, boolean isRecipeLocked) {
        this.recipeLockableMachine = recipeLockableMachine;
        this.isRecipeLocked = isRecipeLocked;
        return this;
    }

    public ProcessingLogic setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
        return this;
    }

    public ProcessingLogic setMaxParallelSupplier(Supplier<Integer> supplier) {
        this.maxParallelSupplier = supplier;
        return this;
    }

    public ProcessingLogic setBatchSize(int size) {
        this.batchSize = size;
        return this;
    }

    public ProcessingLogic setRecipeMap(GT_Recipe.GT_Recipe_Map recipeMap) {
        return this.setRecipeMapSupplier(() -> recipeMap);
    }

    public ProcessingLogic setRecipeMapSupplier(Supplier<GT_Recipe.GT_Recipe_Map> supplier) {
        this.recipeMapSupplier = supplier;
        return this;
    }

    public ProcessingLogic setEuModifier(float modifier) {
        this.euModifier = modifier;
        return this;
    }

    public ProcessingLogic setSpeedBonus(float speedModifier) {
        this.speedBoost = speedModifier;
        return this;
    }

    public ProcessingLogic setMachine(IVoidable machine) {
        this.machine = machine;
        return this;
    }

    public ProcessingLogic setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public ProcessingLogic setCalculatedEut(long calculatedEut) {
        this.calculatedEut = calculatedEut;
        return this;
    }

    public ProcessingLogic setAvailableVoltage(long voltage) {
        this.availableVoltage = voltage;
        return this;
    }

    public ProcessingLogic setAvailableAmperage(long amperage) {
        this.availableAmperage = amperage;
        return this;
    }

    public ProcessingLogic setVoidProtection(boolean protectItems, boolean protectFluids) {
        this.protectItems = protectItems;
        this.protectFluids = protectFluids;
        return this;
    }

    public ProcessingLogic setOverclock(int timeReduction, int powerIncrease) {
        this.overClockTimeReduction = timeReduction;
        this.overClockPowerIncrease = powerIncrease;
        return this;
    }

    public ProcessingLogic enablePerfectOverclock() {
        return this.setOverclock(2, 2);
    }

    public ProcessingLogic setAmperageOC(boolean amperageOC) {
        this.amperageOC = amperageOC;
        return this;
    }

    public ProcessingLogic clear() {
        this.inputItems = null;
        this.inputFluids = null;
        this.specialSlotItem = null;
        this.outputItems = null;
        this.outputFluids = null;
        this.calculatedEut = 0L;
        this.duration = 0;
        this.calculatedParallels = 0;
        return this;
    }

    @Nonnull
    public CheckRecipeResult process() {
        CheckRecipeResult result;
        GT_Recipe recipe;
        FindRecipeResult findRecipeResult;
        GT_Recipe.GT_Recipe_Map recipeMap = this.recipeMapSupplier == null ? null : this.recipeMapSupplier.get();
        if (this.lastRecipeMap != recipeMap) {
            this.lastRecipe = null;
            this.lastRecipeMap = recipeMap;
        }
        if (this.maxParallelSupplier != null) {
            this.maxParallel = this.maxParallelSupplier.get();
        }
        if (this.isRecipeLocked && this.recipeLockableMachine != null && this.recipeLockableMachine.getSingleRecipeCheck() != null) {
            SingleRecipeCheck singleRecipeCheck = this.recipeLockableMachine.getSingleRecipeCheck();
            if (singleRecipeCheck.checkRecipeInputs(false, 1, this.inputItems, this.inputFluids) == 0) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            findRecipeResult = FindRecipeResult.ofSuccess(this.recipeLockableMachine.getSingleRecipeCheck().getRecipe());
        } else {
            findRecipeResult = this.findRecipe(recipeMap);
        }
        if (findRecipeResult.isSuccessful()) {
            recipe = findRecipeResult.getRecipeNonNull();
            result = this.validateRecipe(recipe);
            if (!result.wasSuccessful()) {
                return result;
            }
        } else {
            if (findRecipeResult.getState() == FindRecipeResult.State.INSUFFICIENT_VOLTAGE) {
                return CheckRecipeResultRegistry.insufficientPower(findRecipeResult.getRecipeNonNull().mEUt);
            }
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.lastRecipe = recipe;
        GT_ParallelHelper helper = this.createParallelHelper(recipe);
        GT_OverclockCalculator calculator = this.createOverclockCalculator(recipe);
        helper.setCalculator(calculator);
        helper.build();
        if (!helper.getResult().wasSuccessful()) {
            return helper.getResult();
        }
        this.calculatedParallels = helper.getCurrentParallel();
        if (calculator.getConsumption() == Long.MAX_VALUE) {
            return CheckRecipeResultRegistry.POWER_OVERFLOW;
        }
        if (calculator.getDuration() == Integer.MAX_VALUE) {
            return CheckRecipeResultRegistry.DURATION_OVERFLOW;
        }
        this.calculatedEut = calculator.getConsumption();
        double finalDuration = this.calculateDuration(recipe, helper, calculator);
        if (finalDuration >= 2.147483647E9) {
            return CheckRecipeResultRegistry.DURATION_OVERFLOW;
        }
        this.duration = (int)finalDuration;
        this.outputItems = helper.getItemOutputs();
        this.outputFluids = helper.getFluidOutputs();
        return result;
    }

    protected double calculateDuration(@Nonnull GT_Recipe recipe, @Nonnull GT_ParallelHelper helper, @Nonnull GT_OverclockCalculator calculator) {
        return (double)calculator.getDuration() * helper.getDurationMultiplierDouble();
    }

    @Nonnull
    protected FindRecipeResult findRecipe(@Nullable GT_Recipe.GT_Recipe_Map map) {
        if (map == null) {
            return FindRecipeResult.NOT_FOUND;
        }
        return map.findRecipeWithResult(this.lastRecipe, false, false, this.amperageOC ? this.availableVoltage * this.availableAmperage : this.availableVoltage, this.inputFluids, this.specialSlotItem, this.inputItems);
    }

    @Nonnull
    protected GT_ParallelHelper createParallelHelper(@Nonnull GT_Recipe recipe) {
        return new GT_ParallelHelper().setRecipe(recipe).setItemInputs(this.inputItems).setFluidInputs(this.inputFluids).setAvailableEUt(this.availableVoltage * this.availableAmperage).setMachine(this.machine, this.protectItems, this.protectFluids).setRecipeLocked(this.recipeLockableMachine, this.isRecipeLocked).setMaxParallel(this.maxParallel).setEUtModifier(this.euModifier).enableBatchMode(this.batchSize).setConsumption(true).setOutputCalculation(true);
    }

    @Nonnull
    protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Nonnull
    @Deprecated
    protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe, @Nullable GT_ParallelHelper helper) {
        return this.createOverclockCalculator(recipe);
    }

    @Nonnull
    protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
        return new GT_OverclockCalculator().setRecipeEUt(recipe.mEUt).setAmperage(this.availableAmperage).setEUt(this.availableVoltage).setDuration(recipe.mDuration).setSpeedBoost(this.speedBoost).setEUtDiscount(this.euModifier).setAmperageOC(this.amperageOC).setDurationDecreasePerOC(this.overClockTimeReduction).setEUtIncreasePerOC(this.overClockPowerIncrease);
    }

    public ItemStack[] getOutputItems() {
        return this.outputItems;
    }

    public FluidStack[] getOutputFluids() {
        return this.outputFluids;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getCalculatedEut() {
        return this.calculatedEut;
    }

    public int getCurrentParallels() {
        return this.calculatedParallels;
    }
}

