/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import codechicken.lib.gui.GuiDraw;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiTooltip;
import gregtech.api.interfaces.IGuiScreen;
import gregtech.api.util.GT_UtilityClient;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GT_GuiFakeItemButton
implements IGuiScreen.IGuiElement {
    private GT_GuiIcon bgIcon;
    private ItemStack item;
    private final IGuiScreen gui;
    private int xPosition;
    private int yPosition;
    private List<String> itemTooltips;
    private final GT_GuiTooltip tooltip = new GT_GuiTooltip(null, new String[0]){

        @Override
        public List<String> getToolTipText() {
            return GT_GuiFakeItemButton.this.itemTooltips;
        }

        @Override
        public boolean isDelayed() {
            return false;
        }

        @Override
        public Rectangle getBounds() {
            return GT_GuiFakeItemButton.this.getBounds();
        }
    };
    private final Rectangle rectangle;
    private boolean mimicSlot;

    public GT_GuiFakeItemButton(IGuiScreen gui, int x, int y, GT_GuiIcon bgIcon) {
        this.gui = gui;
        this.bgIcon = bgIcon;
        this.item = null;
        this.rectangle = new Rectangle(x, y, 18, 18);
        gui.addElement(this);
    }

    public GT_GuiFakeItemButton setItem(ItemStack i) {
        this.item = i;
        if (this.getMimicSlot()) {
            this.updateTooltip();
        }
        return this;
    }

    private void updateTooltip() {
        this.itemTooltips = this.item == null ? null : GT_UtilityClient.getTooltip(this.item, true);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public GT_GuiFakeItemButton setMimicSlot(boolean mimicSlot) {
        if (mimicSlot != this.mimicSlot) {
            if (mimicSlot) {
                this.updateTooltip();
                this.gui.addToolTip(this.tooltip);
            } else {
                this.gui.removeToolTip(this.tooltip);
            }
            this.mimicSlot = mimicSlot;
        }
        return this;
    }

    public boolean getMimicSlot() {
        return this.mimicSlot;
    }

    public GT_GuiIcon getBgIcon() {
        return this.bgIcon;
    }

    public GT_GuiFakeItemButton setBgIcon(GT_GuiIcon bgIcon) {
        this.bgIcon = bgIcon;
        return this;
    }

    @Override
    public void onInit() {
        this.xPosition = this.rectangle.x + this.gui.getGuiLeft();
        this.yPosition = this.rectangle.y + this.gui.getGuiTop();
    }

    @Override
    public void onRemoved() {
        if (this.mimicSlot) {
            this.gui.removeToolTip(this.tooltip);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float parTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.bgIcon != null) {
            GT_GuiIcon.render(this.bgIcon, this.xPosition - 1, this.yPosition - 1, 18.0, 18.0, 0.0, true);
        }
        if (this.item != null) {
            if (this.item.func_77973_b() instanceof ItemBlock) {
                GL11.glPushAttrib((int)8192);
                GL11.glEnable((int)32826);
            }
            this.gui.getItemRenderer().func_82406_b(this.gui.getFontRenderer(), Minecraft.func_71410_x().func_110434_K(), this.item, this.xPosition, this.yPosition);
            if (this.item.func_77973_b() instanceof ItemBlock) {
                GL11.glPopAttrib();
            }
        }
        if (this.getMimicSlot() && this.getBounds().contains(mouseX - this.gui.getGuiLeft(), mouseY - this.gui.getGuiTop())) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawGradientRect((int)this.xPosition, (int)this.yPosition, (int)16, (int)16, (int)-2130706433, (int)-2130706433);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        GL11.glPopAttrib();
    }

    public Rectangle getBounds() {
        return this.rectangle;
    }

    public void setX(int x) {
        this.rectangle.x = x;
    }

    public void setY(int y) {
        this.rectangle.y = y;
    }

    public void setWidth(int width) {
        this.rectangle.width = width;
    }

    public void setHeight(int height) {
        this.rectangle.height = height;
    }
}

