/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.common;

import com.gtnewhorizons.gravisuiteneo.GraviSuiteNeoRegistry;
import com.gtnewhorizons.gravisuiteneo.common.Achievements;
import com.gtnewhorizons.gravisuiteneo.common.DamageSources;
import com.gtnewhorizons.gravisuiteneo.common.PacketQuantumShield;
import com.gtnewhorizons.gravisuiteneo.common.Properties;
import com.gtnewhorizons.gravisuiteneo.util.QuantumShieldHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import gravisuite.GraviSuite;
import gravisuite.ItemGraviChestPlate;
import gravisuite.ServerProxy;
import ic2.api.item.ElectricItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        if (event == null) {
            return;
        }
        if (event.crafting == null) {
            return;
        }
        Item craftedItem = event.crafting.func_77973_b();
        if (craftedItem == GraviSuite.advDDrill) {
            event.player.func_71029_a((StatBase)Achievements.POWERDRILL);
        } else if (craftedItem == GraviSuiteNeoRegistry.plasmaLauncher) {
            event.player.func_71029_a((StatBase)Achievements.PLASMAGUN);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        ItemStack chest = player.func_71124_b(3);
        if (!(chest != null && chest.func_77973_b() instanceof ItemGraviChestPlate && GraviSuite.getOrCreateNbtData((ItemStack)chest).func_74767_n("isShieldActive") && QuantumShieldHelper.hasValidShieldEquipment(player))) {
            return;
        }
        try {
            player.func_70606_j(player.func_110138_aP());
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 200, 4));
            event.setCanceled(true);
            PacketQuantumShield.issue(player.func_145782_y(), -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        ItemStack chest = player.func_71124_b(3);
        double energyRequired = (double)event.ammount * 1500.0;
        if (chest == null || !(chest.func_77973_b() instanceof ItemGraviChestPlate) || !GraviSuite.getOrCreateNbtData((ItemStack)chest).func_74767_n("isShieldActive")) {
            return;
        }
        if (!QuantumShieldHelper.hasValidShieldEquipment(player)) {
            QuantumShieldHelper.saveShieldMode(chest, false);
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.graviChestPlate.invalidSetupShieldBreak")));
            QuantumShieldHelper.notifyWorldShieldDown(player);
            return;
        }
        if (!ElectricItem.manager.canUse(chest, energyRequired)) {
            QuantumShieldHelper.saveShieldMode(chest, false);
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.graviChestPlate.lowpowerShieldBreak")));
            QuantumShieldHelper.notifyWorldShieldDown(player);
        }
        if (event.source instanceof DamageSources.EntityDamageSourcePlazma) {
            player.func_71029_a((StatBase)Achievements.QSHIELD_PLASMAIMPACT);
        }
        ElectricItem.manager.discharge(chest, energyRequired, Properties.ElectricPresets.GraviChestPlate.tier, true, false, false);
        player.field_70172_ad = 20;
        player.field_70737_aN = 0;
        event.ammount = 0.0f;
        if (event.isCancelable()) {
            event.setCanceled(true);
        } else {
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.func_76396_c(), 20, 4));
        }
        int target = -1;
        if (event.source.func_76346_g() != null) {
            target = event.source.func_76346_g().func_145782_y();
        }
        if (event.source == DamageSource.field_76379_h) {
            target = -2;
        }
        if (event.source == DamageSource.field_82729_p) {
            target = -3;
        }
        player.field_70170_p.func_72956_a((Entity)player, "gravisuiteneo:qshieldimpact", 1.25f, 1.0f);
        PacketQuantumShield.issue(player.func_145782_y(), target);
    }
}

