/*
 * Decompiled with CFR 0.152.
 */
package net.glease.ggfab.util;

import gregtech.api.util.GT_Utility;

public class OverclockHelper {
    public static OverclockOutput normalOverclock(long recipeEUt, int duration, long inputVoltage, boolean perfectOC) {
        int shift;
        if (recipeEUt > inputVoltage) {
            return null;
        }
        byte machineTier = GT_Utility.getTier((long)inputVoltage);
        int n = shift = perfectOC ? 2 : 1;
        for (int recipeTier = Math.max(1, GT_Utility.getTier((long)recipeEUt)); recipeTier < machineTier && duration > 1; ++recipeTier) {
            duration >>= shift;
            recipeEUt <<= 2;
        }
        return new OverclockOutput(recipeEUt, duration);
    }

    public static OverclockOutput laserOverclock(long recipeEUt, int duration, long inputEUt, float penaltyIncreaseFactor) {
        if (recipeEUt > inputEUt) {
            return null;
        }
        float currentPenalty = 4.0f + penaltyIncreaseFactor;
        while ((float)recipeEUt * currentPenalty > 0.0f && (float)recipeEUt * currentPenalty < (float)inputEUt && duration > 1) {
            duration >>= 1;
            recipeEUt = (long)((float)recipeEUt * currentPenalty);
            currentPenalty += penaltyIncreaseFactor;
        }
        return new OverclockOutput(recipeEUt, duration);
    }

    public static final class OverclockOutput {
        private final long mEUt;
        private final int mDuration;

        public OverclockOutput(long aEUt, int aDuration) {
            this.mEUt = aEUt;
            this.mDuration = aDuration;
        }

        public long getEUt() {
            return this.mEUt;
        }

        public int getDuration() {
            return this.mDuration;
        }

        public String toString() {
            return this.mEUt + "@" + this.mDuration + "ticks";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OverclockOutput)) {
                return false;
            }
            OverclockOutput that = (OverclockOutput)o;
            if (this.mEUt != that.mEUt) {
                return false;
            }
            return this.mDuration == that.mDuration;
        }

        public int hashCode() {
            int result = (int)(this.mEUt ^ this.mEUt >>> 32);
            result = 31 * result + this.mDuration;
            return result;
        }
    }
}

